/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractIdTextField;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ChangesetIdTextField
extends AbstractIdTextField<ChangesetIdValidator> {
    public ChangesetIdTextField() {
        super(ChangesetIdValidator.class, 10);
    }

    public final int getChangesetId() {
        return ((ChangesetIdValidator)this.validator).id;
    }

    @Override
    public boolean readIds() {
        return ((ChangesetIdValidator)this.validator).readChangesetId();
    }

    public static class ChangesetIdValidator
    extends AbstractTextComponentValidator {
        private int id;

        public ChangesetIdValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public boolean isValid() {
            return this.readChangesetId();
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid changeset ID. Please enter an integer value > 0 or a changeset URL.", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter an integer value > 0 or a changeset URL.", new Object[0]));
            }
        }

        public boolean readChangesetId() {
            String value = this.getComponent().getText();
            if (value != null && !value.trim().isEmpty()) {
                value = value.trim();
                this.id = 0;
                try {
                    int changesetId;
                    if (value.matches("http.*/changeset/[0-9]+")) {
                        value = value.substring(value.lastIndexOf(47) + 1);
                    }
                    if ((changesetId = Integer.parseInt(value)) > 0) {
                        this.id = changesetId;
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    Logging.trace(e);
                }
            }
            return false;
        }
    }
}

