/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.collections.ReadOnlyUnbackedObservableList;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.IndexedCheckModel;

public class CheckComboBoxSkin<T>
extends SkinBase<CheckComboBox<T>> {
    private final ComboBox<T> comboBox;
    private final ListCell<T> buttonCell;
    private final CheckComboBox<T> control;
    private final ObservableList<T> items;
    private final ReadOnlyUnbackedObservableList<Integer> selectedIndices;
    private final ReadOnlyUnbackedObservableList<T> selectedItems;

    public CheckComboBoxSkin(CheckComboBox<T> control) {
        super(control);
        this.control = control;
        this.items = control.getItems();
        this.selectedIndices = (ReadOnlyUnbackedObservableList)control.getCheckModel().getCheckedIndices();
        this.selectedItems = (ReadOnlyUnbackedObservableList)control.getCheckModel().getCheckedItems();
        this.comboBox = new ComboBox<T>(this.items){

            @Override
            protected Skin<?> createDefaultSkin() {
                return CheckComboBoxSkin.this.createComboBoxListViewSkin(this);
            }
        };
        this.comboBox.setFocusTraversable(false);
        this.comboBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Bindings.bindContent(control.getStyleClass(), this.comboBox.getStyleClass());
        this.comboBox.setCellFactory(listView -> {
            CheckBoxListCell<Object> result = new CheckBoxListCell<Object>(control::getItemBooleanProperty);
            result.focusedProperty().addListener((o, ov, nv) -> {
                if (nv.booleanValue()) {
                    result.getParent().requestFocus();
                }
            });
            result.setOnMouseClicked(e -> {
                Object item = result.getItem();
                if (control.getCheckModel().isChecked(item)) {
                    control.getCheckModel().clearCheck(item);
                } else {
                    control.getCheckModel().check(item);
                }
            });
            result.converterProperty().bind(control.converterProperty());
            return result;
        });
        this.buttonCell = new ListCell<T>(){

            @Override
            protected void updateItem(T item, boolean empty) {
                this.setText(CheckComboBoxSkin.this.getTextString());
            }
        };
        this.comboBox.setButtonCell(this.buttonCell);
        this.comboBox.setValue(this.getTextString());
        this.selectedIndices.addListener(c -> this.buttonCell.updateIndex(0));
        this.getChildren().add(this.comboBox);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.minWidth(height);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.minHeight(width);
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.prefWidth(height);
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.comboBox.prefHeight(width);
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((CheckComboBox)this.getSkinnable()).prefWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((CheckComboBox)this.getSkinnable()).prefHeight(width);
    }

    public void show() {
        this.comboBox.show();
    }

    public void hide() {
        this.comboBox.hide();
    }

    protected String getTextString() {
        if (this.control.getTitle() != null) {
            String vResult = this.control.getTitle();
            if (this.control.isShowCheckedCount()) {
                vResult = String.format("%s (%d/%d)", vResult, this.selectedItems.size(), this.items.size());
            }
            return vResult;
        }
        return this.buildString();
    }

    private String buildString() {
        StringBuilder sb = new StringBuilder();
        int max = this.selectedItems.size();
        for (int i = 0; i < max; ++i) {
            T item = this.selectedItems.get(i);
            if (this.control.getConverter() == null) {
                sb.append(item);
            } else {
                sb.append(this.control.getConverter().toString(item));
            }
            if (i >= max - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private Skin<?> createComboBoxListViewSkin(ComboBox<T> comboBox) {
        ComboBoxListViewSkin<T> comboBoxListViewSkin = new ComboBoxListViewSkin<T>(comboBox);
        comboBoxListViewSkin.setHideOnClick(false);
        ListView listView = (ListView)comboBoxListViewSkin.getPopupContent();
        listView.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.SPACE) {
                IndexedCheckModel checkModel;
                Object item = listView.getSelectionModel().getSelectedItem();
                if (item != null && (checkModel = this.control.getCheckModel()) != null) {
                    checkModel.toggleCheckState(item);
                }
            } else if (e.getCode() == KeyCode.ESCAPE) {
                this.hide();
            } else if (e.getCode() == KeyCode.TAB || new KeyCodeCombination(KeyCode.TAB, KeyCombination.SHIFT_ANY).match((KeyEvent)e)) {
                e.consume();
                this.hide();
                this.control.fireEvent(e);
            } else if (e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.RIGHT) {
                e.consume();
            }
        });
        return comboBoxListViewSkin;
    }
}

