/*
 * Decompiled with CFR 0.152.
 */
package mediathek.windows;

import com.sun.jna.platform.win32.Kernel32;
import java.awt.Taskbar;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import mediathek.tool.threads.IndicatorThread;
import mediathek.windows.MediathekGuiWindows;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskbarIndicatorThread
extends IndicatorThread {
    private final Taskbar taskbar;
    private final JFrame parent;
    private static final Logger logger = LogManager.getLogger(TaskbarIndicatorThread.class);

    public TaskbarIndicatorThread(MediathekGuiWindows parent) {
        this.setName("TaskbarIndicatorThread");
        this.taskbar = Taskbar.getTaskbar();
        this.parent = parent;
    }

    private void disableStandby() {
        int success = Kernel32.INSTANCE.SetThreadExecutionState(-2147483647);
        if (success == 0) {
            logger.error("disableStandby() failed!");
        }
    }

    private void enableStandby() {
        int success = Kernel32.INSTANCE.SetThreadExecutionState(Integer.MIN_VALUE);
        if (success == 0) {
            logger.error("enableStandby() failed!");
        }
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                int percentage = (int)this.calculateOverallPercentage();
                this.taskbar.setWindowProgressValue(this.parent, percentage);
                this.taskbar.setWindowProgressState(this.parent, Taskbar.State.NORMAL);
                this.disableStandby();
                TimeUnit.MILLISECONDS.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.taskbar.setWindowProgressState(this.parent, Taskbar.State.OFF);
            this.enableStandby();
        }
    }
}

