/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.drawable.Strokes;
import net.sf.sdedit.message.ConstructorMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Pair;

public class Fragment
extends Drawable {
    private String type;
    private String condition;
    private SequenceDiagram diagram;
    private Set<SequenceElement> includedElements;
    private int typeTextPadding;
    private int level;
    private List<Pair<Integer, String>> separators;

    public Fragment(String type, String condition, SequenceDiagram diagram) {
        super(diagram);
        if (type.equals("")) {
            this.type = condition + "  ";
            this.condition = "";
        } else {
            this.type = type + "  ";
            this.condition = condition.equals("") ? "" : "[" + condition + "]";
        }
        this.diagram = diagram;
        this.includedElements = new HashSet<SequenceElement>();
        this.typeTextPadding = diagram.getConfiguration().getFragmentTextPadding();
        this.level = 0;
        this.separators = new LinkedList<Pair<Integer, String>>();
    }

    public void setLevel(int level) {
        this.level = Math.max(this.level, level);
    }

    public String getCondition() {
        return this.condition;
    }

    public void addElement(SequenceElement element) {
        this.includedElements.add(element);
    }

    public void addSection(String sectionCondition) {
        int h = this.diagram.getPaintDevice().getTextHeight(true);
        this.diagram.extendLifelines(this.diagram.getConfiguration().getSeparatorTopMargin());
        this.separators.add(new Pair<Integer, String>(this.diagram.getVerticalPosition(), sectionCondition));
        this.diagram.extendLifelines(h + this.diagram.getConfiguration().getSeparatorBottomMargin() + 5);
    }

    public boolean containsElement(SequenceElement element) {
        return this.includedElements.contains(element);
    }

    @Override
    public void computeLayoutInformation() {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (SequenceElement element : this.includedElements) {
            int left = element.getLeft();
            int right = element.getLeft() + element.getWidth();
            if (element instanceof Arrow) {
                Message msg = ((Arrow)element).getMessage();
                if (msg instanceof ConstructorMessage) {
                    if (msg.getCallee().getPosition() < msg.getCaller().getPosition()) {
                        left = msg.getCallee().getHead().getLeft();
                    } else {
                        right = msg.getCallee().getHead().getLeft() + msg.getCallee().getHead().getWidth();
                    }
                }
                if (((Arrow)element).getStroke() != ArrowStroke.NONE) {
                    right += element.getRightEndpoint().getWidth();
                }
            }
            min = Math.min(min, left);
            max = Math.max(max, right);
        }
        int width = max - min;
        int padding = this.diagram.getConfiguration().getFragmentPadding();
        int margin = this.diagram.getConfiguration().getFragmentMargin();
        this.setLeft(min - padding - this.level * padding);
        this.setWidth(2 * this.level * padding + width + 2 * padding + margin);
    }

    public int getLabelHeight() {
        return this.diagram.getPaintDevice().getTextHeight(true) + 2;
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        int typeWidth = this.diagram.getPaintDevice().getTextWidth(this.type, true);
        int textWidth = this.diagram.getPaintDevice().getTextWidth(this.condition, true);
        int textHeight = this.diagram.getPaintDevice().getTextHeight(true);
        int leftMargin = typeWidth + 4 + this.typeTextPadding;
        g2d.setColor(this.diagram.getConfiguration().getFragmentLabelBgColor());
        g2d.fillRect(this.getLeft(), this.getTop(), typeWidth + 4, textHeight + 2);
        int thickness = this.diagram.getConfiguration().getFragmentBorderThickness();
        g2d.setStroke(Strokes.getStroke(Strokes.StrokeType.SOLID, thickness));
        g2d.setFont(this.diagram.getPaintDevice().getFont(true));
        g2d.setColor(this.diagram.getConfiguration().getFragmentEdgeColor());
        g2d.drawRect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        g2d.setColor(Color.BLACK);
        if (!this.type.equals("")) {
            g2d.drawLine(this.getLeft(), this.getTop() + textHeight + 2, this.getLeft() + typeWidth + this.typeTextPadding, this.getTop() + textHeight + 2);
            g2d.drawLine(this.getLeft() + typeWidth + this.typeTextPadding, this.getTop() + textHeight + 2, this.getLeft() + typeWidth + this.typeTextPadding + 2, this.getTop() + textHeight - 2);
            g2d.drawLine(this.getLeft() + typeWidth + this.typeTextPadding + 2, this.getTop() + textHeight - 2, this.getLeft() + typeWidth + this.typeTextPadding + 2, this.getTop());
            g2d.drawString(this.type, this.getLeft() + this.typeTextPadding, this.getTop() + textHeight - 1);
        }
        if (this.condition.length() > 0) {
            g2d.setColor(this.diagram.getConfiguration().getFragmentLabelBgColor());
            g2d.fillRect(this.getLeft() + leftMargin, this.getTop() + textHeight + 2, textWidth, textHeight);
            g2d.setColor(Color.BLACK);
            g2d.drawString(this.condition, this.getLeft() + leftMargin, this.getTop() + 2 * textHeight - 1);
        }
        for (Pair<Integer, String> sep : this.separators) {
            int y = sep.getFirst();
            g2d.setStroke(Strokes.getStroke(Strokes.StrokeType.DASHED, thickness));
            g2d.drawLine(this.getLeft(), y, this.getRight(), y);
            g2d.setStroke(Strokes.defaultStroke());
            g2d.drawString(sep.getSecond(), this.getLeft() + leftMargin, y + textHeight + this.diagram.getConfiguration().getSeparatorBottomMargin());
        }
    }
}

