/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.HandshakeCompletedListenerAdapter;
import org.bouncycastle.jsse.provider.PropertyUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class ProvSSLSocketBase
extends SSLSocket
implements BCSSLSocket {
    protected static final boolean provJdkTlsTrustNameService = PropertyUtils.getBooleanSystemProperty("jdk.tls.trustNameService", false);
    protected final Closeable socketCloser = new Closeable(){

        public void close() throws IOException {
            ProvSSLSocketBase.this.closeSocket();
        }
    };
    protected final Set<HandshakeCompletedListenerAdapter> listeners = Collections.synchronizedSet(new HashSet());

    protected ProvSSLSocketBase() {
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        this.listeners.add(new HandshakeCompletedListenerAdapter(handshakeCompletedListener));
    }

    protected void closeSocket() throws IOException {
        super.close();
    }

    public SocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    public boolean getOOBInline() throws SocketException {
        return false;
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        if (!this.listeners.remove(new HandshakeCompletedListenerAdapter(handshakeCompletedListener))) {
            throw new IllegalArgumentException("'listener' is not registered");
        }
    }

    public void sendUrgentData(int n) throws IOException {
        throw new UnsupportedOperationException("Urgent data not supported in TLS");
    }

    public void setOOBInline(boolean bl) throws SocketException {
        if (bl) {
            throw new UnsupportedOperationException("Urgent data not supported in TLS");
        }
    }

    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("shutdownInput() not supported in TLS");
    }

    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("shutdownOutput() not supported in TLS");
    }

    protected void implBind(InetAddress inetAddress, int n) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.bind(inetSocketAddress);
    }

    protected void implConnect(InetAddress inetAddress, int n) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    protected void implConnect(String string, int n) throws IOException, UnknownHostException {
        InetSocketAddress inetSocketAddress = null == string ? new InetSocketAddress(InetAddress.getByName(null), n) : new InetSocketAddress(string, n);
        this.connect(inetSocketAddress, 0);
    }
}

