/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.jdesktop.swingx.JXMapLayer;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXNewMapViewer
extends JXMapViewer {
    private static final Logger LOG = Logger.getLogger(JXNewMapViewer.class.getName());
    private final boolean isNegativeYAllowed = true;
    private int zoom = 1;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private boolean drawTileBorders = false;
    private TileFactory factory;
    private GeoPosition addressLocation;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private boolean recenterOnClickEnabled = true;
    private Painter<JXMapViewer> overlay;
    private boolean designTime;
    private Image loadingImage;
    private boolean restrictOutsidePanning = false;
    private boolean horizontalWrapped = true;
    private OverlayPainter overlayPainter;
    private AbstractPainter<JXMapViewer> mapLayer;
    public static final String VIEWPORT_CHANGE = "viewport";

    public JXNewMapViewer() {
        PanMouseInputListener mia = new PanMouseInputListener();
        this.setRecenterOnClickEnabled(false);
        this.addMouseListener(mia);
        this.addMouseMotionListener(mia);
        this.addMouseWheelListener(new ZoomMouseWheelListener());
        this.addKeyListener(new PanKeyListener());
        this.overlayPainter = new OverlayPainter();
        this.setMapLayer(new JXMapLayer());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JXNewMapViewer.this.fireViewPortChanged();
            }
        });
    }

    @Override
    public void setMapLayer(AbstractPainter<JXMapViewer> mapLayer) {
        this.mapLayer = mapLayer;
        this.setBackgroundPainter((Painter)new MapBackgroundPainter(mapLayer, this.overlayPainter));
    }

    private void fireViewPortChanged() {
        this.repaint();
        this.firePropertyChange(VIEWPORT_CHANGE, null, this.getViewportBounds());
    }

    private void doPaintComponent(Graphics g) {
        if (!this.isDesignTime()) {
            int zoom = this.getZoom();
            Rectangle viewportBounds = this.getViewportBounds();
            this.drawOverlays(zoom, g, viewportBounds);
        }
        super.paintBorder(g);
    }

    private void needsRepaint() {
        if (this.overlayPainter != null) {
            this.overlayPainter.needRepaint();
        }
        this.repaint(20L);
    }

    @Override
    public void setDesignTime(boolean b) {
        this.designTime = b;
    }

    @Override
    public boolean isDesignTime() {
        return this.designTime;
    }

    private void drawOverlays(int zoom, Graphics g, Rectangle viewportBounds) {
        if (this.overlay != null) {
            this.overlay.paint((Graphics2D)g, (Object)this, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setOverlayPainter(Painter overlay) {
        Painter old = this.getOverlayPainter();
        this.overlay = overlay;
        this.firePropertyChange("mapOverlay", old, this.getOverlayPainter());
        this.needsRepaint();
    }

    @Override
    public Painter getOverlayPainter() {
        return this.overlay;
    }

    @Override
    public Rectangle getViewportBounds() {
        return this.calculateViewportBounds(this.getCenter());
    }

    private Rectangle calculateViewportBounds(Point2D center) {
        Insets insets = this.getInsets();
        int viewportWidth = this.getWidth() - insets.left - insets.right;
        int viewportHeight = this.getHeight() - insets.top - insets.bottom;
        double viewportX = center.getX() - (double)(viewportWidth / 2);
        double viewportY = center.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }

    @Override
    public void setRecenterOnClickEnabled(boolean b) {
        boolean old = this.isRecenterOnClickEnabled();
        this.recenterOnClickEnabled = b;
        this.firePropertyChange("recenterOnClickEnabled", old, this.isRecenterOnClickEnabled());
    }

    @Override
    public boolean isRecenterOnClickEnabled() {
        return this.recenterOnClickEnabled;
    }

    @Override
    public void setZoom(int newZoom) {
        this.setZoom(this.getCenter(), newZoom);
    }

    @Override
    public void setZoom(Point2D zoomCenter, int newZoom) {
        TileFactoryInfo info = this.getTileFactory().getInfo();
        if (info != null && (newZoom < info.getMinimumZoomLevel() || newZoom > info.getMaximumZoomLevel())) {
            if (newZoom > info.getMaximumZoomLevel()) {
                newZoom = info.getMaximumZoomLevel();
            } else if (newZoom < info.getMinimumZoomLevel()) {
                newZoom = info.getMinimumZoomLevel();
            }
        }
        int oldZoom = this.zoom;
        Point2D oldCenter = this.getCenter();
        double xOffset = oldCenter.getX() - zoomCenter.getX();
        double yOffset = oldCenter.getY() - zoomCenter.getY();
        Dimension oldMapSize = this.getTileFactory().getMapSize(oldZoom);
        Dimension mapSize = this.getTileFactory().getMapSize(newZoom);
        this.setZoomAndCenter(new Point2D.Double(xOffset + zoomCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), yOffset + zoomCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight())), newZoom);
    }

    @Override
    public void setZoomAndCenter(Point2D center, int newZoom) {
        if (newZoom != this.zoom) {
            int oldZoom = this.zoom;
            this.zoom = newZoom;
            this.firePropertyChange("zoom", oldZoom, newZoom);
            this.needsRepaint();
        }
        this.setCenter(center);
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public GeoPosition getAddressLocation() {
        return this.addressLocation;
    }

    @Override
    public void setAddressLocation(GeoPosition addressLocation) {
        GeoPosition old = this.getAddressLocation();
        this.addressLocation = addressLocation;
        this.setCenter(this.getTileFactory().geoToPixel(addressLocation, this.getZoom()));
        this.firePropertyChange("addressLocation", old, this.getAddressLocation());
    }

    @Override
    public void recenterToAddressLocation() {
        this.setCenter(this.getTileFactory().geoToPixel(this.getAddressLocation(), this.getZoom()));
    }

    @Override
    public boolean isDrawTileBorders() {
        return this.drawTileBorders;
    }

    @Override
    public void setDrawTileBorders(boolean drawTileBorders) {
        boolean old = this.isDrawTileBorders();
        this.drawTileBorders = drawTileBorders;
        this.firePropertyChange("drawTileBorders", old, this.isDrawTileBorders());
        this.needsRepaint();
    }

    @Override
    public boolean isPanEnabled() {
        return this.panEnabled;
    }

    @Override
    public void setPanEnabled(boolean panEnabled) {
        boolean old = this.isPanEnabled();
        this.panEnabled = panEnabled;
        this.firePropertyChange("panEnabled", old, this.isPanEnabled());
    }

    @Override
    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    @Override
    public void setZoomEnabled(boolean zoomEnabled) {
        boolean old = this.isZoomEnabled();
        this.zoomEnabled = zoomEnabled;
        this.firePropertyChange("zoomEnabled", old, this.isZoomEnabled());
    }

    @Override
    public void setCenterPosition(GeoPosition geoPosition) {
        GeoPosition oldVal = this.getCenterPosition();
        this.setCenter(this.getTileFactory().geoToPixel(geoPosition, this.zoom));
        GeoPosition newVal = this.getCenterPosition();
        this.firePropertyChange("centerPosition", oldVal, newVal);
    }

    @Override
    public GeoPosition getCenterPosition() {
        return this.getTileFactory().pixelToGeo(this.getCenter(), this.zoom);
    }

    @Override
    public TileFactory getTileFactory() {
        return this.factory;
    }

    @Override
    public String getUniqueViewName() {
        return this.getName();
    }

    @Override
    public void setTileFactory(TileFactory factory) {
        if (this.factory != null) {
            this.factory.removeRequiredTiles(this.getUniqueViewName());
            this.factory = null;
        }
        this.factory = factory;
        this.setZoom(factory.getInfo().getDefaultZoomLevel());
        this.factory = factory;
        this.setZoom(factory.getInfo().getDefaultZoomLevel());
    }

    @Override
    public Image getLoadingImage() {
        return this.loadingImage;
    }

    @Override
    public void setLoadingImage(Image loadingImage) {
        this.loadingImage = loadingImage;
    }

    @Override
    public Point2D getCenter() {
        return this.center;
    }

    @Override
    public void setCenter(Point2D newCenter) {
        if (newCenter.equals(this.center)) {
            return;
        }
        Point2D oldCenter = this.center;
        if (this.isRestrictOutsidePanning()) {
            double centerX;
            Insets insets = this.getInsets();
            int viewportHeight = this.getHeight() - insets.top - insets.bottom;
            int viewportWidth = this.getWidth() - insets.left - insets.right;
            Rectangle newVP = this.calculateViewportBounds(newCenter);
            if (newVP.getY() < 0.0) {
                double centerY = viewportHeight / 2;
                newCenter = new Point2D.Double(newCenter.getX(), centerY);
            }
            if (!this.isHorizontalWrapped() && newVP.getX() < 0.0) {
                double centerX2 = viewportWidth / 2;
                newCenter = new Point2D.Double(centerX2, newCenter.getY());
            }
            Dimension mapSize = this.getTileFactory().getMapSize(this.getZoom());
            int mapHeight = (int)mapSize.getHeight() * this.getTileFactory().getTileSize(this.getZoom());
            if (newVP.getY() + newVP.getHeight() > (double)mapHeight) {
                double centerY = mapHeight - viewportHeight / 2;
                newCenter = new Point2D.Double(newCenter.getX(), centerY);
            }
            int mapWidth = (int)mapSize.getWidth() * this.getTileFactory().getTileSize(this.getZoom());
            if (!this.isHorizontalWrapped() && newVP.getX() + newVP.getWidth() > (double)mapWidth) {
                centerX = mapWidth - viewportWidth / 2;
                newCenter = new Point2D.Double(centerX, newCenter.getY());
            }
            if ((double)mapHeight < newVP.getHeight()) {
                double centerY = mapHeight / 2;
                newCenter = new Point2D.Double(newCenter.getX(), centerY);
            }
            if (!this.isHorizontalWrapped() && (double)mapWidth < newVP.getWidth()) {
                centerX = mapWidth / 2;
                newCenter = new Point2D.Double(centerX, newCenter.getY());
            }
        }
        GeoPosition oldGP = this.getCenterPosition();
        this.center = newCenter;
        this.firePropertyChange("center", oldCenter, this.center);
        this.firePropertyChange("centerPosition", oldGP, this.getCenterPosition());
        this.needsRepaint();
    }

    @Override
    public void calculateZoomFrom(Set<GeoPosition> positions) {
        Point2D.Double newCenter;
        if (positions.size() < 1) {
            return;
        }
        int newZoom = this.getTileFactory().getInfo().getMinimumZoomLevel();
        Rectangle2D rect = this.generateBoundingRect(positions, newZoom);
        while (!this.calculateViewportBounds(newCenter = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0)).contains(rect)) {
            if (++newZoom > this.getTileFactory().getInfo().getMaximumZoomLevel()) {
                newZoom = this.getTileFactory().getInfo().getMaximumZoomLevel();
                break;
            }
            rect = this.generateBoundingRect(positions, newZoom);
        }
        this.setZoomAndCenter(newCenter, newZoom);
    }

    private Rectangle2D generateBoundingRect(Set<GeoPosition> positions, int zoom) {
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        Rectangle2D rect = null;
        int ts = this.getTileFactory().getInfo().getTileSize(zoom);
        double mapHeight = mapSize.getHeight() * (double)ts;
        double mapWidth = mapSize.getWidth() * (double)ts;
        Rectangle2D.Double view = new Rectangle2D.Double(0.0, 0.0, mapWidth, mapHeight);
        for (GeoPosition pos : positions) {
            Point2D point = this.getTileFactory().geoToPixel(pos, zoom);
            if (!view.contains(point)) continue;
            if (rect == null) {
                rect = new Rectangle2D.Double(point.getX(), point.getY(), 1.0, 1.0);
                continue;
            }
            rect.add(point);
        }
        if (rect == null) {
            return view;
        }
        return rect;
    }

    private Point2D convertPointToPoint2D(Point p) {
        Rectangle bounds = this.getViewportBounds();
        double x = bounds.getX() + p.getX();
        double y = bounds.getY() + p.getY();
        return new Point2D.Double(x, y);
    }

    @Override
    public boolean isRestrictOutsidePanning() {
        return this.restrictOutsidePanning;
    }

    @Override
    public void setRestrictOutsidePanning(boolean restrictOutsidePanning) {
        this.restrictOutsidePanning = restrictOutsidePanning;
    }

    @Override
    public boolean isHorizontalWrapped() {
        return this.horizontalWrapped;
    }

    @Override
    public void setHorizontalWrapped(boolean horizontalWrapped) {
        this.horizontalWrapped = horizontalWrapped;
    }

    @Override
    public Point2D convertGeoPositionToPoint(GeoPosition pos) {
        Point2D pt = this.getTileFactory().geoToPixel(pos, this.getZoom());
        Rectangle bounds = this.getViewportBounds();
        return new Point2D.Double(pt.getX() - bounds.getX(), pt.getY() - bounds.getY());
    }

    @Override
    public GeoPosition convertPointToGeoPosition(Point2D pt) {
        Rectangle bounds = this.getViewportBounds();
        Point2D.Double pt2 = new Point2D.Double(pt.getX() + bounds.getX(), pt.getY() + bounds.getY());
        GeoPosition pos = this.getTileFactory().pixelToGeo(pt2, this.getZoom());
        return pos;
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.needsRepaint();
        }
    }

    static {
        LOG.setLevel(Level.SEVERE);
    }

    private class ZoomMouseWheelListener
    implements MouseWheelListener {
        private ZoomMouseWheelListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JXNewMapViewer.this.isZoomEnabled()) {
                JXNewMapViewer.this.setZoom(JXNewMapViewer.this.convertPointToPoint2D(e.getPoint()), JXNewMapViewer.this.getZoom() + e.getWheelRotation());
            }
        }
    }

    private class PanMouseInputListener
    implements MouseInputListener {
        Point prev;

        private PanMouseInputListener() {
        }

        public void mousePressed(MouseEvent evt) {
            this.prev = evt.getPoint();
            if (JXNewMapViewer.this.isRecenterOnClickEnabled() && (SwingUtilities.isMiddleMouseButton(evt) || SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2)) {
                this.recenterMap(evt);
            }
        }

        private void recenterMap(MouseEvent evt) {
            JXNewMapViewer.this.setCenter(JXNewMapViewer.this.convertPointToPoint2D(evt.getPoint()));
        }

        public void mouseDragged(MouseEvent evt) {
            if (JXNewMapViewer.this.isPanEnabled() && this.prev != null) {
                int maxHeight;
                Point current = evt.getPoint();
                double x = JXNewMapViewer.this.getCenter().getX() - (double)(current.x - this.prev.x);
                double y = JXNewMapViewer.this.getCenter().getY() - (double)(current.y - this.prev.y);
                if (y > (double)(maxHeight = (int)(JXNewMapViewer.this.getTileFactory().getMapSize(JXNewMapViewer.this.getZoom()).getHeight() * (double)JXNewMapViewer.this.getTileFactory().getTileSize(JXNewMapViewer.this.getZoom())))) {
                    y = maxHeight;
                }
                this.prev = current;
                JXNewMapViewer.this.setCenter(new Point2D.Double(x, y));
                JXNewMapViewer.this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        public void mouseReleased(MouseEvent evt) {
            this.prev = null;
            JXNewMapViewer.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseMoved(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JXNewMapViewer.this.requestFocusInWindow();
                }
            });
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class PanKeyListener
    extends KeyAdapter {
        private static final int OFFSET = 10;
        private static final int MULTIPLIER = 10;

        private PanKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            int oldzoom;
            super.keyTyped(e);
            int newzoom = oldzoom = JXNewMapViewer.this.getZoom();
            switch (e.getKeyChar()) {
                case '+': {
                    --newzoom;
                    break;
                }
                case '-': {
                    ++newzoom;
                }
            }
            if (newzoom != oldzoom) {
                JXNewMapViewer.this.setZoom(newzoom);
            }
        }

        public void keyPressed(KeyEvent e) {
            int delta_x = 0;
            int delta_y = 0;
            switch (e.getKeyCode()) {
                case 37: {
                    delta_x = -10;
                    break;
                }
                case 39: {
                    delta_x = 10;
                    break;
                }
                case 38: {
                    delta_y = -10;
                    break;
                }
                case 40: {
                    delta_y = 10;
                }
            }
            if (delta_x != 0 || delta_y != 0) {
                int mod = e.getModifiers();
                if ((mod & 2) != 0 || (mod & 0x80) != 0) {
                    delta_x *= 10;
                    delta_y *= 10;
                }
                if ((mod & 1) != 0 || (mod & 0x40) != 0) {
                    delta_x *= 10;
                    delta_y *= 10;
                }
                Rectangle bounds = JXNewMapViewer.this.getViewportBounds();
                double x = bounds.getCenterX() + (double)delta_x;
                double y = bounds.getCenterY() + (double)delta_y;
                JXNewMapViewer.this.setCenter(new Point2D.Double(x, y));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OverlayPainter
    extends AbstractPainter<JXPanel> {
        private OverlayPainter() {
        }

        protected void doPaint(Graphics2D g, JXPanel component, int width, int height) {
            JXNewMapViewer.this.doPaintComponent(g);
        }

        public void needRepaint() {
            this.setDirty(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapBackgroundPainter
    extends CompoundPainter<JXMapViewer> {
        public MapBackgroundPainter(AbstractPainter<JXMapViewer> mapLayer, AbstractPainter<JXPanel> backgroundPainter) {
            super(new Painter[]{mapLayer, backgroundPainter});
            mapLayer.addPropertyChangeListener("dirty", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        JXNewMapViewer.this.repaint(20L);
                        MapBackgroundPainter.this.setDirty(true);
                    }
                }
            });
        }
    }
}

