/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.Version;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComponentTemplateMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.DiffableStringMap;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateV2;
import org.elasticsearch.cluster.metadata.IndexTemplateV2Metadata;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.rest.RestStatus;

public class MetaData
implements Iterable<IndexMetaData>,
Diffable<MetaData>,
ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(MetaData.class);
    public static final String ALL = "_all";
    public static final String UNKNOWN_CLUSTER_UUID = "_na_";
    public static EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static EnumSet<XContentContext> ALL_CONTEXTS = EnumSet.allOf(XContentContext.class);
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_NODE = Setting.intSetting("cluster.max_shards_per_node", 1000, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final MetaData EMPTY_META_DATA = MetaData.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private final String clusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long version;
    private final CoordinationMetaData coordinationMetaData;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final DiffableStringMap hashesOfConsistentSettings;
    private final ImmutableOpenMap<String, IndexMetaData> indices;
    private final ImmutableOpenMap<String, IndexTemplateMetaData> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final String[] allIndices;
    private final String[] visibleIndices;
    private final String[] allOpenIndices;
    private final String[] visibleOpenIndices;
    private final String[] allClosedIndices;
    private final String[] visibleClosedIndices;
    private final SortedMap<String, AliasOrIndex> aliasAndIndexLookup;
    private static final ToXContent.Params FORMAT_PARAMS;
    public static final MetaDataStateFormat<MetaData> FORMAT;

    MetaData(String clusterUUID, boolean clusterUUIDCommitted, long version, CoordinationMetaData coordinationMetaData, Settings transientSettings, Settings persistentSettings, DiffableStringMap hashesOfConsistentSettings, ImmutableOpenMap<String, IndexMetaData> indices, ImmutableOpenMap<String, IndexTemplateMetaData> templates, ImmutableOpenMap<String, Custom> customs, String[] allIndices, String[] visibleIndices, String[] allOpenIndices, String[] visibleOpenIndices, String[] allClosedIndices, String[] visibleClosedIndices, SortedMap<String, AliasOrIndex> aliasAndIndexLookup) {
        this.clusterUUID = clusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.version = version;
        this.coordinationMetaData = coordinationMetaData;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = Settings.builder().put(persistentSettings).put(transientSettings).build();
        this.hashesOfConsistentSettings = hashesOfConsistentSettings;
        this.indices = indices;
        this.customs = customs;
        this.templates = templates;
        int totalNumberOfShards = 0;
        int totalOpenIndexShards = 0;
        for (ObjectCursor cursor : indices.values()) {
            totalNumberOfShards += ((IndexMetaData)cursor.value).getTotalNumberOfShards();
            if (!IndexMetaData.State.OPEN.equals((Object)((IndexMetaData)cursor.value).getState())) continue;
            totalOpenIndexShards += ((IndexMetaData)cursor.value).getTotalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.allIndices = allIndices;
        this.visibleIndices = visibleIndices;
        this.allOpenIndices = allOpenIndices;
        this.visibleOpenIndices = visibleOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.visibleClosedIndices = visibleClosedIndices;
        this.aliasAndIndexLookup = aliasAndIndexLookup;
    }

    public long version() {
        return this.version;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public boolean clusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public Map<String, String> hashesOfConsistentSettings() {
        return this.hashesOfConsistentSettings;
    }

    public CoordinationMetaData coordinationMetaData() {
        return this.coordinationMetaData;
    }

    public boolean hasAlias(String alias) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)this.getAliasAndIndexLookup().get(alias);
        if (aliasOrIndex != null) {
            return aliasOrIndex.isAlias();
        }
        return false;
    }

    public boolean equalsAliases(MetaData other) {
        for (ObjectCursor cursor : other.indices().values()) {
            IndexMetaData otherIndex = (IndexMetaData)cursor.value;
            IndexMetaData thisIndex = this.index(otherIndex.getIndex());
            if (thisIndex == null) {
                return false;
            }
            if (otherIndex.getAliases().equals(thisIndex.getAliases())) continue;
            return false;
        }
        return true;
    }

    public SortedMap<String, AliasOrIndex> getAliasAndIndexLookup() {
        return this.aliasAndIndexLookup;
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> findAllAliases(String[] concreteIndices) {
        return this.findAliases(Strings.EMPTY_ARRAY, concreteIndices);
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> findAliases(AliasesRequest aliasesRequest, String[] concreteIndices) {
        return this.findAliases(aliasesRequest.aliases(), concreteIndices);
    }

    private ImmutableOpenMap<String, List<AliasMetaData>> findAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        String[] patterns = new String[aliases.length];
        boolean[] include = new boolean[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias.charAt(0) == '-') {
                patterns[i] = alias.substring(1);
                include[i] = false;
                continue;
            }
            patterns[i] = alias;
            include[i] = true;
        }
        boolean matchAllAliases = patterns.length == 0;
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        for (String index : concreteIndices) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = new ArrayList<AliasMetaData>();
            for (ObjectCursor cursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)cursor.value;
                boolean matched = matchAllAliases;
                String alias = value.alias();
                for (int i = 0; i < patterns.length; ++i) {
                    if (include[i]) {
                        if (matched) continue;
                        String pattern = patterns[i];
                        matched = ALL.equals(pattern) || Regex.simpleMatch(pattern, alias);
                        continue;
                    }
                    if (!matched) continue;
                    matched = !Regex.simpleMatch(patterns[i], alias);
                }
                if (!matched) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            CollectionUtil.timSort(filteredValues, Comparator.comparing(AliasMetaData::alias));
            mapBuilder.put(index, Collections.unmodifiableList(filteredValues));
        }
        return mapBuilder.build();
    }

    public boolean hasAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return false;
        }
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = new ArrayList<AliasMetaData>();
            for (ObjectCursor cursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)cursor.value;
                if (!Regex.simpleMatch(aliases, value.alias())) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> findMappings(String[] concreteIndices, String[] types, Function<String, Predicate<String>> fieldFilter) throws IOException {
        assert (types != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        boolean isAllTypes = MetaData.isAllTypes(types);
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            Predicate<String> fieldPredicate = fieldFilter.apply(index);
            if (isAllTypes) {
                indexMapBuilder.put(index, MetaData.filterFields(indexMetaData.getMappings(), fieldPredicate));
                continue;
            }
            ImmutableOpenMap.Builder<String, MappingMetaData> filteredMappings = ImmutableOpenMap.builder();
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.getMappings()) {
                if (!Regex.simpleMatch(types, (String)objectObjectCursor.key)) continue;
                filteredMappings.put((String)objectObjectCursor.key, MetaData.filterFields((MappingMetaData)objectObjectCursor.value, fieldPredicate));
            }
            if (filteredMappings.isEmpty()) continue;
            indexMapBuilder.put(index, filteredMappings.build());
        }
        return indexMapBuilder.build();
    }

    private static ImmutableOpenMap<String, MappingMetaData> filterFields(ImmutableOpenMap<String, MappingMetaData> mappings, Predicate<String> fieldPredicate) throws IOException {
        if (fieldPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
            return mappings;
        }
        ImmutableOpenMap.Builder<String, MappingMetaData> builder = ImmutableOpenMap.builder(mappings.size());
        for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : mappings) {
            builder.put((String)objectObjectCursor.key, MetaData.filterFields((MappingMetaData)objectObjectCursor.value, fieldPredicate));
        }
        return builder.build();
    }

    private static MappingMetaData filterFields(MappingMetaData mappingMetaData, Predicate<String> fieldPredicate) throws IOException {
        if (fieldPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
            return mappingMetaData;
        }
        Map sourceAsMap = (Map)XContentHelper.convertToMap(mappingMetaData.source().compressedReference(), true).v2();
        Map mapping = sourceAsMap.size() == 1 && sourceAsMap.containsKey(mappingMetaData.type()) ? (Map)sourceAsMap.get(mappingMetaData.type()) : sourceAsMap;
        Map properties = (Map)mapping.get("properties");
        if (properties == null || properties.isEmpty()) {
            return mappingMetaData;
        }
        MetaData.filterFields("", properties, fieldPredicate);
        return new MappingMetaData(mappingMetaData.type(), sourceAsMap);
    }

    private static boolean filterFields(String currentPath, Map<String, Object> fields, Predicate<String> fieldPredicate) {
        assert (fieldPredicate != MapperPlugin.NOOP_FIELD_PREDICATE);
        Iterator<Map.Entry<String, Object>> entryIterator = fields.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map map;
            Map.Entry<String, Object> entry = entryIterator.next();
            String newPath = MetaData.mergePaths(currentPath, entry.getKey());
            Object value = entry.getValue();
            boolean mayRemove = true;
            boolean isMultiField = false;
            if (value instanceof Map) {
                map = (Map)value;
                Map properties = (Map)map.get("properties");
                if (properties != null) {
                    mayRemove = MetaData.filterFields(newPath, properties, fieldPredicate);
                } else {
                    Map subFields = (Map)map.get("fields");
                    if (subFields != null) {
                        isMultiField = true;
                        mayRemove = MetaData.filterFields(newPath, subFields, fieldPredicate);
                        if (mayRemove) {
                            map.remove("fields");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("cannot filter mappings, found unknown element of type [" + value.getClass() + "]");
            }
            if (fieldPredicate.test(newPath)) continue;
            if (mayRemove) {
                entryIterator.remove();
                continue;
            }
            if (!isMultiField) continue;
            map = (Map)value;
            Map subFields = (Map)map.get("fields");
            assert (subFields.size() > 0);
            map.put("properties", subFields);
            map.remove("fields");
            map.remove("type");
        }
        return fields.size() == 0;
    }

    private static String mergePaths(String path, String field) {
        if (path.length() == 0) {
            return field;
        }
        return path + "." + field;
    }

    public String[] getConcreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteVisibleIndices() {
        return this.visibleIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteVisibleOpenIndices() {
        return this.visibleOpenIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String[] getConcreteVisibleClosedIndices() {
        return this.visibleClosedIndices;
    }

    public String resolveWriteIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        AliasOrIndex result = (AliasOrIndex)this.getAliasAndIndexLookup().get(aliasOrIndex);
        if (result == null || !result.isAlias()) {
            return routing;
        }
        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)result;
        IndexMetaData writeIndex = alias.getWriteIndex();
        if (writeIndex == null) {
            throw new IllegalArgumentException("alias [" + aliasOrIndex + "] does not have a write index");
        }
        AliasMetaData aliasMd = writeIndex.getAliases().get(alias.getAliasName());
        if (aliasMd.indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return routing;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        AliasMetaData aliasMd;
        if (aliasOrIndex == null) {
            return routing;
        }
        AliasOrIndex result = (AliasOrIndex)this.getAliasAndIndexLookup().get(aliasOrIndex);
        if (result == null || !result.isAlias()) {
            return routing;
        }
        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)result;
        if (result.getIndices().size() > 1) {
            this.rejectSingleIndexOperation(aliasOrIndex, result);
        }
        if ((aliasMd = alias.getFirstAliasMetaData()).indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return routing;
    }

    private void rejectSingleIndexOperation(String aliasOrIndex, AliasOrIndex result) {
        Object[] indexNames = new String[result.getIndices().size()];
        int i = 0;
        for (IndexMetaData indexMetaData : result.getIndices()) {
            indexNames[i++] = indexMetaData.getIndex().getName();
        }
        throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasConcreteIndex(String index) {
        return this.getAliasAndIndexLookup().containsKey(index);
    }

    public IndexMetaData index(String index) {
        return this.indices.get(index);
    }

    public IndexMetaData index(Index index) {
        IndexMetaData metaData = this.index(index.getName());
        if (metaData != null && metaData.getIndexUUID().equals(index.getUUID())) {
            return metaData;
        }
        return null;
    }

    public boolean hasIndexMetaData(IndexMetaData indexMetaData) {
        return this.indices.get(indexMetaData.getIndex().getName()) == indexMetaData;
    }

    public IndexMetaData getIndexSafe(Index index) {
        IndexMetaData metaData = this.index(index.getName());
        if (metaData != null) {
            if (metaData.getIndexUUID().equals(index.getUUID())) {
                return metaData;
            }
            throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + metaData.getIndexUUID() + "]"));
        }
        throw new IndexNotFoundException(index);
    }

    public ImmutableOpenMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableOpenMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public Map<String, ComponentTemplate> componentTemplates() {
        return Optional.ofNullable((ComponentTemplateMetadata)this.custom("component_template")).map(ComponentTemplateMetadata::componentTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, IndexTemplateV2> templatesV2() {
        return Optional.ofNullable((IndexTemplateV2Metadata)this.custom("index_template")).map(IndexTemplateV2Metadata::indexTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, DataStream> dataStreams() {
        return Optional.ofNullable((DataStreamMetadata)this.custom("data_stream")).map(DataStreamMetadata::dataStreams).orElse(Collections.emptyMap());
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    public static boolean isAllTypes(String[] types) {
        return types == null || types.length == 0 || MetaData.isExplicitAllType(types);
    }

    public static boolean isExplicitAllType(String[] types) {
        return types != null && types.length == 1 && ALL.equals(types[0]);
    }

    public boolean routingRequired(String concreteIndex) {
        MappingMetaData mappingMetaData;
        IndexMetaData indexMetaData = this.indices.get(concreteIndex);
        if (indexMetaData != null && (mappingMetaData = indexMetaData.mapping()) != null) {
            return mappingMetaData.routing().required();
        }
        return false;
    }

    @Override
    public Iterator<IndexMetaData> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(MetaData metaData1, MetaData metaData2) {
        if (!metaData1.coordinationMetaData.equals(metaData2.coordinationMetaData)) {
            return false;
        }
        if (!metaData1.persistentSettings.equals(metaData2.persistentSettings)) {
            return false;
        }
        if (!metaData1.hashesOfConsistentSettings.equals(metaData2.hashesOfConsistentSettings)) {
            return false;
        }
        if (!metaData1.templates.equals(metaData2.templates())) {
            return false;
        }
        if (!metaData1.clusterUUID.equals(metaData2.clusterUUID)) {
            return false;
        }
        if (metaData1.clusterUUIDCommitted != metaData2.clusterUUIDCommitted) {
            return false;
        }
        int customCount1 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metaData1.customs) {
            if (!((Custom)objectObjectCursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!((Custom)objectObjectCursor.value).equals(metaData2.custom((String)objectObjectCursor.key))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (ObjectCursor cursor : metaData2.customs.values()) {
            if (!((Custom)cursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    @Override
    public Diff<MetaData> diff(MetaData previousState) {
        return new MetaDataDiff(previousState, this);
    }

    public static Diff<MetaData> readDiffFrom(StreamInput in) throws IOException {
        return new MetaDataDiff(in);
    }

    public static MetaData fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static MetaData readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder();
        builder.version = in.readLong();
        builder.clusterUUID = in.readString();
        if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
            builder.clusterUUIDCommitted = in.readBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
            builder.coordinationMetaData(new CoordinationMetaData(in));
        }
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            builder.hashesOfConsistentSettings(new DiffableStringMap(in));
        }
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetaData.readFrom(in), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetaData.readFrom(in));
        }
        int customSize = in.readVInt();
        for (int i2 = 0; i2 < customSize; ++i2) {
            Custom customIndexMetaData = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetaData.getWriteableName(), customIndexMetaData);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.clusterUUID);
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeBoolean(this.clusterUUIDCommitted);
        }
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            this.coordinationMetaData.writeTo(out);
        }
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.hashesOfConsistentSettings.writeTo(out);
        }
        out.writeVInt(this.indices.size());
        for (IndexMetaData indexMetaData : this) {
            indexMetaData.writeTo(out);
        }
        out.writeVInt(this.templates.size());
        for (ObjectCursor cursor : this.templates.values()) {
            ((IndexTemplateMetaData)cursor.value).writeTo(out);
        }
        int numberOfCustoms = 0;
        for (ObjectCursor cursor : this.customs.values()) {
            if (!ClusterState.FeatureAware.shouldSerialize(out, (Custom)cursor.value)) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (ObjectCursor cursor : this.customs.values()) {
            if (!ClusterState.FeatureAware.shouldSerialize(out, (Custom)cursor.value)) continue;
            out.writeNamedWriteable((NamedWriteable)cursor.value);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetaData metaData) {
        return new Builder(metaData);
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put(CONTEXT_MODE_PARAM, CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
        FORMAT = new MetaDataStateFormat<MetaData>(GLOBAL_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, MetaData state) throws IOException {
                Builder.toXContent(state, builder, FORMAT_PARAMS);
            }

            @Override
            public MetaData fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser);
            }
        };
    }

    public static interface Custom
    extends NamedDiffable<Custom>,
    ToXContentFragment,
    ClusterState.FeatureAware {
        public EnumSet<XContentContext> context();
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }

    private static class MetaDataDiff
    implements Diff<MetaData> {
        private long version;
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private CoordinationMetaData coordinationMetaData;
        private Settings transientSettings;
        private Settings persistentSettings;
        private Diff<DiffableStringMap> hashesOfConsistentSettings;
        private Diff<ImmutableOpenMap<String, IndexMetaData>> indices;
        private Diff<ImmutableOpenMap<String, IndexTemplateMetaData>> templates;
        private Diff<ImmutableOpenMap<String, Custom>> customs;

        MetaDataDiff(MetaData before, MetaData after) {
            this.clusterUUID = after.clusterUUID;
            this.clusterUUIDCommitted = after.clusterUUIDCommitted;
            this.version = after.version;
            this.coordinationMetaData = after.coordinationMetaData;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            this.hashesOfConsistentSettings = after.hashesOfConsistentSettings.diff(before.hashesOfConsistentSettings);
            this.indices = DiffableUtils.diff(before.indices, after.indices, DiffableUtils.getStringKeySerializer());
            this.templates = DiffableUtils.diff(before.templates, after.templates, DiffableUtils.getStringKeySerializer());
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        MetaDataDiff(StreamInput in) throws IOException {
            this.clusterUUID = in.readString();
            if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
                this.clusterUUIDCommitted = in.readBoolean();
            }
            this.version = in.readLong();
            this.coordinationMetaData = in.getVersion().onOrAfter(Version.V_7_0_0) ? new CoordinationMetaData(in) : CoordinationMetaData.EMPTY_META_DATA;
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.hashesOfConsistentSettings = in.getVersion().onOrAfter(Version.V_7_3_0) ? DiffableStringMap.readDiffFrom(in) : DiffableStringMap.DiffableStringMapDiff.EMPTY;
            this.indices = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), IndexMetaData::readFrom, IndexMetaData::readDiffFrom);
            this.templates = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), IndexTemplateMetaData::readFrom, IndexTemplateMetaData::readDiffFrom);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterUUID);
            if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
                out.writeBoolean(this.clusterUUIDCommitted);
            }
            out.writeLong(this.version);
            if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
                this.coordinationMetaData.writeTo(out);
            }
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
            if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                this.hashesOfConsistentSettings.writeTo(out);
            }
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public MetaData apply(MetaData part) {
            Builder builder = MetaData.builder();
            builder.clusterUUID(this.clusterUUID);
            builder.clusterUUIDCommitted(this.clusterUUIDCommitted);
            builder.version(this.version);
            builder.coordinationMetaData(this.coordinationMetaData);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.hashesOfConsistentSettings(this.hashesOfConsistentSettings.apply(part.hashesOfConsistentSettings));
            builder.indices(this.indices.apply(part.indices));
            builder.templates(this.templates.apply(part.templates));
            builder.customs(this.customs.apply(part.customs));
            return builder.build();
        }
    }

    public static class Builder {
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private long version;
        private CoordinationMetaData coordinationMetaData = CoordinationMetaData.EMPTY_META_DATA;
        private Settings transientSettings = Settings.Builder.EMPTY_SETTINGS;
        private Settings persistentSettings = Settings.Builder.EMPTY_SETTINGS;
        private DiffableStringMap hashesOfConsistentSettings = new DiffableStringMap(Collections.emptyMap());
        private final ImmutableOpenMap.Builder<String, IndexMetaData> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetaData> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder() {
            this.clusterUUID = MetaData.UNKNOWN_CLUSTER_UUID;
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.indexGraveyard(IndexGraveyard.builder().build());
        }

        public Builder(MetaData metaData) {
            this.clusterUUID = metaData.clusterUUID;
            this.clusterUUIDCommitted = metaData.clusterUUIDCommitted;
            this.coordinationMetaData = metaData.coordinationMetaData;
            this.transientSettings = metaData.transientSettings;
            this.persistentSettings = metaData.persistentSettings;
            this.hashesOfConsistentSettings = metaData.hashesOfConsistentSettings;
            this.version = metaData.version;
            this.indices = ImmutableOpenMap.builder(metaData.indices);
            this.templates = ImmutableOpenMap.builder(metaData.templates);
            this.customs = ImmutableOpenMap.builder(metaData.customs);
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            indexMetaDataBuilder.version(indexMetaDataBuilder.version() + 1L);
            IndexMetaData indexMetaData = indexMetaDataBuilder.build();
            this.indices.put(indexMetaData.getIndex().getName(), indexMetaData);
            return this;
        }

        public Builder put(IndexMetaData indexMetaData, boolean incrementVersion) {
            if (this.indices.get(indexMetaData.getIndex().getName()) == indexMetaData) {
                return this;
            }
            if (incrementVersion) {
                indexMetaData = IndexMetaData.builder(indexMetaData).version(indexMetaData.getVersion() + 1L).build();
            }
            this.indices.put(indexMetaData.getIndex().getName(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index) {
            return this.indices.get(index);
        }

        public IndexMetaData getSafe(Index index) {
            IndexMetaData indexMetaData = this.get(index.getName());
            if (indexMetaData != null) {
                if (indexMetaData.getIndexUUID().equals(index.getUUID())) {
                    return indexMetaData;
                }
                throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + indexMetaData.getIndexUUID() + "]"));
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder indices(ImmutableOpenMap<String, IndexMetaData> indices) {
            this.indices.putAll(indices);
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(ImmutableOpenMap<String, IndexTemplateMetaData> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public Builder put(String name, ComponentTemplate componentTemplate) {
            Objects.requireNonNull(componentTemplate, "it is invalid to add a null component template: " + name);
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.put(name, componentTemplate);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeComponentTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder componentTemplates(Map<String, ComponentTemplate> componentTemplates) {
            this.customs.put("component_template", new ComponentTemplateMetadata(componentTemplates));
            return this;
        }

        public Builder indexTemplates(Map<String, IndexTemplateV2> indexTemplates) {
            this.customs.put("index_template", new IndexTemplateV2Metadata(indexTemplates));
            return this;
        }

        public Builder put(String name, IndexTemplateV2 indexTemplate) {
            Objects.requireNonNull(indexTemplate, "it is invalid to add a null index template: " + name);
            Map existingTemplates = Optional.ofNullable((IndexTemplateV2Metadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, IndexTemplateV2>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.put(name, indexTemplate);
            this.customs.put("index_template", new IndexTemplateV2Metadata(existingTemplates));
            return this;
        }

        public Builder removeIndexTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((IndexTemplateV2Metadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, IndexTemplateV2>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("index_template", new IndexTemplateV2Metadata(existingTemplates));
            return this;
        }

        public Builder dataStreams(Map<String, DataStream> dataStreams) {
            this.customs.put("data_stream", new DataStreamMetadata(dataStreams));
            return this;
        }

        public Builder put(DataStream dataStream) {
            Objects.requireNonNull(dataStream, "it is invalid to add a null data stream");
            Map existingDataStreams = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            existingDataStreams.put(dataStream.getName(), dataStream);
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStreams));
            return this;
        }

        public Builder removeDataStream(String name) {
            Map existingDataStreams = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            existingDataStreams.remove(name);
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStreams));
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            StreamSupport.stream(customs.spliterator(), false).forEach(cursor -> Objects.requireNonNull((Custom)cursor.value, (String)cursor.key));
            this.customs.putAll(customs);
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            this.putCustom("index-graveyard", indexGraveyard);
            return this;
        }

        public IndexGraveyard indexGraveyard() {
            IndexGraveyard graveyard = (IndexGraveyard)this.getCustom("index-graveyard");
            return graveyard;
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = (String[])this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetaData.builder(indexMetaData).settings(Settings.builder().put(indexMetaData.getSettings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetaData.builder(indexMetaData).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Builder coordinationMetaData(CoordinationMetaData coordinationMetaData) {
            this.coordinationMetaData = coordinationMetaData;
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public DiffableStringMap hashesOfConsistentSettings() {
            return this.hashesOfConsistentSettings;
        }

        public Builder hashesOfConsistentSettings(DiffableStringMap hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = hashesOfConsistentSettings;
            return this;
        }

        public Builder hashesOfConsistentSettings(Map<String, String> hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = new DiffableStringMap(hashesOfConsistentSettings);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals(MetaData.UNKNOWN_CLUSTER_UUID)) {
                this.clusterUUID = UUIDs.randomBase64UUID();
            }
            return this;
        }

        public MetaData build() {
            HashSet<String> allIndices = new HashSet<String>(this.indices.size());
            ArrayList<Object> visibleIndices = new ArrayList<Object>();
            ArrayList<Object> allOpenIndices = new ArrayList<Object>();
            ArrayList<Object> visibleOpenIndices = new ArrayList<Object>();
            ArrayList<Object> allClosedIndices = new ArrayList<Object>();
            ArrayList<Object> visibleClosedIndices = new ArrayList<Object>();
            HashSet duplicateAliasesIndices = new HashSet();
            for (Object cursor : this.indices.values()) {
                boolean visible;
                IndexMetaData indexMetaData = (IndexMetaData)((ObjectCursor)cursor).value;
                String name = indexMetaData.getIndex().getName();
                boolean added = allIndices.add(name);
                assert (added) : "double index named [" + (String)name + "]";
                boolean bl = visible = IndexMetaData.INDEX_HIDDEN_SETTING.get(indexMetaData.getSettings()) == false;
                if (visible) {
                    visibleIndices.add(name);
                }
                if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                    allOpenIndices.add(name);
                    if (visible) {
                        visibleOpenIndices.add(name);
                    }
                } else if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                    allClosedIndices.add(name);
                    if (visible) {
                        visibleClosedIndices.add(name);
                    }
                }
                indexMetaData.getAliases().keysIt().forEachRemaining(duplicateAliasesIndices::add);
            }
            duplicateAliasesIndices.retainAll(allIndices);
            if (!duplicateAliasesIndices.isEmpty()) {
                ArrayList<String> duplicates = new ArrayList<String>();
                for (ObjectCursor cursor : this.indices.values()) {
                    for (String alias : duplicateAliasesIndices) {
                        if (!((IndexMetaData)cursor.value).getAliases().containsKey(alias)) continue;
                        duplicates.add(alias + " (alias of " + ((IndexMetaData)cursor.value).getIndex() + ")");
                    }
                }
                assert (duplicates.size() > 0);
                throw new IllegalStateException("index and alias names need to be unique, but the following duplicates were found [" + Strings.collectionToCommaDelimitedString(duplicates) + "]");
            }
            SortedMap<String, AliasOrIndex> aliasAndIndexLookup = Collections.unmodifiableSortedMap(this.buildAliasAndIndexLookup());
            String[] allIndicesArray = allIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleIndicesArray = visibleIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allOpenIndicesArray = allOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleOpenIndicesArray = visibleOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allClosedIndicesArray = allClosedIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleClosedIndicesArray = visibleClosedIndices.toArray(Strings.EMPTY_ARRAY);
            return new MetaData(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetaData, this.transientSettings, this.persistentSettings, this.hashesOfConsistentSettings, this.indices.build(), this.templates.build(), this.customs.build(), allIndicesArray, visibleIndicesArray, allOpenIndicesArray, visibleOpenIndicesArray, allClosedIndicesArray, visibleClosedIndicesArray, aliasAndIndexLookup);
        }

        private SortedMap<String, AliasOrIndex> buildAliasAndIndexLookup() {
            TreeMap<String, AliasOrIndex> aliasAndIndexLookup = new TreeMap<String, AliasOrIndex>();
            for (ObjectCursor cursor : this.indices.values()) {
                IndexMetaData indexMetaData = (IndexMetaData)cursor.value;
                AliasOrIndex existing = aliasAndIndexLookup.put(indexMetaData.getIndex().getName(), new AliasOrIndex.Index(indexMetaData));
                assert (existing == null) : "duplicate for " + indexMetaData.getIndex();
                for (ObjectObjectCursor<String, AliasMetaData> aliasCursor : indexMetaData.getAliases()) {
                    AliasMetaData aliasMetaData = (AliasMetaData)aliasCursor.value;
                    aliasAndIndexLookup.compute(aliasMetaData.getAlias(), (aliasName, alias) -> {
                        if (alias == null) {
                            return new AliasOrIndex.Alias(aliasMetaData, indexMetaData);
                        }
                        assert (alias instanceof AliasOrIndex.Alias) : alias.getClass().getName();
                        ((AliasOrIndex.Alias)alias).addIndex(indexMetaData);
                        return alias;
                    });
                }
            }
            aliasAndIndexLookup.values().stream().filter(AliasOrIndex::isAlias).forEach(alias -> ((AliasOrIndex.Alias)alias).computeAndValidateAliasProperties());
            return aliasAndIndexLookup;
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            XContentContext context = XContentContext.valueOf(params.param(MetaData.CONTEXT_MODE_PARAM, "API"));
            builder.startObject("meta-data");
            builder.field("version", metaData.version());
            builder.field("cluster_uuid", metaData.clusterUUID);
            builder.field("cluster_uuid_committed", metaData.clusterUUIDCommitted);
            builder.startObject("cluster_coordination");
            metaData.coordinationMetaData().toXContent(builder, params);
            builder.endObject();
            if (!metaData.persistentSettings().isEmpty()) {
                builder.startObject("settings");
                metaData.persistentSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
            }
            if (context == XContentContext.API && !metaData.transientSettings().isEmpty()) {
                builder.startObject("transient_settings");
                metaData.transientSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
            }
            builder.startObject("templates");
            for (ObjectObjectCursor<String, Custom> cursor : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContentWithTypes((IndexTemplateMetaData)cursor.value, builder, params);
            }
            builder.endObject();
            if (context == XContentContext.API && !metaData.indices().isEmpty()) {
                builder.startObject("indices");
                for (IndexMetaData indexMetaData : metaData) {
                    IndexMetaData.Builder.toXContent(indexMetaData, builder, params);
                }
                builder.endObject();
            }
            for (ObjectObjectCursor<String, Custom> cursor : metaData.customs()) {
                if (!((Custom)cursor.value).context().contains((Object)context)) continue;
                builder.startObject((String)cursor.key);
                ((Custom)cursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    if (token != XContentParser.Token.FIELD_NAME) {
                        throw new IllegalArgumentException("Expected a field name but got " + token);
                    }
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(parser.currentName())) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected a START_OBJECT but got " + token);
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("cluster_coordination".equals(currentFieldName)) {
                        builder.coordinationMetaData(CoordinationMetaData.fromXContent(parser));
                        continue;
                    }
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.fromXContent(parser));
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetaData.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("hashes_of_consistent_settings".equals(currentFieldName)) {
                        builder.hashesOfConsistentSettings(parser.mapStrings());
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetaData.Builder.fromXContent(parser, parser.currentName()));
                        }
                        continue;
                    }
                    try {
                        Custom custom = (Custom)parser.namedObject(Custom.class, currentFieldName, null);
                        builder.putCustom(custom.getWriteableName(), custom);
                    }
                    catch (NamedObjectNotFoundException ex) {
                        logger.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("version".equals(currentFieldName)) {
                        builder.version = parser.longValue();
                        continue;
                    }
                    if ("cluster_uuid".equals(currentFieldName) || "uuid".equals(currentFieldName)) {
                        builder.clusterUUID = parser.text();
                        continue;
                    }
                    if ("cluster_uuid_committed".equals(currentFieldName)) {
                        builder.clusterUUIDCommitted = parser.booleanValue();
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + token);
            }
            return builder.build();
        }
    }
}

