/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.sourceforge.jnlp.util.logging.OutputController;

public class TimedHashMap<K, V>
implements Map<K, V> {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toNanos(10L);
    private final HashMap<K, TimedEntry<V>> actualMap = new HashMap();
    private long timeout = DEFAULT_TIMEOUT;

    public TimedHashMap() {
        this(DEFAULT_TIMEOUT, TimeUnit.NANOSECONDS);
    }

    public TimedHashMap(long timeout, TimeUnit unit) {
        this.setTimeout(timeout, unit);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toNanos(timeout);
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        TimedEntry<V> oldEntry = this.actualMap.get(key);
        Object oldValue = oldEntry != null ? ((TimedEntry)oldEntry).value : null;
        this.actualMap.put(key, new TimedEntry<V>(value));
        return (V)oldValue;
    }

    @Override
    public V get(Object key) {
        long now = System.nanoTime();
        if (this.actualMap.containsKey(key)) {
            TimedEntry<V> timedEntry = this.actualMap.get(key);
            long age = now - ((TimedEntry)timedEntry).timestamp;
            if (age <= this.timeout) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Returning entry " + this.actualMap.get(key) + " from cache for " + key);
                timedEntry.updateTimestamp();
                return (V)((TimedEntry)timedEntry).value;
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Cached entry for " + key + " has expired (age=" + (double)age * 1.0E-9 + " seconds)");
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.actualMap.containsKey(key);
    }

    @Override
    public int size() {
        return this.actualMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.actualMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        for (TimedEntry<V> entry : this.actualMap.values()) {
            if (!Objects.equals(((TimedEntry)entry).value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        if (this.actualMap.containsKey(key)) {
            return (V)((TimedEntry)this.actualMap.remove(key)).value;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.actualMap.put(entry.getKey(), new TimedEntry<V>(entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.actualMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.actualMap.keySet());
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.actualMap.size());
        for (TimedEntry<V> value : this.actualMap.values()) {
            values.add(((TimedEntry)value).value);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, Object> strippedMap = new HashMap<K, Object>(this.actualMap.size());
        for (Map.Entry<K, TimedEntry<V>> entry : this.actualMap.entrySet()) {
            strippedMap.put(entry.getKey(), ((TimedEntry)entry.getValue()).value);
        }
        return strippedMap.entrySet();
    }

    private static class TimedEntry<T> {
        private final T value;
        private long timestamp;

        public TimedEntry(T value) {
            this.value = value;
            this.updateTimestamp();
        }

        public void updateTimestamp() {
            this.timestamp = System.nanoTime();
        }
    }
}

