/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.merge.EolAwareOutputStream;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeResult;

class MergeFormatterPass {
    private final EolAwareOutputStream out;
    private final MergeResult<RawText> res;
    private final List<String> seqName;
    private final String charsetName;
    private final boolean threeWayMerge;
    private String lastConflictingName;

    MergeFormatterPass(OutputStream out, MergeResult<RawText> res2, List<String> seqName, String charsetName) {
        this.out = new EolAwareOutputStream(out);
        this.res = res2;
        this.seqName = seqName;
        this.charsetName = charsetName;
        this.threeWayMerge = res2.getSequences().size() == 3;
    }

    void formatMerge() throws IOException {
        boolean missingNewlineAtEnd = false;
        for (MergeChunk chunk2 : this.res) {
            RawText seq = this.res.getSequences().get(chunk2.getSequenceIndex());
            this.writeConflictMetadata(chunk2);
            for (int i = chunk2.getBegin(); i < chunk2.getEnd(); ++i) {
                this.writeLine(seq, i);
            }
            missingNewlineAtEnd = seq.isMissingNewlineAtEnd();
        }
        if (this.lastConflictingName != null) {
            this.writeConflictEnd();
        }
        if (!missingNewlineAtEnd) {
            this.out.beginln();
        }
    }

    private void writeConflictMetadata(MergeChunk chunk2) throws IOException {
        if (this.lastConflictingName != null && chunk2.getConflictState() != MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
            this.writeConflictEnd();
        }
        if (chunk2.getConflictState() == MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE) {
            this.writeConflictStart(chunk2);
        } else if (chunk2.getConflictState() == MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
            this.writeConflictChange(chunk2);
        }
    }

    private void writeConflictEnd() throws IOException {
        this.writeln(">>>>>>> " + this.lastConflictingName);
        this.lastConflictingName = null;
    }

    private void writeConflictStart(MergeChunk chunk2) throws IOException {
        this.lastConflictingName = this.seqName.get(chunk2.getSequenceIndex());
        this.writeln("<<<<<<< " + this.lastConflictingName);
    }

    private void writeConflictChange(MergeChunk chunk2) throws IOException {
        this.lastConflictingName = this.seqName.get(chunk2.getSequenceIndex());
        this.writeln(this.threeWayMerge ? "=======" : "======= " + this.lastConflictingName);
    }

    private void writeln(String s2) throws IOException {
        this.out.beginln();
        this.out.write((s2 + "\n").getBytes(this.charsetName));
    }

    private void writeLine(RawText seq, int i) throws IOException {
        this.out.beginln();
        seq.writeLine(this.out, i);
        if (this.out.isBeginln()) {
            this.out.write(10);
        }
    }
}

