/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class RootClassLoadedCommand
extends Command {
    private int[] allLoadedClassLoaderIds;
    private String[] allLoadedClassNames;
    private byte[][] cachedClassFileBytes;
    private int[] allLoadedClassesSuper;
    private int[][] allLoadedClassesInterfaces;
    private int[] parentLoaderIds;
    private int classCount;

    public RootClassLoadedCommand(String[] stringArray, int[] nArray, byte[][] byArray, int[] nArray2, int[][] nArray3, int n, int[] nArray4) {
        super(17);
        this.allLoadedClassNames = stringArray;
        this.allLoadedClassLoaderIds = nArray;
        this.cachedClassFileBytes = byArray;
        this.allLoadedClassesSuper = nArray2;
        this.allLoadedClassesInterfaces = nArray3;
        this.classCount = n;
        this.parentLoaderIds = nArray4;
    }

    RootClassLoadedCommand() {
        super(17);
    }

    public int[] getAllLoadedClassLoaderIds() {
        return this.allLoadedClassLoaderIds;
    }

    public String[] getAllLoadedClassNames() {
        return this.allLoadedClassNames;
    }

    public byte[][] getCachedClassFileBytes() {
        byte[][] byArray = this.cachedClassFileBytes;
        this.cachedClassFileBytes = null;
        return byArray;
    }

    public int[] getAllLoaderSuperClassIds() {
        return this.allLoadedClassesSuper;
    }

    public int[][] getAllLoadedInterfaceIds() {
        return this.allLoadedClassesInterfaces;
    }

    public int[] getParentLoaderIds() {
        int[] nArray = new int[this.parentLoaderIds.length];
        System.arraycopy(this.parentLoaderIds, 0, nArray, 0, this.parentLoaderIds.length);
        return nArray;
    }

    public String toString() {
        return "RootClassLoadedCommand, classes: " + this.classCount + ", " + super.toString();
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)objectInputStream, 32768);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(gZIPInputStream);
        byte[] byArray = new byte[]{};
        this.classCount = objectInputStream2.readInt();
        this.allLoadedClassNames = new String[this.classCount];
        for (n3 = 0; n3 < this.classCount; ++n3) {
            this.allLoadedClassNames[n3] = objectInputStream2.readUTF().replace('.', '/').intern();
        }
        this.allLoadedClassLoaderIds = new int[this.classCount];
        for (n3 = 0; n3 < this.classCount; ++n3) {
            this.allLoadedClassLoaderIds[n3] = objectInputStream2.readInt();
        }
        n3 = objectInputStream2.readInt();
        if (n3 == 0) {
            this.cachedClassFileBytes = null;
        } else {
            this.cachedClassFileBytes = new byte[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                n = objectInputStream2.readInt();
                if (n == -1) continue;
                if (n == 0) {
                    this.cachedClassFileBytes[n2] = byArray;
                    continue;
                }
                this.cachedClassFileBytes[n2] = new byte[n];
                objectInputStream2.readFully(this.cachedClassFileBytes[n2]);
            }
        }
        this.allLoadedClassesSuper = new int[this.classCount];
        for (n2 = 0; n2 < this.classCount; ++n2) {
            this.allLoadedClassesSuper[n2] = objectInputStream2.readInt();
        }
        this.allLoadedClassesInterfaces = new int[this.classCount][];
        for (n2 = 0; n2 < this.classCount; ++n2) {
            n = objectInputStream2.readInt();
            this.allLoadedClassesInterfaces[n2] = new int[n];
            for (int i = 0; i < n; ++i) {
                this.allLoadedClassesInterfaces[n2][i] = objectInputStream2.readInt();
            }
        }
        n3 = objectInputStream2.readInt();
        this.parentLoaderIds = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.parentLoaderIds[n2] = objectInputStream2.readInt();
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)objectOutputStream, 32768);
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream2.writeInt(this.classCount);
        for (n = 0; n < this.classCount; ++n) {
            objectOutputStream2.writeUTF(this.allLoadedClassNames[n]);
        }
        for (n = 0; n < this.classCount; ++n) {
            int n2 = this.allLoadedClassLoaderIds[n];
            if (n2 == -1) {
                n2 = 0;
            }
            objectOutputStream2.writeInt(n2);
        }
        if (this.cachedClassFileBytes == null) {
            objectOutputStream2.writeInt(0);
        } else {
            objectOutputStream2.writeInt(this.classCount);
            for (n = 0; n < this.classCount; ++n) {
                if (this.cachedClassFileBytes[n] == null) {
                    objectOutputStream2.writeInt(-1);
                    continue;
                }
                objectOutputStream2.writeInt(this.cachedClassFileBytes[n].length);
                if (this.cachedClassFileBytes[n].length <= 0) continue;
                objectOutputStream2.write(this.cachedClassFileBytes[n]);
            }
        }
        for (n = 0; n < this.classCount; ++n) {
            objectOutputStream2.writeInt(this.allLoadedClassesSuper[n]);
        }
        for (n = 0; n < this.classCount; ++n) {
            int[] nArray = this.allLoadedClassesInterfaces[n];
            if (nArray != null) {
                objectOutputStream2.writeInt(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    objectOutputStream2.writeInt(nArray[i]);
                }
                continue;
            }
            objectOutputStream2.writeInt(0);
        }
        objectOutputStream2.writeInt(this.parentLoaderIds.length);
        for (n = 0; n < this.parentLoaderIds.length; ++n) {
            objectOutputStream2.writeInt(this.parentLoaderIds[n]);
        }
        objectOutputStream2.flush();
        gZIPOutputStream.finish();
        this.allLoadedClassNames = null;
        this.allLoadedClassLoaderIds = null;
        this.cachedClassFileBytes = null;
        this.allLoadedClassesSuper = null;
        this.allLoadedClassesInterfaces = null;
        this.parentLoaderIds = null;
    }
}

