/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.api.search.provider.impl.DefinitionUtils;
import org.netbeans.api.search.provider.impl.SimpleSearchIterator;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.openide.filesystems.FileObject;

public final class SimpleSearchInfoDefinition
extends SearchInfoDefinition {
    public static final SearchInfoDefinition EMPTY_SEARCH_INFO = new SearchInfoDefinition(){

        @Override
        public boolean canSearch() {
            return true;
        }

        @Override
        public Iterator<FileObject> filesToSearch(SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
            return Collections.emptyList().iterator();
        }

        @Override
        public List<SearchRoot> getSearchRoots() {
            return Collections.emptyList();
        }
    };
    private final FileObject rootFile;
    private final SearchFilterDefinition[] filters;

    public SimpleSearchInfoDefinition(FileObject fileObject, SearchFilterDefinition[] searchFilterDefinitionArray) {
        if (fileObject == null) {
            throw new IllegalArgumentException();
        }
        if (searchFilterDefinitionArray != null && searchFilterDefinitionArray.length == 0) {
            searchFilterDefinitionArray = null;
        }
        this.rootFile = fileObject;
        this.filters = searchFilterDefinitionArray != null ? SimpleSearchInfoDefinition.niceFilters(fileObject, searchFilterDefinitionArray) : null;
    }

    private static SearchFilterDefinition[] niceFilters(FileObject fileObject, SearchFilterDefinition[] searchFilterDefinitionArray) {
        int n;
        boolean[] blArray = new boolean[searchFilterDefinitionArray.length];
        if (fileObject.isFolder()) {
            for (n = 0; n < searchFilterDefinitionArray.length; ++n) {
                SearchFilterDefinition.FolderResult folderResult = searchFilterDefinitionArray[n].traverseFolder(fileObject);
                blArray[n] = folderResult != SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
            }
        } else {
            assert (fileObject.isData());
            for (n = 0; n < searchFilterDefinitionArray.length; ++n) {
                blArray[n] = searchFilterDefinitionArray[n].searchFile(fileObject);
            }
        }
        SearchFilterDefinition[] searchFilterDefinitionArray2 = new SearchFilterDefinition[SimpleSearchInfoDefinition.countTrues(blArray)];
        int n2 = 0;
        for (int i = 0; i < searchFilterDefinitionArray.length; ++i) {
            if (!blArray[i]) continue;
            searchFilterDefinitionArray2[n2++] = searchFilterDefinitionArray[i];
        }
        return searchFilterDefinitionArray2;
    }

    private static int countTrues(boolean[] blArray) {
        int n = 0;
        for (boolean bl : blArray) {
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean canSearch() {
        return this.filters != null ? this.checkFolderAgainstFilters(this.rootFile) : true;
    }

    @Override
    public Iterator<FileObject> filesToSearch(SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
        return new SimpleSearchIterator(this.rootFile, searchScopeOptions, this.filters != null ? Arrays.asList(this.filters) : null, searchListener, atomicBoolean);
    }

    private boolean checkFolderAgainstFilters(FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.isSuppressableFilter(this.filters[i]) || this.filters[i].traverseFolder(fileObject) != SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.isSuppressableFilter(this.filters[i]) || this.filters[i].searchFile(fileObject)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSuppressableFilter(SearchFilterDefinition searchFilterDefinition) {
        return searchFilterDefinition == SearchInfoDefinitionFactory.SHARABILITY_FILTER;
    }

    @Override
    public List<SearchRoot> getSearchRoots() {
        SearchRoot searchRoot = new SearchRoot(this.rootFile, DefinitionUtils.createSearchFilterList(this.filters));
        return Collections.singletonList(searchRoot);
    }
}

