/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jetty.util.component.Dumpable;

public class DumpableCollection
implements Dumpable {
    private final String _name;
    private final Collection<?> _collection;

    public DumpableCollection(String name2, Collection<?> collection) {
        this._name = name2;
        this._collection = collection;
    }

    public static DumpableCollection fromArray(String name2, Object[] array2) {
        return new DumpableCollection(name2, array2 == null ? Collections.emptyList() : Arrays.asList(array2));
    }

    public static DumpableCollection from(String name2, Object ... items) {
        return new DumpableCollection(name2, items == null ? Collections.emptyList() : Arrays.asList(items));
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent2) throws IOException {
        Object[] array2 = this._collection.toArray();
        Dumpable.dumpObjects(out, indent2, this._name + " size=" + array2.length, array2);
    }
}

