/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MathLinker {
    private static final Logger LOG = LoggerFactory.getLogger(MathLinker.class);
    private static final boolean LOG_BINDING;
    public static final MethodHandle FIXNUM_TEST;
    public static final MethodHandle FIXNUM_OPERATOR_FAIL;
    public static final MethodHandle FIXNUM_BOOLEAN_FAIL;
    public static final MethodHandle FLOAT_TEST;
    public static final MethodHandle FLOAT_OPERATOR_FAIL;
    public static final MethodHandle FIXNUM_OPERATOR;
    public static final MethodHandle FIXNUM_BOOLEAN;
    public static final MethodHandle FLOAT_OPERATOR;
    private static final CallType[] CALL_TYPES;
    private static final int[] ARG_2_TO_0;
    public static final MethodHandle FLOAT_TEST_ARG_2_TO_0;
    public static final MethodHandle FIXNUM_TEST_ARG_2_TO_0;

    public static CallSite fixnumOperatorBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, long value2, int callType, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        List<String> names2 = StringSupport.split(name2, ':');
        String operator = JavaNameMangler.demangleMethodName(names2.get(1));
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CALL_TYPES[callType], file2, line, operator);
        MethodHandle target = FIXNUM_OPERATOR;
        target = MethodHandles.insertArguments(target, 3, site, value2);
        site.setTarget(target);
        return site;
    }

    public static CallSite fixnumBooleanBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, long value2, int callType, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        List<String> names2 = StringSupport.split(name2, ':');
        String operator = JavaNameMangler.demangleMethodName(names2.get(1));
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CALL_TYPES[callType], file2, line, operator);
        MethodHandle target = FIXNUM_BOOLEAN;
        target = MethodHandles.insertArguments(target, 3, site, value2);
        site.setTarget(target);
        return site;
    }

    public static CallSite floatOperatorBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, double value2, int callType, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        List<String> names2 = StringSupport.split(name2, ':');
        String operator = JavaNameMangler.demangleMethodName(names2.get(1));
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CALL_TYPES[callType], file2, line, operator);
        MethodHandle target = FLOAT_OPERATOR;
        target = MethodHandles.insertArguments(target, 3, site, value2);
        site.setTarget(target);
        return site;
    }

    public static IRubyObject fixnumOperator(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, long value2) throws Throwable {
        Ruby runtime2 = context.runtime;
        String operator = site.name;
        MethodHandle target = null;
        MethodHandle fallback = MethodHandles.insertArguments(FIXNUM_OPERATOR_FAIL, 3, site, runtime2.newFixnum(value2));
        CacheEntry entry = MathLinker.searchWithCache(operator, caller2, self2.getMetaClass(), site);
        if (!(self2 instanceof RubyFixnum) || entry == null || !entry.method.isBuiltin()) {
            target = fallback;
            site.setTarget(target);
            if (LOG_BINDING) {
                LOG.debug(site.name + "\tFixnum operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound indirectly", new Object[0]);
            }
        } else {
            String opMethod = MethodIndex.getFastFixnumOpsMethod(operator);
            String name2 = "fixnum_" + opMethod;
            if (operator.equals("+") || operator.equals("-")) {
                MethodType type2 = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
                if (value2 == 1L) {
                    name2 = name2 + "_one";
                    target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
                } else if (value2 == 2L) {
                    name2 = name2 + "_two";
                    target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
                }
            }
            if (target == null) {
                target = MathLinker.findTargetImpl(name2, IRubyObject.class, value2);
            }
            RubyClass classFixnum = runtime2.getFixnum();
            target = MethodHandles.guardWithTest(FIXNUM_TEST_ARG_2_TO_0, target, fallback);
            target = ((SwitchPoint)classFixnum.getInvalidator().getData()).guardWithTest(target, fallback);
            site.setTarget(target);
            if (LOG_BINDING) {
                LOG.debug(name2 + "\tFixnum operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
            }
        }
        return (IRubyObject)target.invokeWithArguments(context, caller2, self2);
    }

    public static boolean fixnumBoolean(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, long value2) throws Throwable {
        MethodHandle target;
        Ruby runtime2 = context.runtime;
        String operator = site.name;
        MethodHandle fallback = MethodHandles.insertArguments(FIXNUM_BOOLEAN_FAIL, 3, site, runtime2.newFixnum(value2));
        CacheEntry entry = MathLinker.searchWithCache(operator, caller2, self2.getMetaClass(), site);
        if (!(self2 instanceof RubyFixnum) || entry == null || !entry.method.isBuiltin()) {
            target = fallback;
            site.setTarget(target);
            if (LOG_BINDING) {
                LOG.debug(site.name + "\tFixnum boolean operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound indirectly", new Object[0]);
            }
        } else {
            String opMethod = MethodIndex.getFastFixnumOpsMethod(operator);
            String name2 = "fixnum_boolean_" + opMethod;
            target = MathLinker.findTargetImpl(name2, Boolean.TYPE, value2);
            RubyClass classFixnum = runtime2.getFixnum();
            target = MethodHandles.guardWithTest(FIXNUM_TEST_ARG_2_TO_0, target, fallback);
            target = ((SwitchPoint)classFixnum.getInvalidator().getData()).guardWithTest(target, fallback);
            site.setTarget(target);
            if (LOG_BINDING) {
                LOG.debug(name2 + "\tFixnum boolean operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
            }
        }
        return (Boolean)target.invokeWithArguments(context, caller2, self2);
    }

    static boolean fixnumTest(IRubyObject self2) {
        return self2 instanceof RubyFixnum;
    }

    static IRubyObject fixnumOperatorFail(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyFixnum value2) throws Throwable {
        return MathLinker.callMethod(context, caller2, self2, site, value2);
    }

    static boolean fixnumBooleanFail(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyFixnum value2) throws Throwable {
        return MathLinker.fixnumOperatorFail(context, caller2, self2, site, value2).isTrue();
    }

    public static IRubyObject fixnum_op_plus(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_plus(context, value2);
    }

    public static IRubyObject fixnum_op_minus(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_minus(context, value2);
    }

    public static IRubyObject fixnum_op_mul(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_mul(context, value2);
    }

    public static IRubyObject fixnum_op_mod(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_mod(context, value2);
    }

    public static IRubyObject fixnum_op_div(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_div(context, value2);
    }

    public static IRubyObject fixnum_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_equal(context, value2);
    }

    public static IRubyObject fixnum_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lt(context, value2);
    }

    public static IRubyObject fixnum_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_le(context, value2);
    }

    public static IRubyObject fixnum_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_gt(context, value2);
    }

    public static IRubyObject fixnum_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_ge(context, value2);
    }

    public static boolean fixnum_boolean_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_equal_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lt_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_le_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_gt_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_ge_boolean(context, value2);
    }

    public static IRubyObject fixnum_op_cmp(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_cmp(context, value2);
    }

    public static IRubyObject fixnum_op_and(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_and(context, value2);
    }

    public static IRubyObject fixnum_op_or(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_or(context, value2);
    }

    public static IRubyObject fixnum_op_xor(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_xor(context, value2);
    }

    public static IRubyObject fixnum_op_rshift(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_rshift(context, value2);
    }

    public static IRubyObject fixnum_op_lshift(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lshift(context, value2);
    }

    public static IRubyObject fixnum_op_plus_one(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_plus_one(context);
    }

    public static IRubyObject fixnum_op_minus_one(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_minus_one(context);
    }

    public static IRubyObject fixnum_op_plus_two(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_plus_two(context);
    }

    public static IRubyObject fixnum_op_minus_two(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_minus_two(context);
    }

    public static IRubyObject floatOperator(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, double value2) throws Throwable {
        MethodHandle target;
        Ruby runtime2 = context.runtime;
        String operator = site.name;
        MethodHandle fallback = MethodHandles.insertArguments(FLOAT_OPERATOR_FAIL, 3, site, RubyFloat.newFloat(runtime2, value2));
        CacheEntry entry = MathLinker.searchWithCache(operator, caller2, self2.getMetaClass(), site);
        if (!(self2 instanceof RubyFloat) || entry == null || !entry.method.isBuiltin()) {
            target = fallback;
            site.setTarget(target);
            if (LOG_BINDING) {
                LOG.debug(site.name + "\tFloat operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound indirectly", new Object[0]);
            }
        } else {
            String opMethod = MethodIndex.getFastFloatOpsMethod(operator);
            String name2 = "float_" + opMethod;
            target = MathLinker.findTargetImpl(name2, IRubyObject.class, value2);
            RubyClass classFloat = runtime2.getFloat();
            target = MethodHandles.guardWithTest(FLOAT_TEST_ARG_2_TO_0, target, fallback);
            target = ((SwitchPoint)classFloat.getInvalidator().getData()).guardWithTest(target, fallback);
            site.setTarget(target);
            if (LOG_BINDING) {
                LOG.debug(name2 + "\tFloat operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
            }
        }
        return (IRubyObject)target.invokeWithArguments(context, caller2, self2);
    }

    static boolean floatTest(IRubyObject self2) {
        return self2 instanceof RubyFloat;
    }

    public static IRubyObject float_op_plus(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_plus(context, value2);
    }

    public static IRubyObject float_op_minus(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_minus(context, value2);
    }

    public static IRubyObject float_op_mul(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_mul(context, value2);
    }

    public static IRubyObject float_op_mod(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_mod(context, value2);
    }

    public static IRubyObject float_op_div(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_div(context, value2);
    }

    public static IRubyObject float_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_equal(context, value2);
    }

    public static IRubyObject float_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_lt(context, value2);
    }

    public static IRubyObject float_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_le(context, value2);
    }

    public static IRubyObject float_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_gt(context, value2);
    }

    public static IRubyObject float_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_ge(context, value2);
    }

    public static IRubyObject float_op_cmp(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_cmp(context, value2);
    }

    static IRubyObject floatOperatorFail(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyFloat value2) throws Throwable {
        return MathLinker.callMethod(context, caller2, self2, site, value2);
    }

    private static MethodHandle findTargetImpl(String name2, Class<?> returnType, long value2) throws NoSuchMethodException, IllegalAccessException {
        MethodType type2 = MethodType.methodType(returnType, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        type2 = type2.insertParameterTypes(3, Long.TYPE);
        MethodHandle target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
        return MethodHandles.insertArguments(target, 3, value2);
    }

    private static MethodHandle findTargetImpl(String name2, Class<?> returnType, double value2) throws NoSuchMethodException, IllegalAccessException {
        MethodType type2 = MethodType.methodType(returnType, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        type2 = type2.insertParameterTypes(3, Double.TYPE);
        MethodHandle target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
        return MethodHandles.insertArguments(target, 3, value2);
    }

    private static IRubyObject callMethod(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyNumeric value2) {
        String operator = site.name;
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        CacheEntry entry = MathLinker.searchWithCache(operator, caller2, selfClass, site);
        if (entry == null) {
            return InvokeDynamicSupport.callMethodMissing(CacheEntry.NULL_CACHE, site.callType, context, self2, operator, value2);
        }
        return entry.method.call(context, self2, entry.sourceModule, operator, value2);
    }

    private static CacheEntry searchWithCache(String operator, IRubyObject caller2, RubyClass selfClass, JRubyCallSite site) {
        CacheEntry entry = site.entry;
        if (!entry.typeOk(selfClass)) {
            entry = selfClass.searchWithCache(operator);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType, operator, caller2)) {
                return null;
            }
            site.entry = entry;
        }
        return entry;
    }

    static {
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.setDebugEnable(true);
        }
        LOG_BINDING = LOG.isDebugEnabled();
        FIXNUM_TEST = Binder.from(MethodType.methodType(Boolean.TYPE, IRubyObject.class)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "fixnumTest");
        FIXNUM_OPERATOR_FAIL = Binder.from(MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, RubyFixnum.class)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "fixnumOperatorFail");
        FIXNUM_BOOLEAN_FAIL = Binder.from(MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, RubyFixnum.class)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "fixnumBooleanFail");
        FLOAT_TEST = Binder.from(MethodType.methodType(Boolean.TYPE, IRubyObject.class)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "floatTest");
        FLOAT_OPERATOR_FAIL = Binder.from(MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, RubyFloat.class)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "floatOperatorFail");
        FIXNUM_OPERATOR = Binder.from(MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Long.TYPE)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "fixnumOperator");
        FIXNUM_BOOLEAN = Binder.from(MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Long.TYPE)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "fixnumBoolean");
        FLOAT_OPERATOR = Binder.from(MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Double.TYPE)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "floatOperator");
        CALL_TYPES = CallType.values();
        ARG_2_TO_0 = new int[]{2};
        FLOAT_TEST_ARG_2_TO_0 = MethodHandles.permuteArguments(FLOAT_TEST, MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class), ARG_2_TO_0);
        FIXNUM_TEST_ARG_2_TO_0 = MethodHandles.permuteArguments(FIXNUM_TEST, MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class), ARG_2_TO_0);
    }
}

