/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import net.sourceforge.plantuml.code.ArobaseStringCompressor2;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.AsciiEncoderBase64;
import net.sourceforge.plantuml.code.AsciiEncoderHex;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.CompressionHuffman;
import net.sourceforge.plantuml.code.CompressionNone;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;

public class TranscoderSmart2
implements Transcoder {
    private final Transcoder oldOne = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor2(), new CompressionHuffman());
    private final Transcoder zlib = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor2(), new CompressionZlib());
    private final Transcoder brotli = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor2(), new CompressionBrotli());
    private final Transcoder zlibBase64 = TranscoderImpl.utf8(new AsciiEncoderBase64(), new ArobaseStringCompressor2(), new CompressionZlib());
    private final Transcoder brotliBase64 = TranscoderImpl.utf8(new AsciiEncoderBase64(), new ArobaseStringCompressor2(), new CompressionBrotli());
    private final Transcoder base64only = TranscoderImpl.utf8(new AsciiEncoderBase64(), new ArobaseStringCompressor2(), new CompressionNone());
    private final Transcoder hexOnly = TranscoderImpl.utf8(new AsciiEncoderHex(), new ArobaseStringCompressor2(), new CompressionNone());

    @Override
    public String decode(String code) throws NoPlantumlCompressionException {
        if (code.startsWith("0A")) {
            return this.zlibBase64.decode(code.substring(2));
        }
        if (code.startsWith("0B")) {
            return this.brotliBase64.decode(code.substring(2));
        }
        if (code.startsWith("0C")) {
            return this.base64only.decode(code.substring(2));
        }
        if (code.startsWith("0D")) {
            return this.hexOnly.decode(code.substring(2));
        }
        if (code.startsWith("-deflate-")) {
            return this.zlibBase64.decode(code.substring("-deflate-".length()));
        }
        if (code.startsWith("-brotli-")) {
            return this.brotliBase64.decode(code.substring("-brotli-".length()));
        }
        if (code.startsWith("-base64-")) {
            return this.base64only.decode(code.substring("-base64-".length()));
        }
        if (code.startsWith("-hex-")) {
            return this.hexOnly.decode(code.substring("-hex-".length()));
        }
        if (code.startsWith("0")) {
            return this.brotli.decode(code.substring(1));
        }
        try {
            return this.zlib.decode(code);
        }
        catch (Exception ex) {
            return this.oldOne.decode(code);
        }
    }

    @Override
    public String encode(String text) throws IOException {
        return this.zlib.encode(text);
    }
}

