/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.MutableImage;
import net.sourceforge.plantuml.ugraphic.color.ColorChangerMonochrome;

public class PixelImage
implements MutableImage {
    private final BufferedImage bufferedImageScale1;
    private final double scale;
    private final AffineTransformType type;
    private BufferedImage cache = null;
    private static final int mask_a__ = -16777216;
    private static final int mask_rgb = 0xFFFFFF;

    public PixelImage(BufferedImage bufferedImage, AffineTransformType type) {
        this(bufferedImage, type, 1.0);
    }

    private PixelImage(BufferedImage bufferedImage, AffineTransformType type, double scale) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.bufferedImageScale1 = bufferedImage;
        this.scale = scale;
        this.type = type;
    }

    @Override
    public MutableImage withScale(double scale) {
        return new PixelImage(this.bufferedImageScale1, this.type, this.scale * scale);
    }

    @Override
    public final BufferedImage getImage() {
        if (this.scale == 1.0) {
            return this.bufferedImageScale1;
        }
        if (this.cache == null) {
            int w = (int)Math.round((double)this.bufferedImageScale1.getWidth() * this.scale);
            int h = (int)Math.round((double)this.bufferedImageScale1.getHeight() * this.scale);
            BufferedImage after = new BufferedImage(w, h, this.bufferedImageScale1.getType());
            AffineTransform at = new AffineTransform();
            at.scale(this.scale, this.scale);
            AffineTransformOp scaleOp = new AffineTransformOp(at, this.type.toLegacyInt());
            this.cache = scaleOp.filter(this.bufferedImageScale1, after);
        }
        return this.cache;
    }

    @Override
    public MutableImage muteColor(Color newColor) {
        if (newColor == null) {
            return this;
        }
        int darkerRgb = this.getDarkerRgb();
        BufferedImage copy = this.deepCopy();
        for (int i = 0; i < this.bufferedImageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.bufferedImageScale1.getHeight(); ++j) {
                int color = this.bufferedImageScale1.getRGB(i, j);
                int rgb = this.getRgb(color);
                int a = this.getA(color);
                if (a == 0 || rgb != darkerRgb) continue;
                copy.setRGB(i, j, newColor.getRGB() + a);
            }
        }
        return new PixelImage(copy, this.type, this.scale);
    }

    @Override
    public MutableImage muteTransparentColor(Color newColor) {
        if (newColor == null) {
            newColor = Color.WHITE;
        }
        BufferedImage copy = this.deepCopy();
        for (int i = 0; i < this.bufferedImageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.bufferedImageScale1.getHeight(); ++j) {
                int color = this.bufferedImageScale1.getRGB(i, j);
                int a = this.getA(color);
                if (a != 0) continue;
                copy.setRGB(i, j, newColor.getRGB());
            }
        }
        return new PixelImage(copy, this.type, this.scale);
    }

    private int getDarkerRgb() {
        int darkerRgb = -1;
        for (int i = 0; i < this.bufferedImageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.bufferedImageScale1.getHeight(); ++j) {
                int color = this.bufferedImageScale1.getRGB(i, j);
                int rgb = this.getRgb(color);
                int a = this.getA(color);
                if (a != -16777216) continue;
                int grey = ColorChangerMonochrome.getGrayScale(rgb);
                if (darkerRgb != -1 && grey >= ColorChangerMonochrome.getGrayScale(darkerRgb)) continue;
                darkerRgb = rgb;
            }
        }
        return darkerRgb;
    }

    private int getRgb(int color) {
        return color & 0xFFFFFF;
    }

    private int getA(int color) {
        return color & 0xFF000000;
    }

    private BufferedImage deepCopy() {
        BufferedImage result = new BufferedImage(this.bufferedImageScale1.getWidth(), this.bufferedImageScale1.getHeight(), 2);
        for (int i = 0; i < this.bufferedImageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.bufferedImageScale1.getHeight(); ++j) {
                result.setRGB(i, j, this.bufferedImageScale1.getRGB(i, j));
            }
        }
        return result;
    }
}

