/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Baseboard;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.BaseboardChoiceController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class WallController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private TextureChoiceController leftSideTextureController;
    private BaseboardChoiceController leftSideBaseboardController;
    private TextureChoiceController rightSideTextureController;
    private BaseboardChoiceController rightSideBaseboardController;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView wallView;
    private boolean editablePoints;
    private Float xStart;
    private Float yStart;
    private Float xEnd;
    private Float yEnd;
    private Float length;
    private Float distanceToEndPoint;
    private Integer leftSideColor;
    private WallPaint leftSidePaint;
    private Float leftSideShininess;
    private Integer rightSideColor;
    private WallPaint rightSidePaint;
    private Float rightSideShininess;
    private TextureImage pattern;
    private Integer topColor;
    private WallPaint topPaint;
    private WallShape shape;
    private Float rectangularWallHeight;
    private Float slopingWallHeightAtStart;
    private Float sloppingWallHeightAtEnd;
    private Float thickness;
    private Float arcExtentInDegrees;

    public WallController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getLeftSideTextureController() {
        if (this.leftSideTextureController == null) {
            this.leftSideTextureController = new TextureChoiceController(this.preferences.getLocalizedString(WallController.class, "leftSideTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.leftSideTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    WallController.this.setLeftSidePaint(WallPaint.TEXTURED);
                }
            });
        }
        return this.leftSideTextureController;
    }

    public BaseboardChoiceController getLeftSideBaseboardController() {
        if (this.leftSideBaseboardController == null) {
            this.leftSideBaseboardController = new BaseboardChoiceController(this.preferences, this.viewFactory, this.contentManager);
        }
        return this.leftSideBaseboardController;
    }

    public TextureChoiceController getRightSideTextureController() {
        if (this.rightSideTextureController == null) {
            this.rightSideTextureController = new TextureChoiceController(this.preferences.getLocalizedString(WallController.class, "rightSideTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.rightSideTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    WallController.this.setRightSidePaint(WallPaint.TEXTURED);
                }
            });
        }
        return this.rightSideTextureController;
    }

    public BaseboardChoiceController getRightSideBaseboardController() {
        if (this.rightSideBaseboardController == null) {
            this.rightSideBaseboardController = new BaseboardChoiceController(this.preferences, this.viewFactory, this.contentManager);
        }
        return this.rightSideBaseboardController;
    }

    @Override
    public DialogView getView() {
        if (this.wallView == null) {
            this.wallView = this.viewFactory.createWallView(this.preferences, this);
        }
        return this.wallView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        List<Wall> list = Home.getWallsSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setXStart(null);
            this.setYStart(null);
            this.setXEnd(null);
            this.setYEnd(null);
            this.setEditablePoints(false);
            this.setLeftSideColor(null);
            this.getLeftSideTextureController().setTexture(null);
            this.setLeftSidePaint(null);
            this.setLeftSideShininess(null);
            this.getLeftSideBaseboardController().setVisible(null);
            this.getLeftSideBaseboardController().setThickness(null);
            this.getLeftSideBaseboardController().setHeight(null);
            this.getLeftSideBaseboardController().setColor(null);
            this.getLeftSideBaseboardController().getTextureController().setTexture(null);
            this.getLeftSideBaseboardController().setPaint(null);
            this.setRightSideColor(null);
            this.getRightSideTextureController().setTexture(null);
            this.setRightSidePaint(null);
            this.setRightSideShininess(null);
            this.getLeftSideBaseboardController().setVisible(null);
            this.getLeftSideBaseboardController().setThickness(null);
            this.getLeftSideBaseboardController().setHeight(null);
            this.getLeftSideBaseboardController().setColor(null);
            this.getLeftSideBaseboardController().getTextureController().setTexture(null);
            this.getLeftSideBaseboardController().setPaint(null);
            this.setRectangularWallHeight(null);
            this.setSlopingWallHeightAtStart(null);
            this.setSlopingWallHeightAtEnd(null);
            this.setShape(null);
            this.setThickness(null);
            this.setArcExtentInDegrees(null);
        } else {
            int n;
            boolean bl;
            Baseboard baseboard;
            Integer n2;
            Serializable serializable;
            int n3;
            Baseboard baseboard2;
            Integer n4;
            Serializable serializable2;
            int n5;
            Wall wall = list.get(0);
            boolean bl2 = list.size() > 1;
            this.setEditablePoints(!bl2);
            Float f = Float.valueOf(wall.getXStart());
            for (int i = 1; i < list.size(); ++i) {
                if (f.equals(Float.valueOf(list.get(i).getXStart()))) continue;
                f = null;
                break;
            }
            this.setXStart(f);
            Float f2 = Float.valueOf(wall.getYStart());
            for (int i = 1; i < list.size(); ++i) {
                if (f2.equals(Float.valueOf(list.get(i).getYStart()))) continue;
                f2 = null;
                break;
            }
            this.setYStart(f2);
            Float f3 = Float.valueOf(wall.getXEnd());
            for (int i = 1; i < list.size(); ++i) {
                if (f3.equals(Float.valueOf(list.get(i).getXEnd()))) continue;
                f3 = null;
                break;
            }
            this.setXEnd(f3);
            Float f4 = Float.valueOf(wall.getYEnd());
            for (int i = 1; i < list.size(); ++i) {
                if (f4.equals(Float.valueOf(list.get(i).getYEnd()))) continue;
                f4 = null;
                break;
            }
            this.setYEnd(f4);
            Integer n6 = wall.getLeftSideColor();
            if (n6 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n6.equals(list.get(i).getLeftSideColor())) continue;
                    n6 = null;
                    break;
                }
            }
            this.setLeftSideColor(n6);
            HomeTexture homeTexture = wall.getLeftSideTexture();
            if (homeTexture != null) {
                for (n5 = 1; n5 < list.size(); ++n5) {
                    if (homeTexture.equals(list.get(n5).getLeftSideTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            this.getLeftSideTextureController().setTexture(homeTexture);
            n5 = 1;
            for (int i = 0; i < list.size(); ++i) {
                Wall wall2 = list.get(i);
                if (wall2.getLeftSideColor() == null && wall2.getLeftSideTexture() == null) continue;
                n5 = 0;
                break;
            }
            if (n6 != null) {
                this.setLeftSidePaint(WallPaint.COLORED);
            } else if (homeTexture != null) {
                this.setLeftSidePaint(WallPaint.TEXTURED);
            } else if (n5 != 0) {
                this.setLeftSidePaint(WallPaint.DEFAULT);
            } else {
                this.setLeftSidePaint(null);
            }
            Float f5 = Float.valueOf(wall.getLeftSideShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (f5.equals(Float.valueOf(list.get(i).getLeftSideShininess()))) continue;
                f5 = null;
                break;
            }
            this.setLeftSideShininess(f5);
            Boolean bl3 = wall.getLeftSideBaseboard() != null;
            for (int i = 1; i < list.size(); ++i) {
                if (bl3 == (list.get(i).getLeftSideBaseboard() != null)) continue;
                bl3 = null;
                break;
            }
            this.getLeftSideBaseboardController().setVisible(bl3);
            Baseboard baseboard3 = wall.getLeftSideBaseboard();
            Float f6 = Float.valueOf(baseboard3 != null ? baseboard3.getThickness() : this.preferences.getNewWallBaseboardThickness());
            for (int i = 1; i < list.size(); ++i) {
                Baseboard baseboard4 = list.get(i).getLeftSideBaseboard();
                if (f6.equals(Float.valueOf(baseboard4 != null ? baseboard4.getThickness() : this.preferences.getNewWallBaseboardThickness()))) continue;
                f6 = null;
                break;
            }
            this.getLeftSideBaseboardController().setThickness(f6);
            Float f7 = Float.valueOf(baseboard3 != null ? baseboard3.getHeight() : this.preferences.getNewWallBaseboardHeight());
            for (int i = 1; i < list.size(); ++i) {
                serializable2 = list.get(i).getLeftSideBaseboard();
                if (f7.equals(Float.valueOf(serializable2 != null ? ((Baseboard)serializable2).getHeight() : this.preferences.getNewWallBaseboardHeight()))) continue;
                f7 = null;
                break;
            }
            this.getLeftSideBaseboardController().setHeight(f7);
            Integer n7 = n4 = baseboard3 != null ? baseboard3.getColor() : null;
            if (n4 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    Baseboard baseboard5 = list.get(i).getLeftSideBaseboard();
                    if (baseboard5 != null && n4.equals(baseboard5.getColor())) continue;
                    n4 = null;
                    break;
                }
            }
            this.getLeftSideBaseboardController().setColor(n4);
            Serializable serializable3 = serializable2 = baseboard3 != null ? baseboard3.getTexture() : null;
            if (serializable2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    baseboard2 = list.get(i).getLeftSideBaseboard();
                    if (baseboard2 != null && ((HomeTexture)serializable2).equals(baseboard2.getTexture())) continue;
                    serializable2 = null;
                    break;
                }
            }
            this.getLeftSideBaseboardController().getTextureController().setTexture((HomeTexture)serializable2);
            n5 = 1;
            for (int i = 0; i < list.size(); ++i) {
                baseboard2 = list.get(i).getLeftSideBaseboard();
                if (baseboard2 == null || baseboard2.getColor() == null && baseboard2.getTexture() == null) continue;
                n5 = 0;
                break;
            }
            if (n4 != null) {
                this.getLeftSideBaseboardController().setPaint(BaseboardChoiceController.BaseboardPaint.COLORED);
            } else if (serializable2 != null) {
                this.getLeftSideBaseboardController().setPaint(BaseboardChoiceController.BaseboardPaint.TEXTURED);
            } else if (n5 != 0) {
                this.getLeftSideBaseboardController().setPaint(BaseboardChoiceController.BaseboardPaint.DEFAULT);
            } else {
                this.getLeftSideBaseboardController().setPaint(null);
            }
            Integer n8 = wall.getRightSideColor();
            if (n8 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n8.equals(list.get(i).getRightSideColor())) continue;
                    n8 = null;
                    break;
                }
            }
            this.setRightSideColor(n8);
            HomeTexture homeTexture2 = wall.getRightSideTexture();
            if (homeTexture2 != null) {
                for (n3 = 1; n3 < list.size(); ++n3) {
                    if (homeTexture2.equals(list.get(n3).getRightSideTexture())) continue;
                    homeTexture2 = null;
                    break;
                }
            }
            this.getRightSideTextureController().setTexture(homeTexture2);
            n5 = 1;
            for (n3 = 0; n3 < list.size(); ++n3) {
                Wall wall3 = list.get(n3);
                if (wall3.getRightSideColor() == null && wall3.getRightSideTexture() == null) continue;
                n5 = 0;
                break;
            }
            if (n8 != null) {
                this.setRightSidePaint(WallPaint.COLORED);
            } else if (homeTexture2 != null) {
                this.setRightSidePaint(WallPaint.TEXTURED);
            } else if (n5 != 0) {
                this.setRightSidePaint(WallPaint.DEFAULT);
            } else {
                this.setRightSidePaint(null);
            }
            Float f8 = Float.valueOf(wall.getRightSideShininess());
            for (int i = 1; i < list.size(); ++i) {
                if (f8.equals(Float.valueOf(list.get(i).getRightSideShininess()))) continue;
                f8 = null;
                break;
            }
            this.setRightSideShininess(f8);
            Boolean bl4 = wall.getRightSideBaseboard() != null;
            for (int i = 1; i < list.size(); ++i) {
                if (bl4 == (list.get(i).getRightSideBaseboard() != null)) continue;
                bl4 = null;
                break;
            }
            this.getRightSideBaseboardController().setVisible(bl4);
            Baseboard baseboard6 = wall.getRightSideBaseboard();
            Float f9 = Float.valueOf(baseboard6 != null ? baseboard6.getThickness() : this.preferences.getNewWallBaseboardThickness());
            for (int i = 1; i < list.size(); ++i) {
                Baseboard baseboard7 = list.get(i).getRightSideBaseboard();
                if (f9.equals(Float.valueOf(baseboard7 != null ? baseboard7.getThickness() : this.preferences.getNewWallBaseboardThickness()))) continue;
                f9 = null;
                break;
            }
            this.getRightSideBaseboardController().setThickness(f9);
            Float f10 = Float.valueOf(baseboard6 != null ? baseboard6.getHeight() : this.preferences.getNewWallBaseboardHeight());
            for (int i = 1; i < list.size(); ++i) {
                serializable = list.get(i).getRightSideBaseboard();
                if (f10.equals(Float.valueOf(serializable != null ? ((Baseboard)serializable).getHeight() : this.preferences.getNewWallBaseboardHeight()))) continue;
                f10 = null;
                break;
            }
            this.getRightSideBaseboardController().setHeight(f10);
            Integer n9 = n2 = baseboard6 != null ? baseboard6.getColor() : null;
            if (n2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    Baseboard baseboard8 = list.get(i).getRightSideBaseboard();
                    if (baseboard8 != null && n2.equals(baseboard8.getColor())) continue;
                    n2 = null;
                    break;
                }
            }
            this.getRightSideBaseboardController().setColor(n2);
            Serializable serializable4 = serializable = baseboard6 != null ? baseboard6.getTexture() : null;
            if (serializable != null) {
                for (int i = 1; i < list.size(); ++i) {
                    baseboard = list.get(i).getRightSideBaseboard();
                    if (baseboard != null && ((HomeTexture)serializable).equals(baseboard.getTexture())) continue;
                    serializable = null;
                    break;
                }
            }
            this.getRightSideBaseboardController().getTextureController().setTexture((HomeTexture)serializable);
            n5 = 1;
            for (int i = 0; i < list.size(); ++i) {
                baseboard = list.get(i).getRightSideBaseboard();
                if (baseboard == null || baseboard.getColor() == null && baseboard.getTexture() == null) continue;
                n5 = 0;
                break;
            }
            if (n2 != null) {
                this.getRightSideBaseboardController().setPaint(BaseboardChoiceController.BaseboardPaint.COLORED);
            } else if (serializable != null) {
                this.getRightSideBaseboardController().setPaint(BaseboardChoiceController.BaseboardPaint.TEXTURED);
            } else if (n5 != 0) {
                this.getRightSideBaseboardController().setPaint(BaseboardChoiceController.BaseboardPaint.DEFAULT);
            } else {
                this.getRightSideBaseboardController().setPaint(null);
            }
            TextureImage textureImage = wall.getPattern();
            if (textureImage == null) {
                textureImage = this.preferences.getWallPattern();
            }
            for (int i = 1; i < list.size(); ++i) {
                TextureImage textureImage2 = list.get(i).getPattern();
                if (textureImage2 == null) {
                    textureImage2 = this.preferences.getWallPattern();
                }
                if (textureImage.equals(textureImage2)) continue;
                textureImage = null;
                break;
            }
            this.setPattern(textureImage);
            Integer n10 = wall.getTopColor();
            if (n10 != null) {
                bl = false;
                for (n = 1; n < list.size(); ++n) {
                    if (n10.equals(list.get(n).getTopColor())) continue;
                    n10 = null;
                    break;
                }
            } else {
                bl = true;
                for (n = 1; n < list.size(); ++n) {
                    if (list.get(n).getTopColor() == null) continue;
                    bl = false;
                    break;
                }
            }
            this.setTopColor(n10);
            if (bl) {
                this.setTopPaint(WallPaint.DEFAULT);
            } else if (n10 != null) {
                this.setTopPaint(WallPaint.COLORED);
            } else {
                this.setTopPaint(null);
            }
            Float f11 = wall.getHeight();
            if (f11 == null && wall.getHeight() == null) {
                f11 = Float.valueOf(this.home.getWallHeight());
            }
            for (int i = 1; i < list.size(); ++i) {
                float f12;
                Wall wall4 = list.get(i);
                float f13 = f12 = wall4.getHeight() == null ? this.home.getWallHeight() : wall4.getHeight().floatValue();
                if (f11.floatValue() == f12) continue;
                f11 = null;
                break;
            }
            this.setRectangularWallHeight(f11);
            this.setSlopingWallHeightAtStart(f11);
            Float f14 = wall.getHeightAtEnd();
            if (f14 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (f14.equals(list.get(i).getHeightAtEnd())) continue;
                    f14 = null;
                    break;
                }
            }
            this.setSlopingWallHeightAtEnd(f14 == null && list.size() == 1 ? f11 : f14);
            boolean bl5 = !wall.isTrapezoidal();
            boolean bl6 = wall.isTrapezoidal();
            for (int i = 1; i < list.size(); ++i) {
                if (!list.get(i).isTrapezoidal()) {
                    bl6 = false;
                    continue;
                }
                bl5 = false;
            }
            if (bl5) {
                this.setShape(WallShape.RECTANGULAR_WALL);
            } else if (bl6) {
                this.setShape(WallShape.SLOPING_WALL);
            } else {
                this.setShape(null);
            }
            Float f15 = Float.valueOf(wall.getThickness());
            for (int i = 1; i < list.size(); ++i) {
                if (f15.floatValue() == list.get(i).getThickness()) continue;
                f15 = null;
                break;
            }
            this.setThickness(f15);
            Float f16 = wall.getArcExtent();
            if (f16 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (f16.equals(list.get(i).getArcExtent())) continue;
                    f16 = null;
                    break;
                }
            }
            if (f16 != null) {
                this.setArcExtentInDegrees(Float.valueOf((float)Math.toDegrees(f16.floatValue())));
            } else {
                this.setArcExtentInDegrees(list.size() == 1 ? new Float(0.0f) : null);
            }
        }
    }

    public void setXStart(Float f) {
        if (f != this.xStart) {
            Float f2 = this.xStart;
            this.xStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.X_START.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getXStart() {
        return this.xStart;
    }

    public void setYStart(Float f) {
        if (f != this.yStart) {
            Float f2 = this.yStart;
            this.yStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y_START.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getYStart() {
        return this.yStart;
    }

    public void setXEnd(Float f) {
        if (f != this.xEnd) {
            Float f2 = this.xEnd;
            this.xEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.X_END.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getXEnd() {
        return this.xEnd;
    }

    public void setYEnd(Float f) {
        if (f != this.yEnd) {
            Float f2 = this.yEnd;
            this.yEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y_END.name(), f2, f);
            this.updateLength();
            this.updateDistanceToEndPoint();
        }
    }

    public Float getYEnd() {
        return this.yEnd;
    }

    private void updateLength() {
        Float f = this.getXStart();
        Float f2 = this.getYStart();
        Float f3 = this.getXEnd();
        Float f4 = this.getYEnd();
        if (f != null && f2 != null && f3 != null && f4 != null) {
            Wall wall = new Wall(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue(), 0.0f, 0.0f);
            Float f5 = this.getArcExtentInDegrees();
            if (f5 != null) {
                wall.setArcExtent(Float.valueOf((float)Math.toRadians(f5.floatValue())));
            }
            this.setLength(Float.valueOf(wall.getLength()), false);
        } else {
            this.setLength(null, false);
        }
    }

    public void setLength(Float f) {
        this.setLength(f, true);
    }

    public Float getLength() {
        return this.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setLength(Float f, boolean bl) {
        if (f == this.length) return;
        Float f2 = this.length;
        this.length = f;
        this.propertyChangeSupport.firePropertyChange(Property.LENGTH.name(), f2, f);
        if (!bl) return;
        Float f3 = this.getXStart();
        Float f4 = this.getYStart();
        Float f5 = this.getXEnd();
        Float f6 = this.getYEnd();
        if (f3 != null && f4 != null && f5 != null && f6 != null && f != null) {
            if (this.getArcExtentInDegrees() == null || this.getArcExtentInDegrees().floatValue() != 0.0f) throw new UnsupportedOperationException("Computing end point of a round wall from its length not supported");
            double d = Math.atan2(f4.floatValue() - f6.floatValue(), f5.floatValue() - f3.floatValue());
            this.setXEnd(Float.valueOf((float)((double)f3.floatValue() + (double)f.floatValue() * Math.cos(d))));
            this.setYEnd(Float.valueOf((float)((double)f4.floatValue() - (double)f.floatValue() * Math.sin(d))));
            return;
        } else {
            this.setXEnd(null);
            this.setYEnd(null);
        }
    }

    private void updateDistanceToEndPoint() {
        Float f = this.getXStart();
        Float f2 = this.getYStart();
        Float f3 = this.getXEnd();
        Float f4 = this.getYEnd();
        if (f != null && f2 != null && f3 != null && f4 != null) {
            this.setDistanceToEndPoint(Float.valueOf((float)Point2D.distance(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue())), false);
        } else {
            this.setDistanceToEndPoint(null, false);
        }
    }

    public void setDistanceToEndPoint(Float f) {
        this.setDistanceToEndPoint(f, true);
    }

    private void setDistanceToEndPoint(Float f, boolean bl) {
        if (f != this.distanceToEndPoint) {
            Float f2 = this.distanceToEndPoint;
            this.distanceToEndPoint = f;
            this.propertyChangeSupport.firePropertyChange(Property.DISTANCE_TO_END_POINT.name(), f2, f);
            if (bl) {
                Float f3 = this.getXStart();
                Float f4 = this.getYStart();
                Float f5 = this.getXEnd();
                Float f6 = this.getYEnd();
                if (f3 != null && f4 != null && f5 != null && f6 != null && f != null) {
                    double d = Math.atan2(f4.floatValue() - f6.floatValue(), f5.floatValue() - f3.floatValue());
                    this.setXEnd(Float.valueOf((float)((double)f3.floatValue() + (double)f.floatValue() * Math.cos(d))));
                    this.setYEnd(Float.valueOf((float)((double)f4.floatValue() - (double)f.floatValue() * Math.sin(d))));
                } else {
                    this.setXEnd(null);
                    this.setYEnd(null);
                }
            }
        }
    }

    public Float getDistanceToEndPoint() {
        return this.distanceToEndPoint;
    }

    public void setEditablePoints(boolean bl) {
        if (bl != this.editablePoints) {
            this.editablePoints = bl;
            this.propertyChangeSupport.firePropertyChange(Property.EDITABLE_POINTS.name(), !bl, bl);
        }
    }

    public boolean isEditablePoints() {
        return this.editablePoints;
    }

    public void setLeftSideColor(Integer n) {
        if (n != this.leftSideColor) {
            Integer n2 = this.leftSideColor;
            this.leftSideColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_COLOR.name(), n2, n);
            this.setLeftSidePaint(WallPaint.COLORED);
        }
    }

    public Integer getLeftSideColor() {
        return this.leftSideColor;
    }

    public void setLeftSidePaint(WallPaint wallPaint) {
        if (wallPaint != this.leftSidePaint) {
            WallPaint wallPaint2 = this.leftSidePaint;
            this.leftSidePaint = wallPaint;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_PAINT.name(), (Object)wallPaint2, (Object)wallPaint);
        }
    }

    public WallPaint getLeftSidePaint() {
        return this.leftSidePaint;
    }

    public void setLeftSideShininess(Float f) {
        if (f != this.leftSideShininess) {
            Float f2 = this.leftSideShininess;
            this.leftSideShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_SHININESS.name(), f2, f);
        }
    }

    public Float getLeftSideShininess() {
        return this.leftSideShininess;
    }

    public void setRightSideColor(Integer n) {
        if (n != this.rightSideColor) {
            Integer n2 = this.rightSideColor;
            this.rightSideColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_COLOR.name(), n2, n);
            this.setRightSidePaint(WallPaint.COLORED);
        }
    }

    public Integer getRightSideColor() {
        return this.rightSideColor;
    }

    public void setRightSidePaint(WallPaint wallPaint) {
        if (wallPaint != this.rightSidePaint) {
            WallPaint wallPaint2 = this.rightSidePaint;
            this.rightSidePaint = wallPaint;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_PAINT.name(), (Object)wallPaint2, (Object)wallPaint);
        }
    }

    public WallPaint getRightSidePaint() {
        return this.rightSidePaint;
    }

    public void setRightSideShininess(Float f) {
        if (f != this.rightSideShininess) {
            Float f2 = this.rightSideShininess;
            this.rightSideShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_SHININESS.name(), f2, f);
        }
    }

    public Float getRightSideShininess() {
        return this.rightSideShininess;
    }

    public void setPattern(TextureImage textureImage) {
        if (this.pattern != textureImage) {
            TextureImage textureImage2 = this.pattern;
            this.pattern = textureImage;
            this.propertyChangeSupport.firePropertyChange(Property.PATTERN.name(), textureImage2, textureImage);
        }
    }

    public TextureImage getPattern() {
        return this.pattern;
    }

    public void setTopColor(Integer n) {
        if (n != this.topColor) {
            Integer n2 = this.topColor;
            this.topColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.TOP_COLOR.name(), n2, n);
        }
    }

    public Integer getTopColor() {
        return this.topColor;
    }

    public void setTopPaint(WallPaint wallPaint) {
        if (wallPaint != this.topPaint) {
            WallPaint wallPaint2 = this.topPaint;
            this.topPaint = wallPaint;
            this.propertyChangeSupport.firePropertyChange(Property.TOP_PAINT.name(), (Object)wallPaint2, (Object)wallPaint);
        }
    }

    public WallPaint getTopPaint() {
        return this.topPaint;
    }

    public void setShape(WallShape wallShape) {
        if (wallShape != this.shape) {
            WallShape wallShape2 = this.shape;
            this.shape = wallShape;
            this.propertyChangeSupport.firePropertyChange(Property.SHAPE.name(), (Object)wallShape2, (Object)wallShape);
            if (wallShape == WallShape.RECTANGULAR_WALL) {
                if (this.rectangularWallHeight != null) {
                    this.getLeftSideBaseboardController().setMaxHeight(this.rectangularWallHeight);
                    this.getRightSideBaseboardController().setMaxHeight(this.rectangularWallHeight);
                }
            } else if (wallShape == WallShape.SLOPING_WALL) {
                if (this.slopingWallHeightAtStart != null && this.sloppingWallHeightAtEnd != null) {
                    float f = Math.max(this.sloppingWallHeightAtEnd.floatValue(), this.slopingWallHeightAtStart.floatValue());
                    this.getLeftSideBaseboardController().setMaxHeight(Float.valueOf(f));
                    this.getRightSideBaseboardController().setMaxHeight(Float.valueOf(f));
                } else if (this.slopingWallHeightAtStart != null) {
                    this.getLeftSideBaseboardController().setMaxHeight(this.slopingWallHeightAtStart);
                    this.getRightSideBaseboardController().setMaxHeight(this.slopingWallHeightAtStart);
                } else if (this.sloppingWallHeightAtEnd != null) {
                    this.getLeftSideBaseboardController().setMaxHeight(this.sloppingWallHeightAtEnd);
                    this.getRightSideBaseboardController().setMaxHeight(this.sloppingWallHeightAtEnd);
                }
            }
        }
    }

    public WallShape getShape() {
        return this.shape;
    }

    public void setRectangularWallHeight(Float f) {
        if (f != this.rectangularWallHeight) {
            Float f2 = this.rectangularWallHeight;
            this.rectangularWallHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.RECTANGULAR_WALL_HEIGHT.name(), f2, f);
            this.setShape(WallShape.RECTANGULAR_WALL);
            if (f != null) {
                this.getLeftSideBaseboardController().setMaxHeight(f);
                this.getRightSideBaseboardController().setMaxHeight(f);
            }
        }
    }

    public Float getRectangularWallHeight() {
        return this.rectangularWallHeight;
    }

    public void setSlopingWallHeightAtStart(Float f) {
        if (f != this.slopingWallHeightAtStart) {
            Float f2 = this.slopingWallHeightAtStart;
            this.slopingWallHeightAtStart = f;
            this.propertyChangeSupport.firePropertyChange(Property.SLOPING_WALL_HEIGHT_AT_START.name(), f2, f);
            this.setShape(WallShape.SLOPING_WALL);
            if (f != null) {
                float f3 = this.sloppingWallHeightAtEnd != null ? Math.max(this.sloppingWallHeightAtEnd.floatValue(), f.floatValue()) : f.floatValue();
                f3 = Math.max(f3, this.preferences.getLengthUnit().getMinimumLength());
                this.getLeftSideBaseboardController().setMaxHeight(Float.valueOf(f3));
                this.getRightSideBaseboardController().setMaxHeight(Float.valueOf(f3));
            }
        }
    }

    public Float getSlopingWallHeightAtStart() {
        return this.slopingWallHeightAtStart;
    }

    public void setSlopingWallHeightAtEnd(Float f) {
        if (f != this.sloppingWallHeightAtEnd) {
            Float f2 = this.sloppingWallHeightAtEnd;
            this.sloppingWallHeightAtEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.SLOPING_WALL_HEIGHT_AT_END.name(), f2, f);
            this.setShape(WallShape.SLOPING_WALL);
            if (f != null) {
                float f3 = this.slopingWallHeightAtStart != null ? Math.max(this.slopingWallHeightAtStart.floatValue(), f.floatValue()) : f.floatValue();
                f3 = Math.max(f3, this.preferences.getLengthUnit().getMinimumLength());
                this.getLeftSideBaseboardController().setMaxHeight(Float.valueOf(f3));
                this.getRightSideBaseboardController().setMaxHeight(Float.valueOf(f3));
            }
        }
    }

    public Float getSlopingWallHeightAtEnd() {
        return this.sloppingWallHeightAtEnd;
    }

    public void setThickness(Float f) {
        if (f != this.thickness) {
            Float f2 = this.thickness;
            this.thickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.THICKNESS.name(), f2, f);
        }
    }

    public Float getThickness() {
        return this.thickness;
    }

    public void setArcExtentInDegrees(Float f) {
        if (f != this.arcExtentInDegrees) {
            Float f2 = this.arcExtentInDegrees;
            this.arcExtentInDegrees = f;
            this.propertyChangeSupport.firePropertyChange(Property.ARC_EXTENT_IN_DEGREES.name(), f2, f);
        }
    }

    public Float getArcExtentInDegrees() {
        return this.arcExtentInDegrees;
    }

    public Float getArcLength() {
        Float f = this.getXStart();
        Float f2 = this.getYStart();
        Float f3 = this.getXEnd();
        Float f4 = this.getYEnd();
        Float f5 = this.getArcExtentInDegrees();
        if (f != null && f2 != null && f3 != null && f4 != null && f5 != null) {
            Wall wall = new Wall(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue(), 1.0E-5f, 0.0f);
            wall.setArcExtent(Float.valueOf((float)Math.toRadians(f5.floatValue())));
            return Float.valueOf(wall.getLength());
        }
        return null;
    }

    public void modifyWalls() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Wall> list2 = Home.getWallsSubList(list);
        if (!list2.isEmpty()) {
            Float f = this.getXStart();
            Float f2 = this.getYStart();
            Float f3 = this.getXEnd();
            Float f4 = this.getYEnd();
            WallPaint wallPaint = this.getLeftSidePaint();
            Integer n = wallPaint == WallPaint.COLORED ? this.getLeftSideColor() : null;
            HomeTexture homeTexture = wallPaint == WallPaint.TEXTURED ? this.getLeftSideTextureController().getTexture() : null;
            Float f5 = this.getLeftSideShininess();
            Boolean bl = this.getLeftSideBaseboardController().getVisible();
            Float f6 = this.getLeftSideBaseboardController().getThickness();
            Float f7 = this.getLeftSideBaseboardController().getHeight();
            BaseboardChoiceController.BaseboardPaint baseboardPaint = this.getLeftSideBaseboardController().getPaint();
            Integer n2 = baseboardPaint == BaseboardChoiceController.BaseboardPaint.COLORED ? this.getLeftSideBaseboardController().getColor() : null;
            HomeTexture homeTexture2 = baseboardPaint == BaseboardChoiceController.BaseboardPaint.TEXTURED ? this.getLeftSideBaseboardController().getTextureController().getTexture() : null;
            WallPaint wallPaint2 = this.getRightSidePaint();
            Integer n3 = wallPaint2 == WallPaint.COLORED ? this.getRightSideColor() : null;
            HomeTexture homeTexture3 = wallPaint2 == WallPaint.TEXTURED ? this.getRightSideTextureController().getTexture() : null;
            Float f8 = this.getRightSideShininess();
            Boolean bl2 = this.getRightSideBaseboardController().getVisible();
            Float f9 = this.getRightSideBaseboardController().getThickness();
            Float f10 = this.getRightSideBaseboardController().getHeight();
            BaseboardChoiceController.BaseboardPaint baseboardPaint2 = this.getRightSideBaseboardController().getPaint();
            Integer n4 = baseboardPaint2 == BaseboardChoiceController.BaseboardPaint.COLORED ? this.getRightSideBaseboardController().getColor() : null;
            HomeTexture homeTexture4 = baseboardPaint2 == BaseboardChoiceController.BaseboardPaint.TEXTURED ? this.getRightSideBaseboardController().getTextureController().getTexture() : null;
            TextureImage textureImage = this.getPattern();
            boolean bl3 = this.getTopPaint() != null;
            Integer n5 = this.getTopPaint() == WallPaint.COLORED ? this.getTopColor() : null;
            Float f11 = this.getThickness();
            Float f12 = this.getArcExtentInDegrees();
            if (f12 != null) {
                f12 = Float.valueOf((float)Math.toRadians(f12.floatValue()));
            }
            Float f13 = this.getShape() == WallShape.SLOPING_WALL ? this.getSlopingWallHeightAtStart() : (this.getShape() == WallShape.RECTANGULAR_WALL ? this.getRectangularWallHeight() : null);
            Float f14 = this.getShape() == WallShape.SLOPING_WALL ? this.getSlopingWallHeightAtEnd() : (this.getShape() == WallShape.RECTANGULAR_WALL ? this.getRectangularWallHeight() : null);
            if (f13 != null && f14 != null) {
                float f15 = Math.max(f13.floatValue(), f14.floatValue());
                if (f7 != null) {
                    f7 = Float.valueOf(Math.min(f7.floatValue(), f15));
                }
                if (f10 != null) {
                    f10 = Float.valueOf(Math.min(f10.floatValue(), f15));
                }
            }
            ModifiedWall[] modifiedWallArray = new ModifiedWall[list2.size()];
            for (int i = 0; i < modifiedWallArray.length; ++i) {
                modifiedWallArray[i] = new ModifiedWall(list2.get(i));
            }
            WallController.doModifyWalls(modifiedWallArray, this.preferences.getNewWallBaseboardThickness(), this.preferences.getNewWallBaseboardHeight(), f, f2, f3, f4, wallPaint, n, homeTexture, f5, bl, f6, f7, baseboardPaint, n2, homeTexture2, wallPaint2, n3, homeTexture3, f8, bl2, f9, f10, baseboardPaint2, n4, homeTexture4, textureImage, bl3, n5, f13, f14, f11, f12);
            if (this.undoSupport != null) {
                WallsModificationUndoableEdit wallsModificationUndoableEdit = new WallsModificationUndoableEdit(this.home, this.preferences, list, modifiedWallArray, this.preferences.getNewWallBaseboardThickness(), this.preferences.getNewWallBaseboardHeight(), f, f2, f3, f4, wallPaint, n, homeTexture, f5, bl, f6, f7, baseboardPaint, n2, homeTexture2, wallPaint2, n3, homeTexture3, f8, bl2, f9, f10, baseboardPaint2, n4, homeTexture4, textureImage, bl3, n5, f13, f14, f11, f12);
                this.undoSupport.postEdit(wallsModificationUndoableEdit);
            }
        }
    }

    private static void doModifyWalls(ModifiedWall[] modifiedWallArray, float f, float f2, Float f3, Float f4, Float f5, Float f6, WallPaint wallPaint, Integer n, HomeTexture homeTexture, Float f7, Boolean bl, Float f8, Float f9, BaseboardChoiceController.BaseboardPaint baseboardPaint, Integer n2, HomeTexture homeTexture2, WallPaint wallPaint2, Integer n3, HomeTexture homeTexture3, Float f10, Boolean bl2, Float f11, Float f12, BaseboardChoiceController.BaseboardPaint baseboardPaint2, Integer n4, HomeTexture homeTexture4, TextureImage textureImage, boolean bl3, Integer n5, Float f13, Float f14, Float f15, Float f16) {
        for (ModifiedWall modifiedWall : modifiedWallArray) {
            HomeTexture homeTexture5;
            Integer n6;
            float f17;
            float f18;
            Baseboard baseboard;
            Wall wall = modifiedWall.getWall();
            WallController.moveWallPoints(wall, f3, f4, f5, f6);
            if (wallPaint != null) {
                switch (wallPaint) {
                    case DEFAULT: {
                        wall.setLeftSideColor(null);
                        wall.setLeftSideTexture(null);
                        break;
                    }
                    case COLORED: {
                        if (n != null) {
                            wall.setLeftSideColor(n);
                        }
                        wall.setLeftSideTexture(null);
                        break;
                    }
                    case TEXTURED: {
                        wall.setLeftSideColor(null);
                        if (homeTexture == null) break;
                        wall.setLeftSideTexture(homeTexture);
                    }
                }
            }
            if (f7 != null) {
                wall.setLeftSideShininess(f7.floatValue());
            }
            if (bl == Boolean.FALSE) {
                wall.setLeftSideBaseboard(null);
            } else {
                baseboard = wall.getLeftSideBaseboard();
                if (bl == Boolean.TRUE || baseboard != null) {
                    f18 = baseboard != null ? baseboard.getThickness() : f;
                    f17 = baseboard != null ? baseboard.getHeight() : f2;
                    n6 = baseboard != null ? baseboard.getColor() : null;
                    HomeTexture homeTexture6 = homeTexture5 = baseboard != null ? baseboard.getTexture() : null;
                    if (baseboardPaint != null) {
                        switch (baseboardPaint) {
                            case DEFAULT: {
                                n6 = null;
                                homeTexture5 = null;
                                break;
                            }
                            case COLORED: {
                                if (n2 != null) {
                                    n6 = n2;
                                }
                                homeTexture5 = null;
                                break;
                            }
                            case TEXTURED: {
                                n6 = null;
                                if (homeTexture2 == null) break;
                                homeTexture5 = homeTexture2;
                            }
                        }
                    }
                    wall.setLeftSideBaseboard(Baseboard.getInstance(f8 != null ? f8.floatValue() : f18, f9 != null ? f9.floatValue() : f17, n6, homeTexture5));
                }
            }
            if (wallPaint2 != null) {
                switch (wallPaint2) {
                    case DEFAULT: {
                        wall.setRightSideColor(null);
                        wall.setRightSideTexture(null);
                        break;
                    }
                    case COLORED: {
                        if (n3 != null) {
                            wall.setRightSideColor(n3);
                        }
                        wall.setRightSideTexture(null);
                        break;
                    }
                    case TEXTURED: {
                        wall.setRightSideColor(null);
                        if (homeTexture3 == null) break;
                        wall.setRightSideTexture(homeTexture3);
                    }
                }
            }
            if (f10 != null) {
                wall.setRightSideShininess(f10.floatValue());
            }
            if (bl2 == Boolean.FALSE) {
                wall.setRightSideBaseboard(null);
            } else {
                baseboard = wall.getRightSideBaseboard();
                if (bl2 == Boolean.TRUE || baseboard != null) {
                    f18 = baseboard != null ? baseboard.getThickness() : f;
                    f17 = baseboard != null ? baseboard.getHeight() : f2;
                    n6 = baseboard != null ? baseboard.getColor() : null;
                    HomeTexture homeTexture7 = homeTexture5 = baseboard != null ? baseboard.getTexture() : null;
                    if (baseboardPaint2 != null) {
                        switch (baseboardPaint2) {
                            case DEFAULT: {
                                n6 = null;
                                homeTexture5 = null;
                                break;
                            }
                            case COLORED: {
                                if (n4 != null) {
                                    n6 = n4;
                                }
                                homeTexture5 = null;
                                break;
                            }
                            case TEXTURED: {
                                n6 = null;
                                if (homeTexture4 == null) break;
                                homeTexture5 = homeTexture4;
                            }
                        }
                    }
                    wall.setRightSideBaseboard(Baseboard.getInstance(f11 != null ? f11.floatValue() : f18, f12 != null ? f12.floatValue() : f17, n6, homeTexture5));
                }
            }
            if (textureImage != null) {
                wall.setPattern(textureImage);
            }
            if (bl3) {
                wall.setTopColor(n5);
            }
            if (f13 != null) {
                wall.setHeight(f13);
                if (f14 != null) {
                    if (f14.equals(f13)) {
                        wall.setHeightAtEnd(null);
                    } else {
                        wall.setHeightAtEnd(f14);
                    }
                }
            }
            if (f15 != null) {
                wall.setThickness(f15.floatValue());
            }
            if (f16 == null) continue;
            if (f16.floatValue() == 0.0f) {
                wall.setArcExtent(null);
                continue;
            }
            wall.setArcExtent(f16);
        }
    }

    private static void undoModifyWalls(ModifiedWall[] modifiedWallArray) {
        for (ModifiedWall modifiedWall : modifiedWallArray) {
            Wall wall = modifiedWall.getWall();
            WallController.moveWallPoints(wall, Float.valueOf(modifiedWall.getXStart()), Float.valueOf(modifiedWall.getYStart()), Float.valueOf(modifiedWall.getXEnd()), Float.valueOf(modifiedWall.getYEnd()));
            wall.setLeftSideColor(modifiedWall.getLeftSideColor());
            wall.setLeftSideTexture(modifiedWall.getLeftSideTexture());
            wall.setLeftSideShininess(modifiedWall.getLeftSideShininess());
            wall.setLeftSideBaseboard(modifiedWall.getLeftSideBaseboard());
            wall.setRightSideColor(modifiedWall.getRightSideColor());
            wall.setRightSideTexture(modifiedWall.getRightSideTexture());
            wall.setRightSideShininess(modifiedWall.getRightSideShininess());
            wall.setRightSideBaseboard(modifiedWall.getRightSideBaseboard());
            wall.setPattern(modifiedWall.getPattern());
            wall.setTopColor(modifiedWall.getTopColor());
            wall.setHeight(modifiedWall.getHeight());
            wall.setHeightAtEnd(modifiedWall.getHeightAtEnd());
            wall.setThickness(modifiedWall.getThickness());
            wall.setArcExtent(modifiedWall.getArcExtent());
        }
    }

    private static void moveWallPoints(Wall wall, Float f, Float f2, Float f3, Float f4) {
        Wall wall2 = wall.getWallAtStart();
        if (f != null) {
            wall.setXStart(f.floatValue());
            if (wall2 != null) {
                if (wall2.getWallAtStart() == wall) {
                    wall2.setXStart(f.floatValue());
                } else if (wall2.getWallAtEnd() == wall) {
                    wall2.setXEnd(f.floatValue());
                }
            }
        }
        if (f2 != null) {
            wall.setYStart(f2.floatValue());
            if (wall2 != null) {
                if (wall2.getWallAtStart() == wall) {
                    wall2.setYStart(f2.floatValue());
                } else if (wall2.getWallAtEnd() == wall) {
                    wall2.setYEnd(f2.floatValue());
                }
            }
        }
        Wall wall3 = wall.getWallAtEnd();
        if (f3 != null) {
            wall.setXEnd(f3.floatValue());
            if (wall3 != null) {
                if (wall3.getWallAtStart() == wall) {
                    wall3.setXStart(f3.floatValue());
                } else if (wall3.getWallAtEnd() == wall) {
                    wall3.setXEnd(f3.floatValue());
                }
            }
        }
        if (f4 != null) {
            wall.setYEnd(f4.floatValue());
            if (wall3 != null) {
                if (wall3.getWallAtStart() == wall) {
                    wall3.setYStart(f4.floatValue());
                } else if (wall3.getWallAtEnd() == wall) {
                    wall3.setYEnd(f4.floatValue());
                }
            }
        }
    }

    private static final class ModifiedWall {
        private final Wall wall;
        private final float xStart;
        private final float yStart;
        private final float xEnd;
        private final float yEnd;
        private final Integer leftSideColor;
        private final HomeTexture leftSideTexture;
        private final float leftSideShininess;
        private final Baseboard leftSideBaseboard;
        private final Integer rightSideColor;
        private final HomeTexture rightSideTexture;
        private final float rightSideShininess;
        private final Baseboard rightSideBaseboard;
        private final TextureImage pattern;
        private final Integer topColor;
        private final Float height;
        private final Float heightAtEnd;
        private final float thickness;
        private final Float arcExtent;

        public ModifiedWall(Wall wall) {
            this.wall = wall;
            this.xStart = wall.getXStart();
            this.yStart = wall.getYStart();
            this.xEnd = wall.getXEnd();
            this.yEnd = wall.getYEnd();
            this.leftSideColor = wall.getLeftSideColor();
            this.leftSideTexture = wall.getLeftSideTexture();
            this.leftSideShininess = wall.getLeftSideShininess();
            this.leftSideBaseboard = wall.getLeftSideBaseboard();
            this.rightSideColor = wall.getRightSideColor();
            this.rightSideTexture = wall.getRightSideTexture();
            this.rightSideShininess = wall.getRightSideShininess();
            this.rightSideBaseboard = wall.getRightSideBaseboard();
            this.pattern = wall.getPattern();
            this.topColor = wall.getTopColor();
            this.height = wall.getHeight();
            this.heightAtEnd = wall.getHeightAtEnd();
            this.thickness = wall.getThickness();
            this.arcExtent = wall.getArcExtent();
        }

        public Wall getWall() {
            return this.wall;
        }

        public float getXStart() {
            return this.xStart;
        }

        public float getXEnd() {
            return this.xEnd;
        }

        public float getYStart() {
            return this.yStart;
        }

        public float getYEnd() {
            return this.yEnd;
        }

        public Float getHeight() {
            return this.height;
        }

        public Float getHeightAtEnd() {
            return this.heightAtEnd;
        }

        public Integer getLeftSideColor() {
            return this.leftSideColor;
        }

        public HomeTexture getLeftSideTexture() {
            return this.leftSideTexture;
        }

        public float getLeftSideShininess() {
            return this.leftSideShininess;
        }

        public Baseboard getLeftSideBaseboard() {
            return this.leftSideBaseboard;
        }

        public Integer getRightSideColor() {
            return this.rightSideColor;
        }

        public HomeTexture getRightSideTexture() {
            return this.rightSideTexture;
        }

        public float getRightSideShininess() {
            return this.rightSideShininess;
        }

        public Baseboard getRightSideBaseboard() {
            return this.rightSideBaseboard;
        }

        public TextureImage getPattern() {
            return this.pattern;
        }

        public Integer getTopColor() {
            return this.topColor;
        }

        public float getThickness() {
            return this.thickness;
        }

        public Float getArcExtent() {
            return this.arcExtent;
        }
    }

    public static enum WallPaint {
        DEFAULT,
        COLORED,
        TEXTURED;

    }

    public static enum Property {
        X_START,
        Y_START,
        X_END,
        Y_END,
        LENGTH,
        DISTANCE_TO_END_POINT,
        EDITABLE_POINTS,
        LEFT_SIDE_COLOR,
        LEFT_SIDE_PAINT,
        LEFT_SIDE_SHININESS,
        RIGHT_SIDE_COLOR,
        RIGHT_SIDE_PAINT,
        RIGHT_SIDE_SHININESS,
        PATTERN,
        TOP_COLOR,
        TOP_PAINT,
        SHAPE,
        RECTANGULAR_WALL_HEIGHT,
        SLOPING_WALL_HEIGHT_AT_START,
        SLOPING_WALL_HEIGHT_AT_END,
        THICKNESS,
        ARC_EXTENT_IN_DEGREES;

    }

    public static enum WallShape {
        RECTANGULAR_WALL,
        SLOPING_WALL;

    }

    private static class WallsModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final List<Selectable> oldSelection;
        private final ModifiedWall[] modifiedWalls;
        private final float newWallBaseboardThickness;
        private final float newWallBaseboardHeight;
        private final Float xStart;
        private final Float yStart;
        private final Float xEnd;
        private final Float yEnd;
        private final WallPaint leftSidePaint;
        private final Integer leftSideColor;
        private final HomeTexture leftSideTexture;
        private final Float leftSideShininess;
        private final Boolean leftSideBaseboardVisible;
        private final Float leftSideBaseboardThickness;
        private final Float leftSideBaseboardHeight;
        private final BaseboardChoiceController.BaseboardPaint leftSideBaseboardPaint;
        private final Integer leftSideBaseboardColor;
        private final HomeTexture leftSideBaseboardTexture;
        private final WallPaint rightSidePaint;
        private final Integer rightSideColor;
        private final HomeTexture rightSideTexture;
        private final Float rightSideShininess;
        private final Boolean rightSideBaseboardVisible;
        private final Float rightSideBaseboardThickness;
        private final Float rightSideBaseboardHeight;
        private final BaseboardChoiceController.BaseboardPaint rightSideBaseboardPaint;
        private final Integer rightSideBaseboardColor;
        private final HomeTexture rightSideBaseboardTexture;
        private final TextureImage pattern;
        private final boolean modifiedTopColor;
        private final Integer topColor;
        private final Float height;
        private final Float heightAtEnd;
        private final Float thickness;
        private final Float arcExtent;

        private WallsModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, ModifiedWall[] modifiedWallArray, float f, float f2, Float f3, Float f4, Float f5, Float f6, WallPaint wallPaint, Integer n, HomeTexture homeTexture, Float f7, Boolean bl, Float f8, Float f9, BaseboardChoiceController.BaseboardPaint baseboardPaint, Integer n2, HomeTexture homeTexture2, WallPaint wallPaint2, Integer n3, HomeTexture homeTexture3, Float f10, Boolean bl2, Float f11, Float f12, BaseboardChoiceController.BaseboardPaint baseboardPaint2, Integer n4, HomeTexture homeTexture4, TextureImage textureImage, boolean bl3, Integer n5, Float f13, Float f14, Float f15, Float f16) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.modifiedWalls = modifiedWallArray;
            this.newWallBaseboardThickness = f;
            this.newWallBaseboardHeight = f2;
            this.xStart = f3;
            this.yStart = f4;
            this.xEnd = f5;
            this.yEnd = f6;
            this.leftSidePaint = wallPaint;
            this.leftSideColor = n;
            this.leftSideShininess = f7;
            this.leftSideBaseboardVisible = bl;
            this.leftSideBaseboardThickness = f8;
            this.leftSideBaseboardHeight = f9;
            this.leftSideBaseboardPaint = baseboardPaint;
            this.leftSideBaseboardColor = n2;
            this.leftSideBaseboardTexture = homeTexture2;
            this.rightSidePaint = wallPaint2;
            this.rightSideColor = n3;
            this.rightSideTexture = homeTexture3;
            this.leftSideTexture = homeTexture;
            this.rightSideShininess = f10;
            this.rightSideBaseboardVisible = bl2;
            this.rightSideBaseboardThickness = f11;
            this.rightSideBaseboardHeight = f12;
            this.rightSideBaseboardPaint = baseboardPaint2;
            this.rightSideBaseboardColor = n4;
            this.rightSideBaseboardTexture = homeTexture4;
            this.pattern = textureImage;
            this.modifiedTopColor = bl3;
            this.topColor = n5;
            this.height = f13;
            this.heightAtEnd = f14;
            this.thickness = f15;
            this.arcExtent = f16;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            WallController.undoModifyWalls(this.modifiedWalls);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            WallController.doModifyWalls(this.modifiedWalls, this.newWallBaseboardThickness, this.newWallBaseboardHeight, this.xStart, this.yStart, this.xEnd, this.yEnd, this.leftSidePaint, this.leftSideColor, this.leftSideTexture, this.leftSideShininess, this.leftSideBaseboardVisible, this.leftSideBaseboardThickness, this.leftSideBaseboardHeight, this.leftSideBaseboardPaint, this.leftSideBaseboardColor, this.leftSideBaseboardTexture, this.rightSidePaint, this.rightSideColor, this.rightSideTexture, this.rightSideShininess, this.rightSideBaseboardVisible, this.rightSideBaseboardThickness, this.rightSideBaseboardHeight, this.rightSideBaseboardPaint, this.rightSideBaseboardColor, this.rightSideBaseboardTexture, this.pattern, this.modifiedTopColor, this.topColor, this.height, this.heightAtEnd, this.thickness, this.arcExtent);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(WallController.class, "undoModifyWallsName", new Object[0]);
        }
    }
}

