/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge.ui;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.columns.merge.GeneralColumnTitleChooser;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class GeneralColumnTitleChooserUI
extends JPanel
implements ManipulatorUI {
    private GeneralColumnTitleChooser manipulator;
    private DialogControls dialogControls;
    private Table table;
    private String displayName;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public GeneralColumnTitleChooserUI() {
        this.initComponents();
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GeneralColumnTitleChooserUI.this.refreshOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GeneralColumnTitleChooserUI.this.refreshOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GeneralColumnTitleChooserUI.this.refreshOkButton();
            }
        });
    }

    private void refreshOkButton() {
        String text = this.titleTextField.getText();
        this.dialogControls.setOkButtonEnabled(text != null && !text.isEmpty() && this.table != null && !this.table.hasColumn(text));
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (GeneralColumnTitleChooser)m;
        this.table = this.manipulator.getTable();
        this.dialogControls = dialogControls;
        this.displayName = m.getName();
        this.titleTextField.setText(this.manipulator.getColumnTitle());
        this.refreshOkButton();
    }

    public void unSetup() {
        this.manipulator.setColumnTitle(this.titleTextField.getText());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public JPanel getSettingsPanel() {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add((JTextComponent)this.titleTextField, new Validator[]{new ColumnTitleValidator(this.table)});
        return validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.titleLabel.setText(NbBundle.getMessage(GeneralColumnTitleChooserUI.class, (String)"GeneralColumnTitleChooserUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(GeneralColumnTitleChooserUI.class, (String)"GeneralColumnTitleChooserUI.titleTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleTextField, -1, 150, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

