/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.doubles.Double2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.impl.TimeIndexImpl;
import org.gephi.graph.impl.TimeIndexStore;

public class TimestampIndexImpl<T extends Element>
extends TimeIndexImpl<T, Double, TimestampSet, TimestampMap<?>> {
    public TimestampIndexImpl(TimeIndexStore<T, Double, TimestampSet, TimestampMap<?>> store, boolean main) {
        super(store, main);
    }

    @Override
    public double getMinTimestamp() {
        if (this.mainIndex) {
            Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                return sortedMap.firstDoubleKey();
            }
        } else {
            Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                for (Double2IntMap.Entry entry : sortedMap.double2IntEntrySet()) {
                    TimeIndexImpl.TimeIndexEntry timestampEntry;
                    double timestamp = entry.getDoubleKey();
                    int index = entry.getIntValue();
                    if (index >= this.timestamps.length || (timestampEntry = this.timestamps[index]) == null) continue;
                    return timestamp;
                }
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMaxTimestamp() {
        if (this.mainIndex) {
            Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                return sortedMap.lastDoubleKey();
            }
        } else {
            Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                ObjectBidirectionalIterator bi = sortedMap.double2IntEntrySet().iterator(sortedMap.double2IntEntrySet().last());
                while (bi.hasPrevious()) {
                    TimeIndexImpl.TimeIndexEntry timestampEntry;
                    Double2IntMap.Entry entry = (Double2IntMap.Entry)bi.previous();
                    double timestamp = entry.getDoubleKey();
                    int index = entry.getIntValue();
                    if (index >= this.timestamps.length || (timestampEntry = this.timestamps[index]) == null) continue;
                    return timestamp;
                }
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ElementIterable get(double timestamp) {
        TimeIndexImpl.TimeIndexEntry ts;
        this.checkDouble(timestamp);
        this.readLock();
        Integer index = this.timestampIndexStore.timeSortedMap.get(timestamp);
        if (index != null && index < this.timestamps.length && (ts = this.timestamps[index]) != null) {
            return new TimeIndexImpl.ElementIterableImpl(new TimeIndexImpl.ElementIteratorImpl((ObjectIterator<Element>)ts.elementSet.iterator()));
        }
        this.readUnlock();
        return ElementIterable.EMPTY;
    }

    @Override
    public ElementIterable get(Interval interval) {
        this.checkDouble(interval.getLow());
        this.checkDouble(interval.getHigh());
        this.readLock();
        ObjectOpenHashSet elements = new ObjectOpenHashSet();
        Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
        if (!sortedMap.isEmpty()) {
            for (Double2IntMap.Entry entry : sortedMap.tailMap(interval.getLow()).double2IntEntrySet()) {
                TimeIndexImpl.TimeIndexEntry ts;
                double timestamp = entry.getDoubleKey();
                int index = entry.getIntValue();
                if (!(timestamp <= interval.getHigh())) break;
                if (index >= this.timestamps.length || (ts = this.timestamps[index]) == null) continue;
                elements.addAll(ts.elementSet);
            }
        }
        if (!elements.isEmpty()) {
            return new TimeIndexImpl.ElementIterableImpl(new TimeIndexImpl.ElementIteratorImpl((ObjectIterator<Element>)elements.iterator()));
        }
        this.readUnlock();
        return ElementIterable.EMPTY;
    }
}

