# -*- coding: utf-8 -*-
info = {
    "name": "ne",
    "date_order": "YMD",
    "january": [
        "जनवरी"
    ],
    "february": [
        "फेब्रुअरी"
    ],
    "march": [
        "मार्च"
    ],
    "april": [
        "अप्रिल"
    ],
    "may": [
        "मे",
        "मई"
    ],
    "june": [
        "जुन"
    ],
    "july": [
        "जुलाई"
    ],
    "august": [
        "अगस्ट"
    ],
    "september": [
        "सेप्टेम्बर"
    ],
    "october": [
        "अक्टोबर"
    ],
    "november": [
        "नोभेम्बर"
    ],
    "december": [
        "डिसेम्बर"
    ],
    "monday": [
        "सोमबार",
        "सोम"
    ],
    "tuesday": [
        "मङ्गलबार",
        "मङ्गल"
    ],
    "wednesday": [
        "बुधबार",
        "बुध"
    ],
    "thursday": [
        "बिहिबार",
        "बिहि"
    ],
    "friday": [
        "शुक्रबार",
        "शुक्र"
    ],
    "saturday": [
        "शनिबार",
        "शनि"
    ],
    "sunday": [
        "आइतबार",
        "आइत"
    ],
    "am": [
        "पूर्वाह्न"
    ],
    "pm": [
        "अपराह्न"
    ],
    "year": [
        "वर्ष",
        "बर्ष"
    ],
    "month": [
        "महिना"
    ],
    "week": [
        "हप्ता"
    ],
    "day": [
        "बार"
    ],
    "hour": [
        "घण्टा"
    ],
    "minute": [
        "मिनेट"
    ],
    "second": [
        "सेकेन्ड"
    ],
    "relative-type": {
        "1 year ago": [
            "गत वर्ष"
        ],
        "0 year ago": [
            "यो वर्ष"
        ],
        "in 1 year": [
            "अर्को वर्ष"
        ],
        "1 month ago": [
            "गत महिना"
        ],
        "0 month ago": [
            "यो महिना"
        ],
        "in 1 month": [
            "अर्को महिना"
        ],
        "1 week ago": [
            "गत हप्ता"
        ],
        "0 week ago": [
            "यो हप्ता"
        ],
        "in 1 week": [
            "आउने हप्ता"
        ],
        "1 day ago": [
            "हिजो"
        ],
        "0 day ago": [
            "आज"
        ],
        "in 1 day": [
            "भोलि"
        ],
        "0 hour ago": [
            "यो घडीमा"
        ],
        "0 minute ago": [
            "यही मिनेटमा"
        ],
        "0 second ago": [
            "अब"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) वर्षमा"
        ],
        "\\1 year ago": [
            "(\\d+) वर्ष अघि"
        ],
        "in \\1 month": [
            "(\\d+) महिनामा"
        ],
        "\\1 month ago": [
            "(\\d+) महिना पहिले"
        ],
        "in \\1 week": [
            "(\\d+) हप्तामा"
        ],
        "\\1 week ago": [
            "(\\d+) हप्ता पहिले"
        ],
        "in \\1 day": [
            "(\\d+) दिनमा"
        ],
        "\\1 day ago": [
            "(\\d+) दिन पहिले"
        ],
        "in \\1 hour": [
            "(\\d+) घण्टामा"
        ],
        "\\1 hour ago": [
            "(\\d+) घण्टा पहिले"
        ],
        "in \\1 minute": [
            "(\\d+) मिनेटमा"
        ],
        "\\1 minute ago": [
            "(\\d+) मिनेट पहिले"
        ],
        "in \\1 second": [
            "(\\d+) सेकेण्डमा"
        ],
        "\\1 second ago": [
            "(\\d+) सेकेण्ड पहिले"
        ]
    },
    "locale_specific": {
        "ne-IN": {
            "name": "ne-IN"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
