/*
 * Decompiled with CFR 0.152.
 */
package processing.app.forms;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Theme;

public class PasswordAuthorizationDialog
extends JDialog {
    private final JPasswordField passwordField;
    private boolean cancelled = false;
    private String password = null;

    public PasswordAuthorizationDialog(Frame parent, String dialogText) {
        super(parent, true);
        JLabel typePasswordLabel = new JLabel();
        JLabel icon = new JLabel();
        JLabel passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        JButton uploadButton = new JButton();
        JButton cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        typePasswordLabel.setText(dialogText);
        icon.setIcon(new ImageIcon(Theme.getThemeResource("theme/lock.png").getUrl()));
        passwordLabel.setText(I18n.tr((String)"Password:"));
        this.passwordField.setText("");
        this.passwordField.addActionListener(this::uploadButtonPressed);
        uploadButton.setText(I18n.tr((String)"Upload"));
        uploadButton.addActionListener(this::uploadButtonPressed);
        cancelButton.setText(I18n.tr((String)"Cancel"));
        cancelButton.addActionListener(this::cancelButtonPressed);
        Base.registerWindowCloseKeys(this.getRootPane(), this::cancelButtonPressed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(icon, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(typePasswordLabel).addGroup(layout.createSequentialGroup().addComponent(passwordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordField, -2, 300, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(uploadButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(typePasswordLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(53, 53, 53).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addGap(18, 18, 18)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(icon).addGap(9, 9, 9))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(uploadButton).addComponent(cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonPressed(ActionEvent event) {
        this.cancelled = true;
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void uploadButtonPressed(ActionEvent event) {
        this.password = new String(this.passwordField.getPassword());
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

