/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLEngine_9;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLEngineUtil {
    SSLEngineUtil() {
    }

    static ProvSSLEngine create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        return new ProvSSLEngine_9(provSSLContextSpi, contextData);
    }

    static ProvSSLEngine create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) {
        return new ProvSSLEngine_9(provSSLContextSpi, contextData, string, n);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sSLEngine) {
        SSLSession sSLSession;
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getBCHandshakeSession();
        }
        if (null != sSLEngine && null != (sSLSession = sSLEngine.getHandshakeSession())) {
            return SSLSessionUtil.importSSLSession(sSLSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sSLEngine) {
        SSLParameters sSLParameters;
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getParameters();
        }
        if (null != sSLEngine && null != (sSLParameters = sSLEngine.getSSLParameters())) {
            return SSLParametersUtil.importSSLParameters(sSLParameters);
        }
        return null;
    }
}

