/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.LongSet;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class TreeObject {
    private static final int BUFFER_SIZE = 8192;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private Set<Long> unique;

    TreeObject(HprofHeap hprofHeap, LongBuffer longBuffer) {
        this.heap = hprofHeap;
        this.writeBuffer = longBuffer;
    }

    synchronized void computeTrees() {
        try {
            boolean bl;
            this.createBuffers();
            do {
                this.switchBuffers();
            } while (bl = this.computeOneLevel());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
    }

    private boolean computeOneLevel() throws IOException {
        boolean bl = false;
        int n = this.heap.dumpBuffer.getIDSize();
        while (true) {
            List list;
            HprofObject hprofObject;
            long l = this.readLong();
            long l2 = 0L;
            if (l == 0L) break;
            Instance instance = this.heap.getInstanceByID(l);
            if (instance instanceof ObjectArrayInstance) {
                hprofObject = (ObjectArrayDump)instance;
                int n2 = ((ArrayDump)hprofObject).getLength();
                long l3 = ((ObjectArrayDump)hprofObject).getOffset();
                long l4 = 0L;
                LongSet longSet = new LongSet();
                for (int i = 0; i < n2 && l4 != -1L; ++i) {
                    long l5 = this.heap.dumpBuffer.getID(l3 + (long)(i * n));
                    l4 = this.checkInstance(l, l5, longSet);
                    l2 += l4;
                }
                bl |= this.processInstance(instance, l4, l2);
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                assert (false) : "Error - PrimitiveArrayInstance not allowed " + instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
                continue;
            }
            if (instance instanceof ClassDumpInstance) {
                hprofObject = ((ClassDumpInstance)instance).classDump;
                list = ((ClassDump)hprofObject).getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                list = instance.getFieldValues();
            } else {
                if (instance == null) {
                    System.err.println("HeapWalker Warning - null instance for " + l);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            long l6 = 0L;
            LongSet longSet = new LongSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && l6 != -1L) {
                FieldValue fieldValue = (FieldValue)iterator.next();
                if (!(fieldValue instanceof ObjectFieldValue)) continue;
                Instance instance2 = ((ObjectFieldValue)fieldValue).getInstance();
                l6 = this.checkInstance(l, instance2, longSet);
                l2 += l6;
            }
            bl |= this.processInstance(instance, l6, l2);
        }
        return bl;
    }

    private boolean processInstance(Instance instance, long l, long l2) throws IOException {
        if (l != -1L) {
            long l3;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(instance.getInstanceId());
            entry.setRetainedSize((int)(instance.getSize() + l2));
            entry.setTreeObj();
            if (entry.hasOnlyOneReference() && (l3 = entry.getNearestGCRootPointer()) != 0L && this.unique.add(l3)) {
                this.writeLong(l3);
            }
            return true;
        }
        return false;
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192, this.heap.cacheDirectory);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() throws IOException {
        LongBuffer longBuffer = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = longBuffer;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
        this.unique = new HashSet<Long>(4000);
    }

    private void writeLong(long l) throws IOException {
        if (l != 0L) {
            this.writeBuffer.writeLong(l);
        }
    }

    private long checkInstance(long l, Instance instance, LongSet longSet) throws IOException {
        if (instance != null) {
            return this.checkInstance(l, instance.getInstanceId(), longSet);
        }
        return 0L;
    }

    private long checkInstance(long l, long l2, LongSet longSet) throws IOException {
        if (l2 != 0L) {
            LongMap.Entry entry = this.heap.idToOffsetMap.get(l2);
            if (entry == null) {
                return 0L;
            }
            if (!entry.hasOnlyOneReference()) {
                return -1L;
            }
            if (!entry.isTreeObj()) {
                return -1L;
            }
            if (longSet.add(l2)) {
                return 0L;
            }
            return entry.getRetainedSize();
        }
        return 0L;
    }
}

