/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.SamplingThread;
import org.netbeans.lib.profiler.server.ThreadInfo;

public class ProfilerRuntimeCPUSampledInstr
extends ProfilerRuntimeCPU {
    protected static int samplingInterval = 10;
    protected static SamplingThread st;

    public static void setSamplingInterval(int n) {
        samplingInterval = n;
    }

    public static void enableProfiling(boolean bl) {
        if (bl) {
            ProfilerRuntimeCPUSampledInstr.createNewDataStructures();
            ProfilerRuntimeCPU.enableProfiling(bl);
        } else {
            ProfilerRuntimeCPU.enableProfiling(bl);
            ProfilerRuntimeCPUSampledInstr.clearDataStructures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void markerMethodEntry(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!threadInfo.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0 || ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            threadInfo.initialize();
            threadInfo.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++threadInfo.inProfilingRuntimeMethod;
                threadInfo.inCallGraph = true;
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(threadInfo);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++threadInfo.inProfilingRuntimeMethod;
            threadInfo.inCallGraph = true;
        }
        {
            if (threadInfo.stackDepth <= stackDepthLimit) {
                int n = c & 0xFF;
                if (!instrMethodInvoked[n |= c & 0xFF00]) {
                    ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[n] = true;
                    if (threadInfo.rootMethodStackDepth > 0) {
                        ProfilerRuntimeCPUSampledInstr.firstTimeMethodInvoke(threadInfo, c);
                    }
                }
                ProfilerServer.notifyClientOnResultsAvailability();
                ProfilerRuntimeCPUSampledInstr.writeParametersEvent(threadInfo);
                if (threadInfo.stackDepth > 0) {
                    if (!threadInfo.sampleDue) {
                        ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)18, threadInfo, c);
                    } else {
                        ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, threadInfo, c);
                        threadInfo.sampleDue = false;
                    }
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, threadInfo, c);
                }
            }
            ++threadInfo.stackDepth;
            --threadInfo.inProfilingRuntimeMethod;
            return;
        }
    }

    public static void markerMethodExit(char c) {
        ProfilerRuntimeCPUSampledInstr.markerMethodExit(NO_RET_VALUE, c);
    }

    public static void markerMethodExit(Object object, char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            --threadInfo.stackDepth;
            if (threadInfo.stackDepth < 1) {
                threadInfo.inCallGraph = false;
                ProfilerRuntimeCPUSampledInstr.writeRetValue(object, threadInfo);
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, threadInfo, c);
            } else if (threadInfo.stackDepth <= stackDepthLimit) {
                if (!threadInfo.sampleDue) {
                    ProfilerRuntimeCPUSampledInstr.writeRetValue(object, threadInfo);
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)19, threadInfo, c);
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeRetValue(object, threadInfo);
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, threadInfo, c);
                    threadInfo.sampleDue = false;
                }
            }
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    public static void methodEntry(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph && threadInfo.rootMethodStackDepth > 0) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            if (threadInfo.stackDepth <= stackDepthLimit) {
                int n = c & 0xFF;
                if (!instrMethodInvoked[n |= c & 0xFF00]) {
                    ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[n] = true;
                    ProfilerRuntimeCPUSampledInstr.firstTimeMethodInvoke(threadInfo, c);
                }
                if (!threadInfo.sampleDue) {
                    if (c <= '\u3fff') {
                        ProfilerRuntimeCPUSampledInstr.writeCompactEvent(threadInfo, (char)(0x8000 | c));
                    } else {
                        ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)16, threadInfo, c);
                    }
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)6, threadInfo, c);
                    threadInfo.sampleDue = false;
                }
            }
            ++threadInfo.stackDepth;
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    public static void methodExit(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph && threadInfo.rootMethodStackDepth > 0) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            if (threadInfo.rootMethodStackDepth == threadInfo.stackDepth) {
                threadInfo.rootMethodStackDepth = 0;
            }
            --threadInfo.stackDepth;
            if (threadInfo.stackDepth < 1) {
                threadInfo.inCallGraph = false;
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)2, threadInfo, c);
            } else if (threadInfo.rootMethodStackDepth == 0) {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)2, threadInfo, c);
            } else if (threadInfo.stackDepth <= stackDepthLimit) {
                if (!threadInfo.sampleDue) {
                    if ((c = (char)c) <= '\u3fff') {
                        ProfilerRuntimeCPUSampledInstr.writeCompactEvent(threadInfo, (char)(0xC000 | c));
                    } else {
                        ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)17, threadInfo, c);
                    }
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)7, threadInfo, c);
                    threadInfo.sampleDue = false;
                }
            }
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rootMethodEntry(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ProfilerServer.notifyClientOnResultsAvailability();
        if (threadInfo.isInitialized() && !threadInfo.inCallGraph && threadInfo.stackDepth > 0) {
            threadInfo.inCallGraph = true;
            ProfilerRuntimeCPUSampledInstr.methodEntry(c);
            threadInfo.inCallGraph = false;
            return;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph && threadInfo.rootMethodStackDepth > 0) {
            ProfilerRuntimeCPUSampledInstr.methodEntry(c);
            return;
        }
        if (!threadInfo.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0) return;
            if (ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            threadInfo.initialize();
            threadInfo.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++threadInfo.inProfilingRuntimeMethod;
                if (!ProfilerServer.startProfilingPointsActive()) {
                    threadInfo.inCallGraph = true;
                }
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(threadInfo);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++threadInfo.inProfilingRuntimeMethod;
            if (threadInfo.stackDepth == 0 && !ProfilerServer.startProfilingPointsActive()) {
                threadInfo.inCallGraph = true;
            }
        }
        {
            int n = c & 0xFF;
            if (!instrMethodInvoked[n |= c & 0xFF00]) {
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[n] = true;
                if (enableFirstTimeMethodInvoke) {
                    externalActionsHandler.handleFirstTimeMethodInvoke(c);
                }
            }
            ++threadInfo.stackDepth;
            ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)1, threadInfo, c);
            threadInfo.rootMethodStackDepth = threadInfo.stackDepth;
            --threadInfo.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeCPU.clearDataStructures();
        if (st != null) {
            st.terminate();
        }
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeCPU.createNewDataStructures();
        st = new TimeSampler(samplingInterval);
        st.start();
    }

    static void writeCompactEvent(ThreadInfo threadInfo, char c) {
        threadInfo.evBuf[threadInfo.evBufPos++] = (byte)(c >> 8 & 0xFF);
        threadInfo.evBuf[threadInfo.evBufPos++] = (byte)(c & 0xFF);
        if (threadInfo.evBufPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(threadInfo);
        }
    }

    static void writeUnstampedEvent(byte by, ThreadInfo threadInfo, char c) {
        byte[] byArray = threadInfo.evBuf;
        int n = threadInfo.evBufPos;
        byArray[n++] = by;
        byArray[n++] = (byte)(c >> 8 & 0xFF);
        byArray[n++] = (byte)(c & 0xFF);
        threadInfo.evBufPos = n;
        if (n > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(threadInfo);
        }
    }

    static class TimeSampler
    extends SamplingThread {
        TimeSampler(int n) {
            super(n);
            this.setName("*** Profiler Agent Special Execution Thread 9");
        }

        void sample() {
            ThreadInfo.setSampleDueForAllThreads();
        }
    }
}

