/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.export.Exporter;

final class HTMLExporter
extends Exporter {
    private float step = 1.0f;
    private int lastStep = 0;

    HTMLExporter() {
    }

    @Override
    protected int getSteps(TableModel tableModel) {
        int n = tableModel.getRowCount();
        if (n > 300) {
            this.step = 300.0f / (float)n;
            n = 300;
        }
        return n;
    }

    @Override
    protected void writeHeader(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        HTMLExporter.writeLine(writer, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        HTMLExporter.writeLine(writer);
        HTMLExporter.writeLine(writer, "<html>");
        HTMLExporter.writeLine(writer, "<head>");
        HTMLExporter.writeLine(writer, "  <title>");
        HTMLExporter.writeLine(writer, "    " + string);
        HTMLExporter.writeLine(writer, "  </title>");
        HTMLExporter.writeLine(writer, "</head>");
        HTMLExporter.writeLine(writer);
        HTMLExporter.writeLine(writer, "<body>");
    }

    @Override
    protected void writeData(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        int n;
        int n2 = tableModel.getColumnCount();
        int n3 = tableModel.getRowCount();
        HTMLExporter.writeLine(writer, "  <table border=\"1\" summary=\"" + string + "\">");
        HTMLExporter.writeLine(writer, "    <thead>");
        HTMLExporter.writeLine(writer, "      <tr>");
        for (n = 0; n < n2; ++n) {
            HTMLExporter.writeLine(writer, "        <td>" + tableModel.getColumnName(n) + "</td>");
        }
        HTMLExporter.writeLine(writer, "      </tr>");
        HTMLExporter.writeLine(writer, "    </thead>");
        HTMLExporter.writeLine(writer, "    <tbody>");
        for (n = 0; n < n3; ++n) {
            int n4;
            HTMLExporter.writeLine(writer, "      <tr>");
            for (n4 = 0; n4 < n2; ++n4) {
                HTMLExporter.writeLine(writer, "        <td>" + tableModel.getValueAt(n, n4) + "</td>");
            }
            HTMLExporter.writeLine(writer, "      </tr>");
            if (tracerProgressObject.isFinished()) break;
            if (this.step == 1.0f) {
                tracerProgressObject.addStep();
                continue;
            }
            n4 = (int)((float)n * this.step);
            if (n4 <= this.lastStep) continue;
            tracerProgressObject.addStep();
            this.lastStep = n4;
        }
        HTMLExporter.writeLine(writer, "    </tbody>");
        HTMLExporter.writeLine(writer, "  </table>");
    }

    @Override
    protected void writeFooter(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        HTMLExporter.writeLine(writer, "</body>");
        HTMLExporter.writeLine(writer, "</html>");
    }
}

