/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.common.IngestCommonPlugin;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class GrokProcessorGetAction
extends ActionType<Response> {
    static final GrokProcessorGetAction INSTANCE = new GrokProcessorGetAction();
    static final String NAME = "cluster:admin/ingest/processor/grok/get";

    private GrokProcessorGetAction() {
        super(NAME, Response::new);
    }

    public static class RestAction
    extends BaseRestHandler {
        public List<RestHandler.Route> routes() {
            return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_ingest/processor/grok"));
        }

        public String getName() {
            return "ingest_processor_grok_get";
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
            return channel -> client.executeLocally((ActionType)INSTANCE, (ActionRequest)new Request(), (ActionListener)new RestToXContentListener(channel));
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters) {
            super(GrokProcessorGetAction.NAME, transportService, actionFilters, Request::new);
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            try {
                listener.onResponse((Object)new Response(IngestCommonPlugin.GROK_PATTERNS));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Map<String, String> grokPatterns;

        Response(Map<String, String> grokPatterns) {
            this.grokPatterns = grokPatterns;
        }

        Response(StreamInput in) throws IOException {
            super(in);
            this.grokPatterns = in.readMap(StreamInput::readString, StreamInput::readString);
        }

        public Map<String, String> getGrokPatterns() {
            return this.grokPatterns;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("patterns");
            builder.map(this.grokPatterns);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.grokPatterns, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public static class Request
    extends ActionRequest {
        Request() {
        }

        Request(StreamInput in) throws IOException {
            super(in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

