
#ifndef KPARTS_EXPORT_H
#define KPARTS_EXPORT_H

#ifdef KPARTS_STATIC_DEFINE
#  define KPARTS_EXPORT
#  define KPARTS_NO_EXPORT
#else
#  ifndef KPARTS_EXPORT
#    ifdef KF5Parts_EXPORTS
        /* We are building this library */
#      define KPARTS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KPARTS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KPARTS_NO_EXPORT
#    define KPARTS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KPARTS_DECL_DEPRECATED
#  define KPARTS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KPARTS_DECL_DEPRECATED_EXPORT
#  define KPARTS_DECL_DEPRECATED_EXPORT KPARTS_EXPORT KPARTS_DECL_DEPRECATED
#endif

#ifndef KPARTS_DECL_DEPRECATED_NO_EXPORT
#  define KPARTS_DECL_DEPRECATED_NO_EXPORT KPARTS_NO_EXPORT KPARTS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KPARTS_NO_DEPRECATED
#    define KPARTS_NO_DEPRECATED
#  endif
#endif

#define KPARTS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KPARTS_NO_DEPRECATED) && !defined(KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KPARTS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KPARTS_NO_DEPRECATED_WARNINGS) && !defined(KPARTS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KPARTS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KPARTS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KPARTS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KPARTS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KPARTS_NO_DEPRECATED)
#  undef KPARTS_DEPRECATED
#  define KPARTS_DEPRECATED_EXPORT KPARTS_EXPORT
#  define KPARTS_DEPRECATED_NO_EXPORT KPARTS_NO_EXPORT
#elif defined(KPARTS_NO_DEPRECATED_WARNINGS)
#  define KPARTS_DEPRECATED
#  define KPARTS_DEPRECATED_EXPORT KPARTS_EXPORT
#  define KPARTS_DEPRECATED_NO_EXPORT KPARTS_NO_EXPORT
#else
#  define KPARTS_DEPRECATED KPARTS_DECL_DEPRECATED
#  define KPARTS_DEPRECATED_EXPORT KPARTS_DECL_DEPRECATED_EXPORT
#  define KPARTS_DEPRECATED_NO_EXPORT KPARTS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KPARTS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KPARTS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KPARTS_NO_DEPRECATED
#  define KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54800
#endif
#ifdef KPARTS_NO_DEPRECATED_WARNINGS
#  define KPARTS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KPARTS_DEPRECATED_WARNINGS_SINCE
#  ifdef KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KPARTS_DEPRECATED_WARNINGS_SINCE KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KPARTS_DEPRECATED_WARNINGS_SINCE 0x54800
#  endif
#endif

#ifndef KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KPARTS_DEPRECATED
#  define KPARTS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KPARTS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KPARTS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KPARTS_DEPRECATED_WARNINGS_SINCE >= 0x30000
#  define KPARTS_DEPRECATED_VERSION_3_0(text) KPARTS_DECL_DEPRECATED_TEXT(text)
#else
#  define KPARTS_DEPRECATED_VERSION_3_0(text)
#endif

#if KPARTS_DEPRECATED_WARNINGS_SINCE >= 0x40400
#  define KPARTS_DEPRECATED_VERSION_4_4(text) KPARTS_DECL_DEPRECATED_TEXT(text)
#else
#  define KPARTS_DEPRECATED_VERSION_4_4(text)
#endif

#if KPARTS_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KPARTS_DEPRECATED_VERSION_5_0(text) KPARTS_DECL_DEPRECATED_TEXT(text)
#else
#  define KPARTS_DEPRECATED_VERSION_5_0(text)
#endif

#if KPARTS_DEPRECATED_WARNINGS_SINCE >= 0x54800
#  define KPARTS_DEPRECATED_VERSION_5_72(text) KPARTS_DECL_DEPRECATED_TEXT(text)
#else
#  define KPARTS_DEPRECATED_VERSION_5_72(text)
#endif
#define KPARTS_DEPRECATED_VERSION_3(minor, text)      KPARTS_DEPRECATED_VERSION_3_##minor(text)
#define KPARTS_DEPRECATED_VERSION_4(minor, text)      KPARTS_DEPRECATED_VERSION_4_##minor(text)
#define KPARTS_DEPRECATED_VERSION_5(minor, text)      KPARTS_DEPRECATED_VERSION_5_##minor(text)
#define KPARTS_DEPRECATED_VERSION(major, minor, text) KPARTS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KPARTS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KPARTS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* KPARTS_EXPORT_H */
