/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.ClassNode;
import com.sun.tools.visualvm.heapviewer.java.ClassNodeRenderer;
import com.sun.tools.visualvm.heapviewer.java.ClassesContainer;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaClassesProvider;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.TextNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerRenderer;
import com.sun.tools.visualvm.heapviewer.ui.UIThresholds;
import com.sun.tools.visualvm.heapviewer.utils.NodesComputer;
import com.sun.tools.visualvm.heapviewer.utils.ProgressIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.icons.Icons;

class JavaDiffClassesProvider {
    JavaDiffClassesProvider() {
    }

    static HeapViewerNode[] getDiffHeapClasses(HeapViewerNode parent, Heap heap1, final List<ClassNode> diffClasses, boolean retained, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
        HeapViewerNode[] heapViewerNodeArray;
        NodesComputer<ClassNode> computer = new NodesComputer<ClassNode>(diffClasses.size(), UIThresholds.MAX_TOPLEVEL_CLASSES){

            @Override
            protected boolean sorts(DataType dataType) {
                return true;
            }

            @Override
            protected HeapViewerNode createNode(ClassNode javaClass) {
                return javaClass;
            }

            @Override
            protected ProgressIterator<ClassNode> objectsIterator(int index, Progress progress) {
                ListIterator iterator = diffClasses.listIterator(index);
                return new ProgressIterator<ClassNode>(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return JavaClassesProvider.Classes_Messages.getMoreNodesString(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return JavaClassesProvider.Classes_Messages.getSamplesContainerString(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return JavaClassesProvider.Classes_Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
            }
        };
        HeapViewerNode[] nodes = computer.computeNodes(parent, heap1, viewID, viewFilter, dataTypes, sortOrders, progress);
        if (nodes.length == 0) {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(JavaClassesProvider.Classes_Messages.getNoClassesString(viewFilter));
        } else {
            heapViewerNodeArray = nodes;
        }
        return heapViewerNodeArray;
    }

    static HeapViewerNode[] getDiffHeapPackages(HeapViewerNode parent, Heap heap1, List<ClassNode> diffClasses, boolean retained, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
        HeapViewerNode[] heapViewerNodeArray;
        ArrayList<HeapViewerNode> nodes = new ArrayList<HeapViewerNode>();
        HashMap<String, DiffPackageNode> packages = new HashMap<String, DiffPackageNode>();
        for (ClassNode cls : diffClasses) {
            String className = cls.getName();
            int nameIdx = className.lastIndexOf(46);
            if (nameIdx == -1) {
                if (viewFilter != null && !viewFilter.passes(cls, heap1)) continue;
                nodes.add(cls);
                continue;
            }
            if (viewFilter != null && !viewFilter.passes(cls, heap1)) continue;
            String pkgName = className.substring(0, nameIdx);
            DiffPackageNode node = (DiffPackageNode)((Object)packages.get(pkgName));
            if (node == null) {
                node = new DiffPackageNode(pkgName, retained);
                nodes.add(node);
                packages.put(pkgName, node);
            }
            node.add(cls, heap1);
        }
        if (nodes.isEmpty()) {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(JavaClassesProvider.Classes_Messages.getNoPackagesString(viewFilter));
        } else {
            heapViewerNodeArray = nodes.toArray(HeapViewerNode.NO_NODES);
        }
        return heapViewerNodeArray;
    }

    static List<ClassNode> createDiffClasses(Heap h1, Heap h2, boolean retained) {
        if (retained) {
            if (!DataType.RETAINED_SIZE.valuesAvailable(h1)) {
                DataType.RETAINED_SIZE.computeValuesImmediately(h1);
            }
            if (!DataType.RETAINED_SIZE.valuesAvailable(h2)) {
                DataType.RETAINED_SIZE.computeValuesImmediately(h2);
            }
        }
        HashMap<JavaClassID, DiffClassNode> classes = new HashMap<JavaClassID, DiffClassNode>();
        List classes1 = h1.getAllClasses();
        for (JavaClass jc1 : classes1) {
            JavaClassID id1 = JavaClassID.create(jc1);
            DiffClassNode djc1 = (DiffClassNode)((Object)classes.get(id1));
            if (djc1 == null) {
                djc1 = DiffClassNode.own(jc1, retained);
                classes.put(id1, djc1);
                continue;
            }
            djc1.mergeOwn(jc1);
        }
        List classes2 = h2.getAllClasses();
        for (JavaClass jc2 : classes2) {
            JavaClassID id2 = JavaClassID.create(jc2);
            DiffClassNode djc2 = (DiffClassNode)((Object)classes.get(id2));
            if (djc2 == null) {
                djc2 = DiffClassNode.external(new ExternalJavaClass(jc2, retained), retained);
                classes.put(id2, djc2);
                continue;
            }
            djc2.mergeExternal(jc2);
        }
        return new ArrayList<ClassNode>(classes.values());
    }

    private static class ExternalJavaClass
    implements JavaClass {
        private final long allInstancesSize;
        private final boolean isArray;
        private final int instanceSize;
        private final int instancesCount;
        private final long retainedSizeByClass;
        private final long javaClassId;
        private final String name;

        ExternalJavaClass(JavaClass javaClass, boolean retained) {
            this.allInstancesSize = javaClass.getAllInstancesSize();
            this.isArray = javaClass.isArray();
            this.instanceSize = javaClass.getInstanceSize();
            this.instancesCount = javaClass.getInstancesCount();
            this.retainedSizeByClass = retained ? javaClass.getRetainedSizeByClass() : DataType.RETAINED_SIZE.getNotAvailableValue().longValue();
            this.javaClassId = javaClass.getJavaClassId();
            this.name = javaClass.getName();
        }

        public Object getValueOfStaticField(String string) {
            return null;
        }

        public long getAllInstancesSize() {
            return this.allInstancesSize;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public Instance getClassLoader() {
            return null;
        }

        public List getFields() {
            return null;
        }

        public int getInstanceSize() {
            return this.instanceSize;
        }

        public List getInstances() {
            return null;
        }

        public Iterator getInstancesIterator() {
            return null;
        }

        public int getInstancesCount() {
            return this.instancesCount;
        }

        public long getRetainedSizeByClass() {
            return this.retainedSizeByClass;
        }

        public long getJavaClassId() {
            return this.javaClassId;
        }

        public String getName() {
            return this.name;
        }

        public List getStaticFieldValues() {
            return null;
        }

        public Collection getSubClasses() {
            return null;
        }

        public JavaClass getSuperClass() {
            return null;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JavaClass)) {
                return false;
            }
            return this.getName().equals(((JavaClass)o).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }

    public static class DiffClassNodeRendererProvider
    extends HeapViewerRenderer.Provider {
        @Override
        public boolean supportsView(HeapContext context, String viewID) {
            return viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context);
        }

        @Override
        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            Heap heap = context.getFragment().getHeap();
            DiffClassNodeRenderer dcnRenderer = new DiffClassNodeRenderer(heap);
            renderers.put(DiffClassNode.class, dcnRenderer);
        }
    }

    private static class DiffClassNodeRenderer
    implements HeapViewerRenderer {
        private final Heap heap;
        private ClassNodeRenderer currentRenderer;
        private ClassNodeRenderer ownRenderer;
        private ClassNodeRenderer externalRenderer;

        public DiffClassNodeRenderer(Heap heap) {
            this.heap = heap;
        }

        @Override
        public Icon getIcon() {
            return this.currentRenderer.getIcon();
        }

        @Override
        public String getShortName() {
            return this.currentRenderer.getShortName();
        }

        public void setValue(Object o, int i) {
            if (o == null) {
                return;
            }
            DiffClassNode cdn = (DiffClassNode)((Object)o);
            this.currentRenderer = cdn.isOwnClass() ? this.ownRenderer() : this.externalRenderer();
            this.currentRenderer.setValue(o, i);
        }

        public int getHorizontalAlignment() {
            return this.currentRenderer.getHorizontalAlignment();
        }

        public JComponent getComponent() {
            return this.currentRenderer.getComponent();
        }

        public void move(int i, int i1) {
            this.currentRenderer.move(i, i1);
        }

        public AccessibleContext getAccessibleContext() {
            return this.currentRenderer.getAccessibleContext();
        }

        private ClassNodeRenderer ownRenderer() {
            if (this.ownRenderer == null) {
                this.ownRenderer = new ClassNodeRenderer(this.heap);
            }
            return this.ownRenderer;
        }

        private ClassNodeRenderer externalRenderer() {
            if (this.externalRenderer == null) {
                Icon dis = UIManager.getLookAndFeel().getDisabledIcon(new JLabel(), Icons.getIcon((String)"LanguageIcons.Class"));
                this.externalRenderer = new ClassNodeRenderer(dis, this.heap);
            }
            return this.externalRenderer;
        }
    }

    private static class DiffPackageNode
    extends ClassesContainer.Nodes {
        private final boolean trackRetained;

        DiffPackageNode(String name, boolean trackRetained) {
            super(name);
            this.trackRetained = trackRetained;
            this.count = 0;
            this.ownSize = 0L;
            if (trackRetained) {
                this.retainedSize = 0L;
            }
        }

        @Override
        public void add(ClassNode item, Heap heap) {
            this.items.add(item);
            this.count += this.getCount(item, heap);
            this.ownSize += this.getOwnSize(item, heap);
            if (this.trackRetained) {
                this.retainedSize += this.getRetainedSize(item, heap);
            }
        }
    }

    private static class DiffClassNode
    extends ClassNode {
        private final boolean trackRetained;
        private final boolean ownClass;
        private int instancesCount;
        private long ownSize;
        private long retainedSize;

        static DiffClassNode own(JavaClass ownClass, boolean trackRetained) {
            DiffClassNode dClass = new DiffClassNode(ownClass, true, trackRetained);
            dClass.mergeOwn(ownClass);
            return dClass;
        }

        static DiffClassNode external(JavaClass externalClass, boolean trackRetained) {
            DiffClassNode dClass = new DiffClassNode(externalClass, false, trackRetained);
            dClass.mergeExternal(externalClass);
            return dClass;
        }

        private DiffClassNode(JavaClass jClass, boolean ownClass, boolean trackRetained) {
            super(jClass);
            this.trackRetained = trackRetained;
            this.ownClass = ownClass;
            this.setChildren(NO_NODES);
        }

        boolean isOwnClass() {
            return this.ownClass;
        }

        void mergeOwn(JavaClass ownClass) {
            this.instancesCount += ownClass.getInstancesCount();
            this.ownSize += ownClass.getAllInstancesSize();
            if (this.trackRetained) {
                this.retainedSize += ownClass.getRetainedSizeByClass();
            }
        }

        void mergeExternal(JavaClass externalClass) {
            this.instancesCount -= externalClass.getInstancesCount();
            this.ownSize -= externalClass.getAllInstancesSize();
            if (this.trackRetained) {
                this.retainedSize -= externalClass.getRetainedSizeByClass();
            }
        }

        @Override
        public JavaClass getJavaClass() {
            return this.isOwnClass() ? super.getJavaClass() : null;
        }

        @Override
        public int getInstancesCount() {
            return this.instancesCount;
        }

        @Override
        public long getOwnSize() {
            return this.ownSize;
        }

        @Override
        public long getRetainedSize(Heap heap) {
            return this.trackRetained ? this.retainedSize : DataType.RETAINED_SIZE.getNotAvailableValue();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public ClassNode createCopy() {
            return this.ownClass ? super.createCopy() : null;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassNode)) {
                return false;
            }
            return this.getName().equals(((ClassNode)((Object)o)).getName());
        }

        @Override
        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.NAME) {
                return this.getName();
            }
            if (type == DataType.COUNT) {
                return this.getInstancesCount();
            }
            if (type == DataType.OWN_SIZE) {
                return this.getOwnSize();
            }
            if (type == DataType.RETAINED_SIZE) {
                return this.getRetainedSize(heap);
            }
            if (type == DataType.CLASS) {
                return this.getJavaClass();
            }
            return type.getNotAvailableValue();
        }
    }

    private static class JavaClassID {
        private final String id;

        static JavaClassID create(JavaClass jc) {
            return new JavaClassID(jc);
        }

        private JavaClassID(JavaClass jc) {
            this.id = jc.getName();
        }

        public boolean equals(Object o) {
            if (!(o instanceof JavaClassID)) {
                return false;
            }
            return this.id.equals(((JavaClassID)o).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

