/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.objectproperty;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.objectproperty.OWLObjectPropertyRangeFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class OWLObjectPropertyRangeFrameSection
extends AbstractOWLFrameSection<OWLObjectProperty, OWLObjectPropertyRangeAxiom, OWLClassExpression> {
    public static final String LABEL = "Ranges (intersection)";
    Set<OWLClassExpression> addedRanges = new HashSet<OWLClassExpression>();

    public OWLObjectPropertyRangeFrameSection(OWLEditorKit owlEditorKit, OWLFrame<? extends OWLObjectProperty> frame) {
        super(owlEditorKit, LABEL, "Range", frame);
    }

    @Override
    protected void clear() {
        this.addedRanges.clear();
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLObjectPropertyRangeAxiom ax : ontology.getObjectPropertyRangeAxioms((OWLObjectPropertyExpression)this.getRootObject())) {
            this.addRow(new OWLObjectPropertyRangeFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLObjectProperty)this.getRootObject(), ax));
            this.addedRanges.add((OWLClassExpression)ax.getRange());
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_OBJECT_PROPERTY_RANGES, () -> {
            if (!this.getOWLModelManager().getReasoner().isConsistent()) {
                return;
            }
            for (OWLClassExpression inferredRange : this.getInferredRanges()) {
                if (!this.addedRanges.contains(inferredRange)) {
                    OWLObjectPropertyRangeAxiom inferredAxiom = this.getOWLDataFactory().getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.getRootObject(), inferredRange);
                    this.addInferredRowIfNontrivial(new OWLObjectPropertyRangeFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLObjectProperty)this.getRootObject(), inferredAxiom));
                }
                this.addedRanges.add(inferredRange);
            }
        });
    }

    private Set<OWLClassExpression> getInferredRanges() {
        return new HashSet<OWLClassExpression>(this.getOWLModelManager().getReasoner().getObjectPropertyRanges((OWLObjectPropertyExpression)this.getRootObject(), true).getFlattened());
    }

    @Override
    protected OWLObjectPropertyRangeAxiom createAxiom(OWLClassExpression object) {
        return this.getOWLDataFactory().getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.getRootObject(), object);
    }

    @Override
    public OWLObjectEditor<OWLClassExpression> getObjectEditor() {
        return this.getOWLEditorKit().getWorkspace().getOWLComponentFactory().getOWLClassDescriptionEditor(null, AxiomType.OBJECT_PROPERTY_RANGE);
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) {
                OWLClassExpression desc = (OWLClassExpression)obj;
                OWLObjectPropertyRangeAxiom ax = this.getOWLDataFactory().getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.getRootObject(), desc);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLObjectPropertyRangeAxiom) {
            return ((OWLObjectPropertyExpression)((OWLObjectPropertyRangeAxiom)axiom).getProperty()).equals(this.getRootObject());
        }
        return false;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLObjectProperty, OWLObjectPropertyRangeAxiom, OWLClassExpression>> getRowComparator() {
        return null;
    }
}

