/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import org.protege.xmlcatalog.EntryVisitor;
import org.protege.xmlcatalog.entry.DelegatePublicEntry;
import org.protege.xmlcatalog.entry.DelegateSystemEntry;
import org.protege.xmlcatalog.entry.DelegateUriEntry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.NextCatalogEntry;
import org.protege.xmlcatalog.entry.PublicEntry;
import org.protege.xmlcatalog.entry.RewriteSystemEntry;
import org.protege.xmlcatalog.entry.RewriteUriEntry;
import org.protege.xmlcatalog.entry.SystemEntry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.protege.xmlcatalog.swing.CatalogTreeNode;
import org.protege.xmlcatalog.swing.EntryTreeNode;

public class CellRenderer
implements TreeCellRenderer {
    private JLabel label = new JLabel();
    private EntryRenderingVisitor visitor = new EntryRenderingVisitor();
    private boolean colorsInitialized = false;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.initColors(tree);
        if (value instanceof CatalogTreeNode) {
            this.label.setText("" + ((CatalogTreeNode)value).getCatalog().getXmlBase());
        } else {
            EntryTreeNode node = (EntryTreeNode)value;
            if (node.getEditor() != null) {
                this.label.setText(node.getEditor().getDescription(node.getEntry()));
            } else {
                node.getEntry().accept(this.visitor);
            }
        }
        if (selected) {
            this.label.setBackground(this.backgroundSelectionColor);
        } else {
            this.label.setBackground(this.backgroundNonSelectionColor);
        }
        return this.label;
    }

    private void initColors(JTree tree) {
        if (!this.colorsInitialized) {
            this.backgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
            this.backgroundNonSelectionColor = UIManager.getColor("Tree.textBackground");
            this.colorsInitialized = true;
        }
    }

    private class EntryRenderingVisitor
    implements EntryVisitor {
        private EntryRenderingVisitor() {
        }

        @Override
        public void visit(GroupEntry entry) {
            CellRenderer.this.label.setText("Group Entry");
        }

        @Override
        public void visit(PublicEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }

        @Override
        public void visit(SystemEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }

        @Override
        public void visit(RewriteSystemEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }

        @Override
        public void visit(DelegatePublicEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }

        @Override
        public void visit(DelegateSystemEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }

        @Override
        public void visit(UriEntry entry) {
            CellRenderer.this.label.setText(entry.getName() + " \u2192 " + entry.getUri());
        }

        @Override
        public void visit(RewriteUriEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }

        @Override
        public void visit(DelegateUriEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }

        @Override
        public void visit(NextCatalogEntry entry) {
            CellRenderer.this.label.setText("Not implemented yet");
        }
    }
}

