/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ingest.common.AbstractStringProcessor;

public final class LowercaseProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "lowercase";

    LowercaseProcessor(String processorTag, String field, boolean ignoreMissing, String targetField) {
        super(processorTag, field, ignoreMissing, targetField);
    }

    public static String apply(String value) {
        return value.toLowerCase(Locale.ROOT);
    }

    @Override
    protected String process(String value) {
        return LowercaseProcessor.apply(value);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(LowercaseProcessor.TYPE);
        }

        protected LowercaseProcessor newProcessor(String tag, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            return new LowercaseProcessor(tag, field, ignoreMissing, targetField);
        }
    }
}

