from nmigen.build import *


__all__ = ["UARTResource", "IrDAResource", "SPIResource"]


def UARTResource(*args, rx, tx, rts=None, cts=None, dtr=None, dsr=None, dcd=None, ri=None,
                 conn=None, attrs=None, role=None):
    if any(line is not None for line in (rts, cts, dtr, dsr, dcd, ri)):
        assert role in ("dce", "dte")
    if role == "dte":
        dce_to_dte = "i"
        dte_to_dce = "o"
    else:
        dce_to_dte = "o"
        dte_to_dce = "i"

    io = []
    io.append(Subsignal("rx", Pins(rx, dir="i", conn=conn, assert_width=1)))
    io.append(Subsignal("tx", Pins(tx, dir="o", conn=conn, assert_width=1)))
    if rts is not None:
        io.append(Subsignal("rts", Pins(rts, dir=dte_to_dce, conn=conn, assert_width=1)))
    if cts is not None:
        io.append(Subsignal("cts", Pins(cts, dir=dce_to_dte, conn=conn, assert_width=1)))
    if dtr is not None:
        io.append(Subsignal("dtr", Pins(dtr, dir=dte_to_dce, conn=conn, assert_width=1)))
    if dsr is not None:
        io.append(Subsignal("dsr", Pins(dsr, dir=dce_to_dte, conn=conn, assert_width=1)))
    if dcd is not None:
        io.append(Subsignal("dcd", Pins(dcd, dir=dce_to_dte, conn=conn, assert_width=1)))
    if ri is not None:
        io.append(Subsignal("ri", Pins(ri, dir=dce_to_dte, conn=conn, assert_width=1)))
    if attrs is not None:
        io.append(attrs)
    return Resource.family(*args, default_name="uart", ios=io)


def IrDAResource(number, *, rx, tx, en=None, sd=None,
                 conn=None, attrs=None):
    # Exactly one of en (active-high enable) or sd (shutdown, active-low enable) should
    # be specified, and it is mapped to a logic level en subsignal.
    assert (en is not None) ^ (sd is not None)

    io = []
    io.append(Subsignal("rx", Pins(rx, dir="i", conn=conn, assert_width=1)))
    io.append(Subsignal("tx", Pins(tx, dir="o", conn=conn, assert_width=1)))
    if en is not None:
        io.append(Subsignal("en", Pins(en, dir="o", conn=conn, assert_width=1)))
    if sd is not None:
        io.append(Subsignal("en", PinsN(sd, dir="o", conn=conn, assert_width=1)))
    if attrs is not None:
        io.append(attrs)
    return Resource("irda", number, *io)


def SPIResource(*args, cs, clk, copi, cipo, int=None, reset=None,
                conn=None, attrs=None, role="controller"):
    assert role in ("controller", "peripheral")

    io = []
    if role == "controller":
        io.append(Subsignal("cs", PinsN(cs, dir="o", conn=conn)))
        io.append(Subsignal("clk", Pins(clk, dir="o", conn=conn, assert_width=1)))
        io.append(Subsignal("copi", Pins(copi, dir="o", conn=conn, assert_width=1)))
        io.append(Subsignal("cipo", Pins(cipo, dir="i", conn=conn, assert_width=1)))
    else:  # peripheral
        io.append(Subsignal("cs", PinsN(cs, dir="i", conn=conn, assert_width=1)))
        io.append(Subsignal("clk", Pins(clk, dir="i", conn=conn, assert_width=1)))
        io.append(Subsignal("copi", Pins(copi, dir="i", conn=conn, assert_width=1)))
        io.append(Subsignal("cipo", Pins(cipo, dir="oe", conn=conn, assert_width=1)))
    if int is not None:
        if role == "controller":
            io.append(Subsignal("int", Pins(int, dir="i", conn=conn)))
        else:
            io.append(Subsignal("int", Pins(int, dir="oe", conn=conn, assert_width=1)))
    if reset is not None:
        if role == "controller":
            io.append(Subsignal("reset", Pins(reset, dir="o", conn=conn)))
        else:
            io.append(Subsignal("reset", Pins(reset, dir="i", conn=conn, assert_width=1)))
    if attrs is not None:
        io.append(attrs)
    return Resource.family(*args, default_name="spi", ios=io)
