/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.actions.mapmode.SelectLassoAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.io.importexport.JpgImporter;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.ShowThumbnailAction;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class GeoImageLayer
extends AbstractModifiableLayer
implements JumpToMarkerActions.JumpToMarkerLayer,
NavigatableComponent.ZoomChangeListener,
ImageData.ImageDataUpdateListener {
    private static List<Action> menuAdditions = new LinkedList<Action>();
    private static volatile List<MapMode> supportedMapModes;
    private final ImageData data;
    GpxLayer gpxLayer;
    GpxLayer gpxFauxLayer;
    private final Icon icon = ImageProvider.get("dialogs/geoimage/photo-marker");
    private final Icon selectedIcon = ImageProvider.get("dialogs/geoimage/photo-marker-selected");
    boolean useThumbs;
    private final ExecutorService thumbsLoaderExecutor = Executors.newSingleThreadExecutor(Utils.newThreadFactory("thumbnail-loader-%d", 1));
    private ThumbsLoader thumbsloader;
    private boolean thumbsLoaderRunning;
    volatile boolean thumbsLoaded;
    private BufferedImage offscreenBuffer;
    private boolean updateOffscreenBuffer = true;
    private MouseAdapter mouseAdapter;
    private MouseMotionAdapter mouseMotionAdapter;
    private MapFrame.MapModeChangeListener mapModeListener;
    private MainLayerManager.ActiveLayerChangeListener activeLayerChangeListener;
    private Point lastSelPos;
    private Point startPoint;
    private boolean cycleModeArmed;

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer) {
        this(data, gpxLayer, null, false);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, String name) {
        this(data, gpxLayer, name, false);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, boolean useThumbs) {
        this(data, gpxLayer, null, useThumbs);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, String name, boolean useThumbs) {
        super(name != null ? name : I18n.tr("Geotagged Images", new Object[0]));
        this.data = new ImageData(data);
        this.gpxLayer = gpxLayer;
        this.useThumbs = useThumbs;
        this.data.addImageDataUpdateListener(this);
    }

    public static void create(Collection<File> files, GpxLayer gpxLayer) {
        MainApplication.worker.execute(new Loader(files, gpxLayer));
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/geoimage", ImageProvider.ImageSizes.LAYER);
    }

    public static void registerMenuAddition(Action addition) {
        menuAdditions.add(addition);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> entries = new ArrayList<Action>();
        entries.add(LayerListDialog.getInstance().createShowHideLayerAction());
        entries.add(LayerListDialog.getInstance().createDeleteLayerAction());
        entries.add(LayerListDialog.getInstance().createMergeLayerAction(this));
        entries.add(new RenameLayerAction(null, this));
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new CorrelateGpxWithImages(this));
        entries.add(new ShowThumbnailAction(this));
        if (!menuAdditions.isEmpty()) {
            entries.add(Layer.SeparatorLayerAction.INSTANCE);
            entries.addAll(menuAdditions);
        }
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new JumpToMarkerActions.JumpToNextMarker(this));
        entries.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new LayerListPopup.InfoAction(this));
        return entries.toArray(new Action[0]);
    }

    private String infoText() {
        int tagged = 0;
        int newdata = 0;
        int n = this.data.getImages().size();
        for (ImageEntry e : this.data.getImages()) {
            if (e.getPos() != null) {
                ++tagged;
            }
            if (!e.hasNewGpsData()) continue;
            ++newdata;
        }
        return "<html>" + I18n.trn("{0} image loaded.", "{0} images loaded.", n, n) + ' ' + I18n.trn("{0} was found to be GPS tagged.", "{0} were found to be GPS tagged.", tagged, tagged) + (newdata > 0 ? "<br>" + I18n.trn("{0} has updated GPS data.", "{0} have updated GPS data.", newdata, newdata) : "") + "</html>";
    }

    @Override
    public Object getInfoComponent() {
        return this.infoText();
    }

    @Override
    public String getToolTipText() {
        return this.infoText();
    }

    @Override
    public boolean isModified() {
        return this.data.isModified();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer from) {
        if (!(from instanceof GeoImageLayer)) {
            throw new IllegalArgumentException("not a GeoImageLayer: " + from);
        }
        GeoImageLayer l = (GeoImageLayer)from;
        this.stopLoadThumbs();
        l.stopLoadThumbs();
        this.data.mergeFrom(l.getImageData());
        this.setName(l.getName());
        this.thumbsLoaded &= l.thumbsLoaded;
    }

    private static Dimension scaledDimension(Image thumb) {
        double d = MainApplication.getMap().mapView.getDist100Pixel();
        double size = 10.0;
        double s = 1000.0 / d;
        double sMin = 22.0;
        double sMax = 120.0;
        if (s < 22.0) {
            s = 22.0;
        }
        if (s > 120.0) {
            s = 120.0;
        }
        double f = s / 120.0;
        if (thumb == null) {
            return null;
        }
        return new Dimension((int)Math.round(f * (double)thumb.getWidth(null)), (int)Math.round(f * (double)thumb.getHeight(null)));
    }

    private void paintImage(ImageEntry e, MapView mv, Rectangle clip, Graphics2D tempG) {
        if (e.getPos() == null) {
            return;
        }
        Point p = mv.getPoint(e.getPos());
        if (e.hasThumbnail()) {
            Rectangle target;
            Dimension d = GeoImageLayer.scaledDimension(e.getThumbnail());
            if (d != null && clip.intersects(target = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height))) {
                tempG.drawImage(e.getThumbnail(), target.x, target.y, target.width, target.height, null);
            }
        } else {
            this.icon.paintIcon(mv, tempG, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
        }
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        Point p;
        int width = mv.getWidth();
        int height = mv.getHeight();
        Rectangle clip = g.getClipBounds();
        if (this.useThumbs) {
            if (!this.thumbsLoaded) {
                this.startLoadThumbs();
            }
            if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != width || this.offscreenBuffer.getHeight() != height) {
                this.offscreenBuffer = new BufferedImage(width, height, 2);
                this.updateOffscreenBuffer = true;
            }
            if (this.updateOffscreenBuffer) {
                Graphics2D tempG = this.offscreenBuffer.createGraphics();
                tempG.setColor(new Color(0, 0, 0, 0));
                Composite saveComp = tempG.getComposite();
                tempG.setComposite(AlphaComposite.Clear);
                tempG.fillRect(0, 0, width, height);
                tempG.setComposite(saveComp);
                for (ImageEntry e : this.data.getImages()) {
                    this.paintImage(e, mv, clip, tempG);
                }
                for (ImageEntry img : this.data.getSelectedImages()) {
                    this.paintImage(img, mv, clip, tempG);
                }
                this.updateOffscreenBuffer = false;
            }
            g.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        } else {
            for (ImageEntry e : this.data.getImages()) {
                if (e.getPos() == null) continue;
                p = mv.getPoint(e.getPos());
                this.icon.paintIcon(mv, g, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
            }
        }
        for (ImageEntry e : this.data.getSelectedImages()) {
            int imgHeight;
            int imgWidth;
            if (e == null || e.getPos() == null) continue;
            p = mv.getPoint(e.getPos());
            if (this.useThumbs && e.hasThumbnail()) {
                Dimension d = GeoImageLayer.scaledDimension(e.getThumbnail());
                if (d != null) {
                    imgWidth = d.width;
                    imgHeight = d.height;
                } else {
                    imgWidth = -1;
                    imgHeight = -1;
                }
            } else {
                imgWidth = this.selectedIcon.getIconWidth();
                imgHeight = this.selectedIcon.getIconHeight();
            }
            if (e.getExifImgDir() != null) {
                double arrowlength = Math.max(25.0, (double)Math.max(imgWidth, imgHeight) * 0.85);
                double arrowwidth = arrowlength / 1.4;
                double dir = e.getExifImgDir();
                double headdir = dir < 90.0 ? dir + 270.0 : dir - 90.0;
                double leftdir = headdir < 90.0 ? headdir + 270.0 : headdir - 90.0;
                double rightdir = headdir > 270.0 ? headdir - 270.0 : headdir + 90.0;
                double ptx = (double)p.x + Math.cos(Utils.toRadians(headdir)) * arrowlength;
                double pty = (double)p.y + Math.sin(Utils.toRadians(headdir)) * arrowlength;
                double ltx = (double)p.x + Math.cos(Utils.toRadians(leftdir)) * arrowwidth / 2.0;
                double lty = (double)p.y + Math.sin(Utils.toRadians(leftdir)) * arrowwidth / 2.0;
                double rtx = (double)p.x + Math.cos(Utils.toRadians(rightdir)) * arrowwidth / 2.0;
                double rty = (double)p.y + Math.sin(Utils.toRadians(rightdir)) * arrowwidth / 2.0;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(new Color(255, 255, 255, 192));
                int[] xar = new int[]{(int)ltx, (int)ptx, (int)rtx, (int)ltx};
                int[] yar = new int[]{(int)lty, (int)pty, (int)rty, (int)lty};
                g.fillPolygon(xar, yar, 4);
                g.setColor(Color.black);
                g.setStroke(new BasicStroke(1.2f));
                g.drawPolyline(xar, yar, 3);
            }
            if (this.useThumbs && e.hasThumbnail()) {
                g.setColor(new Color(128, 0, 0, 122));
                g.fillRect(p.x - imgWidth / 2, p.y - imgHeight / 2, imgWidth, imgHeight);
                continue;
            }
            this.selectedIcon.paintIcon(mv, g, p.x - imgWidth / 2, p.y - imgHeight / 2);
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (ImageEntry e : this.data.getImages()) {
            v.visit(e.getPos());
        }
    }

    public void showCurrentPhoto() {
        if (this.data.getSelectedImage() != null) {
            this.clearOtherCurrentPhotos();
        }
        this.updateBufferAndRepaint();
    }

    private boolean isPhotoIdxUnderMouse(int idx, MouseEvent evt) {
        ImageEntry img = this.data.getImages().get(idx);
        if (img.getPos() != null) {
            Dimension imgDim;
            Point imgCenter = MainApplication.getMap().mapView.getPoint(img.getPos());
            Rectangle imgRect = this.useThumbs && img.hasThumbnail() ? ((imgDim = GeoImageLayer.scaledDimension(img.getThumbnail())) != null ? new Rectangle(imgCenter.x - imgDim.width / 2, imgCenter.y - imgDim.height / 2, imgDim.width, imgDim.height) : null) : new Rectangle(imgCenter.x - this.icon.getIconWidth() / 2, imgCenter.y - this.icon.getIconHeight() / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
            if (imgRect != null && imgRect.contains(evt.getPoint())) {
                return true;
            }
        }
        return false;
    }

    private int getPhotoIdxUnderMouse(MouseEvent evt, boolean cycle) {
        ImageEntry selectedImage = this.data.getSelectedImage();
        int selectedIndex = this.data.getImages().indexOf(selectedImage);
        if (cycle && selectedImage != null) {
            int idx;
            for (idx = selectedIndex + 1; idx < this.data.getImages().size(); ++idx) {
                if (!this.isPhotoIdxUnderMouse(idx, evt)) continue;
                return idx;
            }
            for (idx = 0; idx <= selectedIndex; ++idx) {
                if (!this.isPhotoIdxUnderMouse(idx, evt)) continue;
                return idx;
            }
        } else {
            if (selectedImage != null && this.isPhotoIdxUnderMouse(selectedIndex, evt)) {
                return selectedIndex;
            }
            for (int idx = this.data.getImages().size() - 1; idx >= 0; --idx) {
                if (!this.isPhotoIdxUnderMouse(idx, evt)) continue;
                return idx;
            }
        }
        return -1;
    }

    private int getPhotoIdxUnderMouse(MouseEvent evt) {
        return this.getPhotoIdxUnderMouse(evt, false);
    }

    public ImageEntry getPhotoUnderMouse(MouseEvent evt) {
        int idx = this.getPhotoIdxUnderMouse(evt);
        if (idx >= 0) {
            return this.data.getImages().get(idx);
        }
        return null;
    }

    private void clearOtherCurrentPhotos() {
        for (GeoImageLayer layer : MainApplication.getLayerManager().getLayersOfType(GeoImageLayer.class)) {
            if (layer == this) continue;
            layer.getImageData().clearSelectedImage();
        }
    }

    public static void registerSupportedMapMode(MapMode mapMode) {
        if (supportedMapModes == null) {
            supportedMapModes = new ArrayList<MapMode>();
        }
        supportedMapModes.add(mapMode);
    }

    private static boolean isSupportedMapMode(MapMode mapMode) {
        if (mapMode instanceof SelectAction || mapMode instanceof SelectLassoAction) {
            return true;
        }
        return supportedMapModes != null && supportedMapModes.stream().anyMatch(supmmode -> mapMode == supmmode);
    }

    @Override
    public void hookUpMapView() {
        this.mouseAdapter = new ImageMouseListener();
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                GeoImageLayer.this.lastSelPos = null;
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                GeoImageLayer.this.lastSelPos = null;
            }
        };
        this.mapModeListener = (oldMapMode, newMapMode) -> {
            MapView mapView = MainApplication.getMap().mapView;
            if (newMapMode == null || GeoImageLayer.isSupportedMapMode(newMapMode)) {
                mapView.addMouseListener(this.mouseAdapter);
                mapView.addMouseMotionListener(this.mouseMotionAdapter);
            } else {
                mapView.removeMouseListener(this.mouseAdapter);
                mapView.removeMouseMotionListener(this.mouseMotionAdapter);
            }
        };
        MapFrame.addMapModeChangeListener(this.mapModeListener);
        this.mapModeListener.mapModeChange(null, MainApplication.getMap().mapMode);
        this.activeLayerChangeListener = e -> {
            if (MainApplication.getLayerManager().getActiveLayer() == this) {
                MainApplication.getMap().selectSelectTool(false);
            }
        };
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.activeLayerChangeListener);
        MapFrame map = MainApplication.getMap();
        if (map.getToggleDialog(ImageViewerDialog.class) == null) {
            ImageViewerDialog.createInstance();
            map.addToggleDialog(ImageViewerDialog.getInstance());
        }
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.stopLoadThumbs();
        MapView mapView = MainApplication.getMap().mapView;
        mapView.removeMouseListener(this.mouseAdapter);
        mapView.removeMouseMotionListener(this.mouseMotionAdapter);
        MapView.removeZoomChangeListener(this);
        MapFrame.removeMapModeChangeListener(this.mapModeListener);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.activeLayerChangeListener);
        this.data.removeImageDataUpdateListener(this);
    }

    @Override
    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent event) {
        MapView.addZoomChangeListener(this);
        return new AbstractMapViewPaintable.CompatibilityModeLayerPainter(){

            @Override
            public void detachFromMapView(MapViewPaintable.MapViewEvent event) {
                MapView.removeZoomChangeListener(GeoImageLayer.this);
            }
        };
    }

    @Override
    public void zoomChanged() {
        this.updateBufferAndRepaint();
    }

    public synchronized void startLoadThumbs() {
        if (this.useThumbs && !this.thumbsLoaded && !this.thumbsLoaderRunning) {
            this.stopLoadThumbs();
            this.thumbsloader = new ThumbsLoader(this);
            this.thumbsLoaderExecutor.submit(this.thumbsloader);
            this.thumbsLoaderRunning = true;
        }
    }

    public synchronized void stopLoadThumbs() {
        if (this.thumbsloader != null) {
            this.thumbsloader.stop = true;
        }
        this.thumbsLoaderRunning = false;
    }

    public void thumbsLoaded() {
        this.thumbsLoaded = true;
    }

    public void updateBufferAndRepaint() {
        this.updateOffscreenBuffer = true;
        this.invalidate();
    }

    public List<ImageEntry> getImages() {
        return new ArrayList<ImageEntry>(this.data.getImages());
    }

    public ImageData getImageData() {
        return this.data;
    }

    public GpxLayer getGpxLayer() {
        return this.gpxLayer;
    }

    public synchronized GpxLayer getFauxGpxLayer() {
        if (this.gpxLayer != null) {
            return this.getGpxLayer();
        }
        if (this.gpxFauxLayer == null) {
            GpxData gpxData = new GpxData();
            List<ImageEntry> imageList = this.data.getImages();
            for (ImageEntry image : imageList) {
                WayPoint twaypoint = new WayPoint(image.getPos());
                gpxData.addWaypoint(twaypoint);
            }
            this.gpxFauxLayer = new GpxLayer(gpxData);
        }
        return this.gpxFauxLayer;
    }

    @Override
    public void jumpToNextMarker() {
        this.data.selectNextImage();
    }

    @Override
    public void jumpToPreviousMarker() {
        this.data.selectPreviousImage();
    }

    public boolean isUseThumbs() {
        return this.useThumbs;
    }

    public void setUseThumbs(boolean useThumbs) {
        this.useThumbs = useThumbs;
        if (useThumbs && !this.thumbsLoaded) {
            this.startLoadThumbs();
        } else if (!useThumbs) {
            this.stopLoadThumbs();
        }
        this.invalidate();
    }

    @Override
    public void selectedImageChanged(ImageData data) {
        this.showCurrentPhoto();
    }

    @Override
    public void imageDataUpdated(ImageData data) {
        this.updateBufferAndRepaint();
    }

    @Override
    public String getChangesetSourceTag() {
        return "Geotagged Images";
    }

    @Override
    public Data getData() {
        return this.data;
    }

    static final class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private GeoImageLayer layer;
        private final Collection<File> selection;
        private final Set<String> loadedDirectories = new HashSet<String>();
        private final Set<String> errorMessages;
        private final GpxLayer gpxLayer;

        Loader(Collection<File> selection, GpxLayer gpxLayer) {
            super(I18n.tr("Extracting GPS locations from EXIF", new Object[0]));
            this.selection = selection;
            this.gpxLayer = gpxLayer;
            this.errorMessages = new LinkedHashSet<String>();
        }

        private void rememberError(String message) {
            this.errorMessages.add(message);
        }

        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Starting directory scan", new Object[0]));
            ArrayList<File> files = new ArrayList<File>();
            try {
                this.addRecursiveFiles(files, this.selection);
            }
            catch (IllegalStateException e) {
                Logging.debug(e);
                this.rememberError(e.getMessage());
            }
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
            this.progressMonitor.setTicksCount(files.size());
            ArrayList<ImageEntry> entries = new ArrayList<ImageEntry>(files.size());
            for (File f : files) {
                if (this.canceled) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", f.getName()));
                this.progressMonitor.worked(1);
                ImageEntry e = new ImageEntry(f);
                e.extractExif();
                entries.add(e);
            }
            this.layer = new GeoImageLayer(entries, this.gpxLayer);
            files.clear();
        }

        private void addRecursiveFiles(Collection<File> files, Collection<File> sel) {
            boolean nullFile = false;
            for (File f : sel) {
                if (this.canceled) break;
                if (f == null) {
                    nullFile = true;
                    continue;
                }
                if (f.isDirectory()) {
                    String canonical = null;
                    try {
                        canonical = f.getCanonicalPath();
                    }
                    catch (IOException e) {
                        Logging.error(e);
                        this.rememberError(I18n.tr("Unable to get canonical path for directory {0}\n", f.getAbsolutePath()));
                    }
                    if (canonical == null || this.loadedDirectories.contains(canonical)) continue;
                    this.loadedDirectories.add(canonical);
                    File[] children = f.listFiles(JpgImporter.FILE_FILTER_WITH_FOLDERS);
                    if (children != null) {
                        this.progressMonitor.subTask(I18n.tr("Scanning directory {0}", f.getPath()));
                        this.addRecursiveFiles(files, Arrays.asList(children));
                        continue;
                    }
                    this.rememberError(I18n.tr("Error while getting files from directory {0}\n", f.getPath()));
                    continue;
                }
                files.add(f);
            }
            if (nullFile) {
                throw new IllegalStateException(I18n.tr("One of the selected files was null", new Object[0]));
            }
        }

        private String formatErrorMessages() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (this.errorMessages.size() == 1) {
                sb.append(Utils.escapeReservedCharactersHTML(this.errorMessages.iterator().next()));
            } else {
                sb.append(Utils.joinAsHtmlUnorderedList(this.errorMessages));
            }
            sb.append("</html>");
            return sb.toString();
        }

        @Override
        protected void finish() {
            if (!this.errorMessages.isEmpty()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), this.formatErrorMessages(), I18n.tr("Error", new Object[0]), 0);
            }
            if (this.layer != null) {
                MainApplication.getLayerManager().addLayer(this.layer);
                if (!this.canceled && !this.layer.getImageData().getImages().isEmpty()) {
                    boolean noGeotagFound = true;
                    for (ImageEntry e : this.layer.getImageData().getImages()) {
                        if (e.getPos() == null) continue;
                        noGeotagFound = false;
                    }
                    if (noGeotagFound) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }
    }

    private final class ImageMouseListener
    extends MouseAdapter {
        private ImageMouseListener() {
        }

        private boolean isMapModeOk() {
            MapMode mapMode = MainApplication.getMap().mapMode;
            return mapMode == null || GeoImageLayer.isSupportedMapMode(mapMode);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (GeoImageLayer.this.isVisible() && this.isMapModeOk()) {
                GeoImageLayer.this.cycleModeArmed = true;
                GeoImageLayer.this.invalidate();
                GeoImageLayer.this.startPoint = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.getButton() != 1) {
                return;
            }
            if (!GeoImageLayer.this.isVisible() || !this.isMapModeOk()) {
                return;
            }
            if (!GeoImageLayer.this.cycleModeArmed) {
                return;
            }
            Rectangle hitBoxClick = new Rectangle((int)GeoImageLayer.this.startPoint.getX() - 10, (int)GeoImageLayer.this.startPoint.getY() - 10, 15, 15);
            if (!hitBoxClick.contains(ev.getPoint())) {
                return;
            }
            Point mousePos = ev.getPoint();
            boolean cycle = GeoImageLayer.this.cycleModeArmed && GeoImageLayer.this.lastSelPos != null && GeoImageLayer.this.lastSelPos.equals(mousePos);
            boolean isShift = (ev.getModifiersEx() & 0x40) == 64;
            boolean isCtrl = (ev.getModifiersEx() & 0x80) == 128;
            int idx = GeoImageLayer.this.getPhotoIdxUnderMouse(ev, cycle);
            if (idx >= 0) {
                GeoImageLayer.this.lastSelPos = mousePos;
                GeoImageLayer.this.cycleModeArmed = false;
                ImageEntry img = GeoImageLayer.this.data.getImages().get(idx);
                if (isShift) {
                    if (isCtrl && !GeoImageLayer.this.data.getSelectedImages().isEmpty()) {
                        int idx2 = GeoImageLayer.this.data.getImages().indexOf(GeoImageLayer.this.data.getSelectedImages().get(GeoImageLayer.this.data.getSelectedImages().size() - 1));
                        int startIndex = Math.min(idx, idx2);
                        int endIndex = Math.max(idx, idx2);
                        for (int i = startIndex; i <= endIndex; ++i) {
                            GeoImageLayer.this.data.addImageToSelection(GeoImageLayer.this.data.getImages().get(i));
                        }
                    } else if (GeoImageLayer.this.data.isImageSelected(img)) {
                        GeoImageLayer.this.data.removeImageToSelection(img);
                    } else {
                        GeoImageLayer.this.data.addImageToSelection(img);
                    }
                } else {
                    GeoImageLayer.this.data.setSelectedImage(img);
                }
            }
        }
    }
}

