/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.io.github.alexarchambault.windowsansi;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class NativeImageFeature
implements Feature {
    private static final List<String> JNI_CLASS_NAMES = Arrays.asList("lmcoursier.internal.shaded.org.fusesource.jansi.internal.CLibrary", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.CLibrary$WinSize", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.CLibrary$Termios", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$SMALL_RECT", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$COORD", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$CONSOLE_SCREEN_BUFFER_INFO", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$CHAR_INFO", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$KEY_EVENT_RECORD", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$MOUSE_EVENT_RECORD", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$WINDOW_BUFFER_SIZE_RECORD", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$FOCUS_EVENT_RECORD", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$MENU_EVENT_RECORD", "lmcoursier.internal.shaded.org.fusesource.jansi.internal.Kernel32$INPUT_RECORD");
    private AtomicBoolean resourceRegistered = new AtomicBoolean();

    NativeImageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        if (Platform.includedIn(Platform.WINDOWS.class)) {
            JNI_CLASS_NAMES.stream().map(arg_0 -> ((Feature.BeforeAnalysisAccess)beforeAnalysisAccess).findClassByName(arg_0)).filter(Objects::nonNull).map(clazz -> ReflectionUtil.lookupMethod((Class)clazz, (String)"init", (Class[])new Class[0])).forEach(method -> beforeAnalysisAccess.registerReachabilityHandler(duringAnalysisAccess -> this.registerJNIFields((Method)method), new Object[]{method}));
        }
    }

    private void registerJNIFields(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        JNIRuntimeAccess.register((Field[])clazz.getDeclaredFields());
        if (!this.resourceRegistered.getAndSet(true)) {
            String string = "META-INF/native/windows64/jansi.dll";
            InputStream inputStream = clazz.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new RuntimeException("Could not find resource " + string);
            }
            Resources.registerResource((String)string, (InputStream)inputStream);
        }
    }
}

