/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.ContextualSAXHandler;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IBiblioResolver
extends URLResolver {
    private static final String M2_PER_MODULE_PATTERN = "[revision]/[artifact]-[revision](-[classifier]).[ext]";
    private static final String M2_PATTERN = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
    public static final String DEFAULT_PATTERN = "[module]/[type]s/[artifact]-[revision].[ext]";
    public static final String DEFAULT_ROOT = "https://www.ibiblio.org/maven/";
    public static final String DEFAULT_M2_ROOT = "https://repo1.maven.org/maven2/";
    private String root = null;
    private String pattern = null;
    private boolean usepoms = true;
    private boolean useMavenMetadata = true;

    public IBiblioResolver() {
        this.setChangingMatcher("regexp");
        this.setChangingPattern(".*-SNAPSHOT");
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        if (this.isM2compatible() && this.isUsepoms()) {
            ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
            moduleRevisionId = this.convertM2IdForResourceSearch(moduleRevisionId);
            ResolvedResource resolvedResource = null;
            if (dependencyDescriptor.getDependencyRevisionId().getRevision().endsWith("SNAPSHOT") && (resolvedResource = this.findSnapshotDescriptor(dependencyDescriptor, resolveData, moduleRevisionId)) != null) {
                return resolvedResource;
            }
            resolvedResource = this.findResourceUsingPatterns(moduleRevisionId, this.getIvyPatterns(), DefaultArtifact.newPomArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
            return resolvedResource;
        }
        return null;
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureConfigured(this.getSettings());
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            moduleRevisionId = this.convertM2IdForResourceSearch(moduleRevisionId);
        }
        ResolvedResource resolvedResource = null;
        if (artifact.getId().getRevision().endsWith("SNAPSHOT") && this.isM2compatible() && (resolvedResource = this.findSnapshotArtifact(artifact, date, moduleRevisionId)) != null) {
            return resolvedResource;
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.getArtifactPatterns(), artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    private ResolvedResource findSnapshotArtifact(Artifact artifact, Date date, ModuleRevisionId moduleRevisionId) {
        String string = this.findSnapshotVersion(moduleRevisionId);
        if (string != null) {
            String string2 = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + string);
            return this.findResourceUsingPattern(moduleRevisionId, string2, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
        }
        return null;
    }

    private ResolvedResource findSnapshotDescriptor(DependencyDescriptor dependencyDescriptor, ResolveData resolveData, ModuleRevisionId moduleRevisionId) {
        String string = this.findSnapshotVersion(moduleRevisionId);
        if (string != null) {
            Message.verbose("[" + string + "] " + moduleRevisionId);
            String string2 = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + string);
            return this.findResourceUsingPattern(moduleRevisionId, string2, DefaultArtifact.newPomArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findSnapshotVersion(ModuleRevisionId moduleRevisionId) {
        if (!this.isM2compatible()) {
            return null;
        }
        if (!this.shouldUseMavenMetadata(this.getWholePattern())) return null;
        InputStream inputStream = null;
        try {
            String string = IvyPatternHelper.substitute(this.root + "[organisation]/[module]/[revision]/maven-metadata.xml", moduleRevisionId);
            Resource resource = this.getRepository().getResource(string);
            if (resource.exists()) {
                inputStream = resource.openStream();
                final StringBuffer stringBuffer = new StringBuffer();
                final StringBuffer stringBuffer2 = new StringBuffer();
                XMLHelper.parse(inputStream, null, (DefaultHandler)new ContextualSAXHandler(){

                    @Override
                    public void endElement(String string, String string2, String string3) throws SAXException {
                        if ("metadata/versioning/snapshot/timestamp".equals(this.getContext())) {
                            stringBuffer.append(this.getText());
                        }
                        if ("metadata/versioning/snapshot/buildNumber".equals(this.getContext())) {
                            stringBuffer2.append(this.getText());
                        }
                        super.endElement(string, string2, string3);
                    }
                }, null);
                if (stringBuffer.length() <= 0) return null;
                String string2 = moduleRevisionId.getRevision();
                string2 = string2.substring(0, string2.length() - "SNAPSHOT".length());
                String string3 = string2 = string2 + stringBuffer.toString() + "-" + stringBuffer2.toString();
                return string3;
            }
            if (this.root.startsWith("file:")) {
                String string4 = IvyPatternHelper.substitute(this.root + "[organisation]/[module]/[revision]/maven-metadata-local.xml", moduleRevisionId);
                Resource resource2 = this.getRepository().getResource(string4);
                if (resource2.exists()) {
                    Message.verbose("maven-metadata-local found: " + resource2);
                    inputStream = resource2.openStream();
                    final StringBuffer stringBuffer = new StringBuffer();
                    XMLHelper.parse(inputStream, null, (DefaultHandler)new ContextualSAXHandler(){

                        @Override
                        public void endElement(String string, String string2, String string3) throws SAXException {
                            if ("metadata/versioning/snapshot/localCopy".equals(this.getContext())) {
                                stringBuffer.append(this.getText());
                            }
                            super.endElement(string, string2, string3);
                        }
                    }, null);
                    if (stringBuffer.toString() != "true") return null;
                    String string5 = moduleRevisionId.getRevision();
                    return string5;
                }
                Message.verbose("\tmaven-metadata and maven-metadata-local not available: " + resource);
                return null;
            }
            Message.verbose("\tmaven-metadata not available: " + resource);
            return null;
        }
        catch (IOException iOException) {
            Message.verbose("impossible to access maven metadata file, ignored: " + iOException.getMessage());
            return null;
        }
        catch (SAXException sAXException) {
            Message.verbose("impossible to parse maven metadata file, ignored: " + sAXException.getMessage());
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Message.verbose("impossible to parse maven metadata file, ignored: " + parserConfigurationException.getMessage());
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void setM2compatible(boolean bl) {
        super.setM2compatible(bl);
        if (bl) {
            if (this.root == null) {
                this.root = DEFAULT_M2_ROOT;
            }
            if (this.pattern == null) {
                this.pattern = M2_PATTERN;
            }
            this.updateWholePattern();
        }
    }

    public void ensureConfigured(ResolverSettings resolverSettings) {
        if (resolverSettings != null && (this.root == null || this.pattern == null)) {
            String string;
            if (this.root == null) {
                string = resolverSettings.getVariable("ivy.ibiblio.default.artifact.root");
                if (string != null) {
                    this.root = string;
                } else {
                    resolverSettings.configureRepositories(true);
                    this.root = resolverSettings.getVariable("ivy.ibiblio.default.artifact.root");
                }
            }
            if (this.pattern == null) {
                string = resolverSettings.getVariable("ivy.ibiblio.default.artifact.pattern");
                if (string != null) {
                    this.pattern = string;
                } else {
                    resolverSettings.configureRepositories(false);
                    this.pattern = resolverSettings.getVariable("ivy.ibiblio.default.artifact.pattern");
                }
            }
            this.updateWholePattern();
        }
    }

    @Override
    protected String getModuleDescriptorExtension() {
        return "pom";
    }

    private String getWholePattern() {
        return this.root + this.pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        if (string == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this.pattern = string;
        this.ensureConfigured(this.getSettings());
        this.updateWholePattern();
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String string) {
        if (string == null) {
            throw new NullPointerException("root must not be null");
        }
        this.root = !string.endsWith("/") ? string + "/" : string;
        this.ensureConfigured(this.getSettings());
        this.updateWholePattern();
    }

    private void updateWholePattern() {
        if (this.isM2compatible() && this.isUsepoms()) {
            this.setIvyPatterns(Collections.singletonList(this.getWholePattern()));
        } else {
            this.setIvyPatterns(Collections.EMPTY_LIST);
        }
        this.setArtifactPatterns(Collections.singletonList(this.getWholePattern()));
    }

    public void publish(Artifact artifact, File file) {
        throw new UnsupportedOperationException("publish not supported by IBiblioResolver");
    }

    @Override
    public String[] listTokenValues(String string, Map map) {
        if ("organisation".equals(string)) {
            return new String[0];
        }
        if ("module".equals(string) && !this.isM2compatible()) {
            return new String[0];
        }
        this.ensureConfigured(this.getSettings());
        return super.listTokenValues(string, map);
    }

    @Override
    protected String[] listTokenValues(String string, String string2) {
        if ("organisation".equals(string2)) {
            return new String[0];
        }
        if ("module".equals(string2) && !this.isM2compatible()) {
            return new String[0];
        }
        this.ensureConfigured(this.getSettings());
        if ("revision".equals(string2) && this.shouldUseMavenMetadata(this.getWholePattern())) {
            String string3 = IvyPatternHelper.substituteTokens(M2_PER_MODULE_PATTERN, Collections.singletonMap("ext", "pom"));
            if (string.endsWith(string3)) {
                String string4 = string.substring(0, string.lastIndexOf(string3)) + "maven-metadata.xml";
                List list = this.listRevisionsWithMavenMetadata(this.getRepository(), string4);
                if (list != null) {
                    return list.toArray(new String[list.size()]);
                }
            } else {
                return new String[0];
            }
        }
        return super.listTokenValues(string, string2);
    }

    @Override
    public OrganisationEntry[] listOrganisations() {
        return new OrganisationEntry[0];
    }

    @Override
    public ModuleEntry[] listModules(OrganisationEntry organisationEntry) {
        if (this.isM2compatible()) {
            this.ensureConfigured(this.getSettings());
            return super.listModules(organisationEntry);
        }
        return new ModuleEntry[0];
    }

    @Override
    public RevisionEntry[] listRevisions(ModuleEntry moduleEntry) {
        this.ensureConfigured(this.getSettings());
        return super.listRevisions(moduleEntry);
    }

    @Override
    protected ResolvedResource[] listResources(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        if (this.shouldUseMavenMetadata(string)) {
            List list = this.listRevisionsWithMavenMetadata(repository, moduleRevisionId.getModuleId().getAttributes());
            if (list != null) {
                Message.debug("\tfound revs: " + list);
                ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>();
                for (String string2 : list) {
                    String string3;
                    ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, string2);
                    String string4 = string;
                    if (string2.endsWith("SNAPSHOT") && (string3 = this.findSnapshotVersion(moduleRevisionId2)) != null) {
                        string4 = string.replaceFirst("\\-\\[revision\\]", "-" + string3);
                    }
                    string3 = IvyPatternHelper.substitute(string4, moduleRevisionId2, artifact);
                    try {
                        Resource resource = repository.getResource(string3);
                        if (resource == null || !resource.exists()) continue;
                        arrayList.add(new ResolvedResource(resource, string2));
                    }
                    catch (IOException iOException) {
                        Message.warn("impossible to get resource from name listed by maven-metadata.xml:" + arrayList + ": " + iOException.getMessage());
                    }
                }
                return arrayList.toArray(new ResolvedResource[arrayList.size()]);
            }
            return super.listResources(repository, moduleRevisionId, string, artifact);
        }
        return super.listResources(repository, moduleRevisionId, string, artifact);
    }

    private List listRevisionsWithMavenMetadata(Repository repository, Map map) {
        String string = IvyPatternHelper.substituteTokens(this.root + "[organisation]/[module]/maven-metadata.xml", map);
        return this.listRevisionsWithMavenMetadata(repository, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List listRevisionsWithMavenMetadata(Repository repository, String string) {
        ArrayList arrayList = null;
        InputStream inputStream = null;
        try {
            Resource resource = repository.getResource(string);
            if (resource.exists()) {
                Message.verbose("\tlisting revisions from maven-metadata: " + resource);
                final ArrayList arrayList2 = new ArrayList();
                inputStream = resource.openStream();
                XMLHelper.parse(inputStream, null, (DefaultHandler)new ContextualSAXHandler(){

                    @Override
                    public void endElement(String string, String string2, String string3) throws SAXException {
                        if ("metadata/versioning/versions/version".equals(this.getContext())) {
                            arrayList2.add(this.getText().trim());
                        }
                        super.endElement(string, string2, string3);
                    }
                }, null);
                arrayList = arrayList2;
            } else {
                Message.verbose("\tmaven-metadata not available: " + resource);
            }
        }
        catch (IOException iOException) {
            Message.verbose("impossible to access maven metadata file, ignored: " + iOException.getMessage());
        }
        catch (SAXException sAXException) {
            Message.verbose("impossible to parse maven metadata file, ignored: " + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Message.verbose("impossible to parse maven metadata file, ignored: " + parserConfigurationException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList;
    }

    @Override
    protected void findTokenValues(Collection collection, List list, Map map, String string) {
        List list2;
        if ("revision".equals(string) && this.shouldUseMavenMetadata(this.getWholePattern()) && (list2 = this.listRevisionsWithMavenMetadata(this.getRepository(), map)) != null) {
            collection.addAll(this.filterNames(list2));
            return;
        }
        super.findTokenValues(collection, list, map, string);
    }

    private boolean shouldUseMavenMetadata(String string) {
        return this.isUseMavenMetadata() && this.isM2compatible();
    }

    @Override
    public String getTypeName() {
        return "ibiblio";
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        this.ensureConfigured(resolveData.getSettings());
        return super.getDependency(dependencyDescriptor, resolveData);
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        this.ensureConfigured(this.getSettings());
        return super.download(artifactArray, downloadOptions);
    }

    @Override
    public boolean exists(Artifact artifact) {
        this.ensureConfigured(this.getSettings());
        return super.exists(artifact);
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        this.ensureConfigured(this.getSettings());
        return super.locate(artifact);
    }

    @Override
    public List getArtifactPatterns() {
        this.ensureConfigured(this.getSettings());
        return super.getArtifactPatterns();
    }

    public boolean isUsepoms() {
        return this.usepoms;
    }

    public void setUsepoms(boolean bl) {
        this.usepoms = bl;
        this.updateWholePattern();
    }

    public boolean isUseMavenMetadata() {
        return this.useMavenMetadata;
    }

    public void setUseMavenMetadata(boolean bl) {
        this.useMavenMetadata = bl;
    }

    @Override
    public void dumpSettings() {
        this.ensureConfigured(this.getSettings());
        super.dumpSettings();
        Message.debug("\t\troot: " + this.getRoot());
        Message.debug("\t\tpattern: " + this.getPattern());
        Message.debug("\t\tusepoms: " + this.usepoms);
        Message.debug("\t\tuseMavenMetadata: " + this.useMavenMetadata);
    }
}

