/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files.apple;

import com.swoval.concurrent.ThreadFactory;
import com.swoval.files.apple.ClosedFileEventMonitorException;
import com.swoval.files.apple.FileEvent;
import com.swoval.files.apple.FileEventMonitor;
import com.swoval.files.apple.FileEventMonitors;
import com.swoval.files.apple.Flags;
import com.swoval.functional.Consumer;
import com.swoval.runtime.NativeLoader;
import com.swoval.runtime.ShutdownHooks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class FileEventMonitorImpl
implements FileEventMonitor {
    private long handle = -1L;
    private final Thread loopThread;
    private final ExecutorService callbackExecutor = Executors.newSingleThreadExecutor(new ThreadFactory("com.swoval.files.apple.FileEventsMonitor.callback"));
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final int shutdownHookId;
    private final Runnable closeRunnable = new Runnable(){

        @Override
        public void run() {
            if (FileEventMonitorImpl.this.closed.compareAndSet(false, true)) {
                ShutdownHooks.removeHook(FileEventMonitorImpl.this.shutdownHookId);
                FileEventMonitorImpl.stopLoop(FileEventMonitorImpl.this.handle);
                FileEventMonitorImpl.this.loopThread.interrupt();
                FileEventMonitorImpl.this.callbackExecutor.shutdownNow();
                try {
                    FileEventMonitorImpl.this.loopThread.join(5000L);
                    FileEventMonitorImpl.this.callbackExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                    FileEventMonitorImpl.close(FileEventMonitorImpl.this.handle);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace(System.err);
                }
            }
        }
    };

    FileEventMonitorImpl(Consumer<FileEvent> consumer, Consumer<String> consumer2) throws InterruptedException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final WrappedConsumer<FileEvent> wrappedConsumer = new WrappedConsumer<FileEvent>(consumer);
        final WrappedConsumer<String> wrappedConsumer2 = new WrappedConsumer<String>(consumer2);
        this.loopThread = new Thread("com.swoval.files.apple.FileEventsMonitor.runloop"){

            @Override
            public void run() {
                FileEventMonitorImpl.this.handle = FileEventMonitorImpl.init(wrappedConsumer, wrappedConsumer2);
                countDownLatch.countDown();
                FileEventMonitorImpl.loop(FileEventMonitorImpl.this.handle);
            }
        };
        this.loopThread.start();
        countDownLatch.await(5L, TimeUnit.SECONDS);
        assert (this.handle != -1L);
        this.shutdownHookId = ShutdownHooks.addHook(1, this.closeRunnable);
    }

    private static native void loop(long var0);

    private static native void close(long var0);

    private static native long init(Consumer<FileEvent> var0, Consumer<String> var1);

    private static native int createStream(String var0, double var1, int var3, long var4);

    private static native void stopLoop(long var0);

    private static native void stopStream(long var0, int var2);

    @Override
    public FileEventMonitors.Handle createStream(Path path, long l, TimeUnit timeUnit, Flags.Create create) throws ClosedFileEventMonitorException {
        if (!this.closed.get()) {
            int n = FileEventMonitorImpl.createStream(path.toString(), (double)timeUnit.toNanos(l) / 1.0E9, create.getValue(), this.handle);
            return n == -1 ? FileEventMonitors.Handles.INVALID : new NativeHandle(n);
        }
        throw new ClosedFileEventMonitorException();
    }

    @Override
    public void stopStream(FileEventMonitors.Handle handle) throws ClosedFileEventMonitorException {
        if (!this.closed.get()) {
            assert (handle instanceof NativeHandle);
        } else {
            throw new ClosedFileEventMonitorException();
        }
        FileEventMonitorImpl.stopStream(this.handle, ((NativeHandle)handle).handle);
    }

    @Override
    public void close() {
        this.closeRunnable.run();
    }

    static {
        try {
            NativeLoader.loadPackaged();
        }
        catch (IOException | UnsatisfiedLinkError throwable) {
            System.err.println("Couldn't load native library " + throwable);
            throw new ExceptionInInitializerError(throwable);
        }
    }

    private class WrappedConsumer<T>
    implements Consumer<T> {
        private final Consumer<T> consumer;

        WrappedConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(final T t) {
            if (!FileEventMonitorImpl.this.closed.get()) {
                FileEventMonitorImpl.this.callbackExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!FileEventMonitorImpl.this.closed.get()) {
                                WrappedConsumer.this.consumer.accept(t);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                });
            }
        }
    }

    private class NativeHandle
    implements FileEventMonitors.Handle {
        private final int handle;

        NativeHandle(int n) {
            this.handle = n;
        }

        public String toString() {
            return "NativeHandle(" + this.handle + ")";
        }
    }
}

