/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DataSpaceManagerBlocks;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.rowio.RowInputBinary180;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary180;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int INT_SPACE_PROPS_POS = 20;
    static final int INT_SPACE_LIST_POS = 24;
    static final int FLAGS_POS = 28;
    static final int MIN_INITIAL_FREE_POS = 32;
    public DataSpaceManager spaceManager;
    static final int initIOBufferSize = 4096;
    private static final int diskBlockSize = 4096;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean logEvents = true;
    protected boolean fileModified;
    protected boolean cacheModified;
    protected int dataFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding;
    protected long initialFreePos;
    protected long lostSpaceSize;
    protected long spaceManagerPosition;
    protected long fileStartFreePosition;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is180;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database database, String string) {
        this.initParams(database, string, false);
        this.cache = new Cache(this);
    }

    public DataFileCache(Database database, String string, boolean bl) {
        this.initParams(database, string, true);
        this.cache = new Cache(this);
        try {
            this.dataFile = new RAFileSimple(this.database.logger, this.dataFileName, "rw");
        }
        catch (Throwable throwable) {
            throw Error.error(452, throwable);
        }
        this.initNewFile();
        this.initBuffers();
        this.spaceManager = this.database.logger.getDataFileSpaces() > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this, false);
    }

    protected void initParams(Database database, String string, boolean bl) {
        this.dataFileName = string + ".data";
        this.backupFileName = string + ".backup";
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.dataFileScale = database.logger.getDataFileScale();
        this.cachedRowPadding = 8;
        if (this.dataFileScale > 8) {
            this.cachedRowPadding = this.dataFileScale;
        }
        this.initialFreePos = 32L;
        if (this.initialFreePos < (long)this.dataFileScale) {
            this.initialFreePos = this.dataFileScale;
        }
        this.cacheReadonly = database.isFilesReadOnly();
        this.maxCacheRows = database.logger.getCacheMaxRows();
        this.maxCacheBytes = database.logger.getCacheSize();
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)database.logger.getDataFileFactor();
        if (bl) {
            this.dataFileName = this.dataFileName + ".new";
            this.backupFileName = this.backupFileName + ".new";
            this.maxCacheRows = 1024;
            this.maxCacheBytes = 0x400000L;
        }
    }

    public void open(boolean bl) {
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean bl2 = this.database.logger.propNioDataFile;
            int n = this.database.isFilesInJar() ? 2 : (bl2 ? 1 : 0);
            if (bl || this.database.isFilesInJar()) {
                this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, true, n);
                int n2 = this.getFlags();
                boolean bl3 = this.is180 = !BitMap.isSet(n2, 4);
                if (BitMap.isSet(n2, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.initBuffers();
                this.spaceManager = new DataSpaceManagerSimple(this, true);
                return;
            }
            boolean bl4 = this.fa.isStreamElement(this.dataFileName);
            boolean bl5 = this.database.logger.propIncrementBackup;
            boolean bl6 = false;
            if (bl4) {
                int n3;
                this.dataFile = new RAFileSimple(this.database.logger, this.dataFileName, "r");
                long l = this.dataFile.length();
                boolean bl7 = false;
                if (l >= this.initialFreePos) {
                    n3 = this.getFlags();
                    bl6 = BitMap.isSet(n3, 2);
                    bl5 = BitMap.isSet(n3, 1);
                    boolean bl8 = this.is180 = !BitMap.isSet(n3, 4);
                    if (BitMap.isSet(n3, 5)) {
                        bl7 = true;
                    }
                }
                this.dataFile.close();
                if (bl7) {
                    throw Error.error(453);
                }
                if (!this.database.logger.propLargeData && l > this.maxDataFileSize / 8L * 7L) {
                    this.database.logger.propLargeData = true;
                    this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)this.database.logger.getDataFileFactor();
                }
                if (l > this.maxDataFileSize) {
                    throw Error.error(468, String.valueOf(this.maxDataFileSize));
                }
                if (bl6 && bl5 && (n3 = (int)(this.fa.isStreamElement(this.backupFileName) ? 1 : 0)) != 0) {
                    this.logInfoEvent("data file was not modified but inc backup exists");
                }
            }
            if (bl6) {
                if (bl5) {
                    this.deleteBackup();
                } else {
                    boolean bl9 = this.fa.isStreamElement(this.backupFileName);
                    if (!bl9) {
                        this.backupDataFile(false);
                    }
                }
            } else if (bl5) {
                if (bl4 && !(bl4 = this.restoreBackupIncremental())) {
                    this.database.logger.logSevereEvent("DataFileCache data file modified but no backup exists", null);
                    throw Error.error(454);
                }
            } else {
                bl4 = this.restoreBackup();
            }
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            if (bl4) {
                int n4 = this.getFlags();
                this.is180 = !BitMap.isSet(n4, 4);
                this.dataFile.seek(4L);
                this.lostSpaceSize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.openShadowFile();
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = this.database.logger.getDataFileSpaces() > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this, false);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.open", throwable);
            this.release();
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    boolean setDataSpaceManager() {
        this.writeLock.lock();
        int n = this.database.logger.propFileSpaceValue;
        try {
            if (n > 0 && this.spaceManagerPosition == 0L) {
                this.spaceManager.reset();
                this.spaceManager = new DataSpaceManagerBlocks(this);
                boolean bl = true;
                return bl;
            }
            if (n == 0 && this.spaceManagerPosition != 0L) {
                this.spaceManager.reset();
                this.spaceManager = new DataSpaceManagerSimple(this, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void openStoredFileAccess(boolean bl) {
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean bl2;
            int n = 3;
            if (bl) {
                this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                this.dataFile.seek(28L);
                int n2 = this.dataFile.readInt();
                this.is180 = !BitMap.isSet(n2, 4);
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            boolean bl3 = this.fa.isStreamElement(this.dataFileName);
            boolean bl4 = this.database.logger.propIncrementBackup;
            boolean bl5 = bl2 = this.database.getProperties().getDBModified() == 1;
            if (bl3 && bl2) {
                bl3 = bl4 ? this.restoreBackupIncremental() : this.restoreBackup();
            }
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            if (bl3) {
                this.dataFile.seek(4L);
                this.lostSpaceSize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(28L);
                int n3 = this.dataFile.readInt();
                this.is180 = !BitMap.isSet(n3, 4);
                this.openShadowFile();
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = new DataSpaceManagerSimple(this, false);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("dataFileCache open failed", throwable);
            this.release();
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    void initNewFile() {
        try {
            this.fileFreePosition = this.initialFreePos;
            this.fileStartFreePosition = this.initialFreePos;
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int n = this.dataFileScale;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(n |= this.database.logger.getDataFileSpaces() << 16);
            int n2 = 0;
            if (this.database.logger.propIncrementBackup) {
                n2 = BitMap.set(n2, 1);
            }
            n2 = BitMap.set(n2, 2);
            n2 = BitMap.set(n2, 4);
            this.setFlags(n2);
            this.is180 = false;
        }
        catch (Throwable throwable) {
            throw Error.error(452, throwable);
        }
    }

    private void openShadowFile() {
        if (this.database.logger.propIncrementBackup && this.fileFreePosition != this.initialFreePos) {
            this.shadowFile = new RAShadowFile(this.database.logger, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    void setIncrementBackup(boolean bl) {
        this.writeLock.lock();
        try {
            this.setFlag(1, bl);
            this.fileModified = true;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.setIncrementalBackup", throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean restoreBackup() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            DataFileCache.deleteFile(this.database, this.dataFileName);
            if (fileAccess.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fileAccess, 1);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackup", throwable);
            throw Error.error(throwable, 452, 26, new Object[]{throwable.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                DataFileCache.deleteFile(this.database, this.backupFileName);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackupIncremental", throwable);
            throw Error.error(452, throwable);
        }
    }

    public void release() {
        this.writeLock.lock();
        try {
            if (this.dataFile == null) {
                return;
            }
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file closed");
            this.dataFile = null;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.release", throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void close() {
        this.writeLock.lock();
        try {
            boolean bl;
            if (this.dataFile == null) {
                return;
            }
            this.reset();
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file close end");
            this.dataFile = null;
            boolean bl2 = bl = this.fileFreePosition == this.initialFreePos;
            if (bl) {
                this.deleteFile();
                this.deleteBackup();
            }
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.close", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void adjustStoreCount(int n) {
        this.writeLock.lock();
        try {
            this.storeCount += n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reopen() {
        this.writeLock.lock();
        try {
            this.openShadowFile();
            this.spaceManager.initialiseSpaces();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reset() {
        this.writeLock.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.logInfoEvent("dataFileCache commit start");
            this.spaceManager.reset();
            this.cache.saveAll();
            long l = this.spaceManager.getLostBlocksSize();
            this.dataFile.seek(4L);
            this.dataFile.writeLong(l);
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int n = this.dataFileScale;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(n |= this.database.logger.getDataFileSpaces() << 16);
            int n2 = (int)(this.spaceManagerPosition / 4096L);
            this.dataFile.seek(24L);
            this.dataFile.writeInt(n2);
            this.setFlag(2, true);
            this.logDetailEvent("file sync end");
            this.fileModified = false;
            this.cacheModified = false;
            this.fileStartFreePosition = this.fileFreePosition;
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.logInfoEvent("dataFileCache commit end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.reset commit", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null) {
            this.rowOut = this.is180 ? new RowOutputBinary180(4096, this.cachedRowPadding) : new RowOutputBinaryEncode(this.database.logger.getCrypto(), 4096, this.cachedRowPadding);
        }
        if (this.rowIn == null) {
            this.rowIn = this.is180 ? new RowInputBinary180(new byte[4096]) : new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[4096]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag(Session session) {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dataFileDefrag = new DataFileDefrag(this.database, this);
            dataFileDefrag.process(session);
            this.close();
            this.cache.clear();
            if (!this.database.logger.propIncrementBackup) {
                this.backupNewDataFile(true);
            }
            this.database.schemaManager.setTempIndexRoots(dataFileDefrag.getIndexRoots());
            try {
                this.database.logger.log.writeScript(false);
            }
            finally {
                this.database.schemaManager.setTempIndexRoots(null);
            }
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.database.getProperties().setDBModified(2);
            this.database.logger.log.closeLog();
            this.database.logger.log.deleteLog();
            this.database.logger.log.renameNewScript();
            this.renameBackupFile();
            this.renameDataFile();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            if (this.database.logger.log.dbLogWriter != null) {
                this.database.logger.log.openLog();
            }
            DataFileDefrag dataFileDefrag2 = dataFileDefrag;
            return dataFileDefrag2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remove(CachedObject cachedObject) {
        this.release(cachedObject.getPos());
    }

    public void removePersistence(CachedObject cachedObject) {
    }

    public void add(CachedObject cachedObject, boolean bl) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.put(cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            if (cachedObject.getStorageSize() > 4096) {
                this.rowOut.reset(cachedObject.getStorageSize());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        long l;
        this.readLock.lock();
        try {
            if (cachedObject.isInMemory()) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            l = cachedObject.getPos();
            if (l < 0L) {
                CachedObject cachedObject3 = null;
                return cachedObject3;
            }
            cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject4 = cachedObject;
                return cachedObject4;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l, persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long l, int n, PersistentStore persistentStore, boolean bl) {
        if (l < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l, n, persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long l, PersistentStore persistentStore, boolean bl) {
        if (l < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l, persistentStore, bl);
    }

    private CachedObject getFromFile(long l, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject = null;
        this.writeLock.lock();
        try {
            cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            for (int i = 0; i < 2; ++i) {
                try {
                    this.readObject(l);
                    cachedObject = persistentStore.get(this.rowIn);
                    if (cachedObject == null) {
                        throw Error.error(467, "position " + l);
                    }
                    break;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof OutOfMemoryError) {
                        this.cache.clearUnchanged();
                        if (i <= 0) continue;
                        this.logInfoEvent(this.dataFileName + " getFromFile out of mem " + l);
                        HsqlException hsqlException = Error.error(460, throwable);
                        hsqlException.info = this.rowIn;
                        throw hsqlException;
                    }
                    if (throwable instanceof HsqlException) {
                        ((HsqlException)throwable).info = this.rowIn;
                        throw (HsqlException)throwable;
                    }
                    HsqlException hsqlException = Error.error(467, throwable);
                    hsqlException.info = this.rowIn;
                    throw hsqlException;
                }
            }
            if (cachedObject == null) {
                throw Error.error(466);
            }
            this.cache.put(cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            persistentStore.set(cachedObject);
            CachedObject cachedObject3 = cachedObject;
            return cachedObject3;
        }
        catch (HsqlException hsqlException) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + l, hsqlException);
            throw hsqlException;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private CachedObject getFromFile(long l, int n, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject = null;
        this.writeLock.lock();
        try {
            cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            for (int i = 0; i < 2; ++i) {
                try {
                    this.readObject(l, n);
                    cachedObject = persistentStore.get(this.rowIn);
                    break;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.cache.clearUnchanged();
                    System.gc();
                    if (i <= 0) continue;
                    this.logSevereEvent(this.dataFileName + " getFromFile out of mem " + l, outOfMemoryError);
                    throw outOfMemoryError;
                }
            }
            if (cachedObject == null) {
                throw Error.error(466);
            }
            this.cache.putUsingReserve(cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            persistentStore.set(cachedObject);
            CachedObject cachedObject3 = cachedObject;
            return cachedObject3;
        }
        catch (HsqlException hsqlException) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + l, hsqlException);
            throw hsqlException;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(long l) {
        this.writeLock.lock();
        try {
            this.readObject(l);
            RowInputInterface rowInputInterface = this.rowIn;
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void readObject(long l) {
        try {
            this.dataFile.seek(l * (long)this.dataFileScale);
            int n = this.dataFile.readInt();
            this.rowIn.resetRow(l, n);
            this.dataFile.read(this.rowIn.getBuffer(), 4, n - 4);
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.readObject", throwable, l);
            HsqlException hsqlException = Error.error(466, throwable);
            if (this.rowIn.getFilePosition() != l) {
                this.rowIn.resetRow(l, 0);
            }
            hsqlException.info = this.rowIn;
            throw hsqlException;
        }
    }

    protected void readObject(long l, int n) {
        try {
            this.rowIn.resetBlock(l, n);
            this.dataFile.seek(l * (long)this.dataFileScale);
            this.dataFile.read(this.rowIn.getBuffer(), 0, n);
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.readObject", throwable, l);
            HsqlException hsqlException = Error.error(466, throwable);
            hsqlException.info = this.rowIn;
            throw hsqlException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(long l, long l2) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.releaseRange(l, l2);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void releaseRange(IntIndex intIndex, int n) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.releaseRange(intIndex, n);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(long l) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            CachedObject cachedObject = this.cache.release(l);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.copyShadow(cachedObjectArray, n, n2);
        long l = this.cache.saveAllTimer.elapsedTime();
        long l2 = 0L;
        this.cache.saveAllTimer.start();
        if (n3 > 0) {
            this.setFileModified();
        }
        for (int i = n; i < n + n2; ++i) {
            CachedObject cachedObject = cachedObjectArray[i];
            this.saveRowNoLock(cachedObject);
            cachedObjectArray[i] = null;
            l2 += (long)cachedObject.getStorageSize();
        }
        this.cache.saveAllTimer.stop();
        this.cache.logSaveRowsEvent(n2, l2, l);
    }

    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.copyShadow(cachedObject);
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void saveRowOutput(long l) {
        try {
            this.dataFile.seek(l * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.saveRowOutput", throwable, l);
            throw Error.error(466, throwable);
        }
    }

    protected void saveRowNoLock(CachedObject cachedObject) {
        try {
            this.rowOut.reset();
            cachedObject.write(this.rowOut);
            this.dataFile.seek(cachedObject.getPos() * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            cachedObject.setChanged(false);
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.saveRowNoLock", throwable, cachedObject.getPos());
            throw Error.error(466, throwable);
        }
    }

    protected int copyShadow(CachedObject[] cachedObjectArray, int n, int n2) {
        int n3 = 0;
        if (this.shadowFile != null) {
            long l = this.cache.shadowTimer.elapsedTime();
            long l2 = 0L;
            this.cache.shadowTimer.start();
            try {
                for (int i = n; i < n + n2; ++i) {
                    CachedObject cachedObject = cachedObjectArray[i];
                    l2 = cachedObject.getPos() * (long)this.dataFileScale;
                    n3 += this.shadowFile.copy(l2, cachedObject.getStorageSize());
                }
                if (n3 > 0) {
                    this.shadowFile.synch();
                }
            }
            catch (Throwable throwable) {
                this.logSevereEvent("DataFileCache.copyShadow", throwable, l2);
                throw Error.error(466, throwable);
            }
            this.cache.shadowTimer.stop();
            if (n3 > 0) {
                l = this.cache.shadowTimer.elapsedTime() - l;
                this.logDetailEvent("copyShadow [size, time] " + this.shadowFile.getSavedLength() + " " + l);
            }
        }
        return n3;
    }

    protected int copyShadow(CachedObject cachedObject) {
        if (this.shadowFile != null) {
            long l = cachedObject.getPos() * (long)this.dataFileScale;
            try {
                int n = this.shadowFile.copy(l, cachedObject.getStorageSize());
                this.shadowFile.synch();
                return n;
            }
            catch (Throwable throwable) {
                this.logSevereEvent("DataFileCache.copyShadow", throwable, cachedObject.getPos());
                throw Error.error(466, throwable);
            }
        }
        return 0;
    }

    void backupDataFile(boolean bl) {
        DataFileCache.backupFile(this.database, this.dataFileName, this.backupFileName, bl);
    }

    void backupNewDataFile(boolean bl) {
        DataFileCache.backupFile(this.database, this.dataFileName + ".new", this.backupFileName, bl);
    }

    static void backupFile(Database database, String string, String string2, boolean bl) {
        try {
            FileAccess fileAccess = database.logger.getFileAccess();
            if (database.logger.propIncrementBackup) {
                if (fileAccess.isStreamElement(string2)) {
                    DataFileCache.deleteFile(database, string2);
                    if (fileAccess.isStreamElement(string2)) {
                        throw Error.error(466, "cannot delete old backup file");
                    }
                }
                return;
            }
            if (fileAccess.isStreamElement(string)) {
                if (bl) {
                    string2 = string2 + ".new";
                } else {
                    DataFileCache.deleteFile(database, string2);
                    if (fileAccess.isStreamElement(string2)) {
                        throw Error.error(466, "cannot delete old backup file");
                    }
                }
                FileArchiver.archive(string, string2, fileAccess, 1);
            }
        }
        catch (Throwable throwable) {
            database.logger.logSevereEvent("DataFileCache.backupFile", throwable);
            throw Error.error(466, throwable);
        }
    }

    void renameBackupFile() {
        DataFileCache.renameBackupFile(this.database, this.backupFileName);
    }

    static void renameBackupFile(Database database, String string) {
        FileAccess fileAccess = database.logger.getFileAccess();
        if (database.logger.propIncrementBackup) {
            DataFileCache.deleteFile(database, string);
            return;
        }
        if (fileAccess.isStreamElement(string + ".new")) {
            DataFileCache.deleteFile(database, string);
            fileAccess.renameElement(string + ".new", string, true);
        }
    }

    void renameDataFile() {
        DataFileCache.renameDataFile(this.database, this.dataFileName);
    }

    static void renameDataFile(Database database, String string) {
        FileAccess fileAccess = database.logger.getFileAccess();
        if (fileAccess.isStreamElement(string + ".new")) {
            DataFileCache.deleteFile(database, string);
            fileAccess.renameElement(string + ".new", string, true);
        }
    }

    void deleteFile() {
        DataFileCache.deleteFile(this.database, this.dataFileName);
    }

    static void deleteFile(Database database, String string) {
        FileAccess fileAccess = database.logger.getFileAccess();
        fileAccess.removeElement(string);
        if (fileAccess.isStreamElement(string)) {
            fileAccess.removeElement(string);
            if (fileAccess.isStreamElement(string)) {
                String string2 = FileUtil.newDiscardFileName(string);
                fileAccess.renameElement(string, string2, false);
            }
        }
    }

    void deleteBackup() {
        DataFileCache.deleteFile(this.database, this.backupFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long enlargeFileSpace(long l) {
        this.writeLock.lock();
        try {
            long l2 = this.fileFreePosition;
            if (l2 + l > this.maxDataFileSize) {
                this.logSevereEvent("data file reached maximum allowed size: " + this.dataFileName + " " + this.maxDataFileSize, null);
                throw Error.error(468);
            }
            boolean bl = this.dataFile.ensureLength(l2 + l);
            if (!bl) {
                this.logSevereEvent("data file cannot be enlarged - disk space: " + this.dataFileName + " " + (l2 + l), null);
                throw Error.error(468);
            }
            this.fileFreePosition += l;
            long l3 = l2;
            return l3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public long getLostBlockSize() {
        return this.spaceManager.getLostBlocksSize();
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public int getDataFileScale() {
        return this.dataFileScale;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isModified() {
        return this.cacheModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    protected void setFileModified() {
        try {
            if (!this.fileModified) {
                this.setFlag(2, false);
                this.logDetailEvent("setFileModified flag set ");
                this.fileModified = true;
            }
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.setFileModified", throwable);
            throw Error.error(466, throwable);
        }
    }

    int getFlags() throws IOException {
        this.dataFile.seek(28L);
        int n = this.dataFile.readInt();
        return n;
    }

    void setFlags(int n) throws IOException {
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n);
        this.dataFile.synch();
    }

    void setFlag(int n, boolean bl) throws IOException {
        this.dataFile.seek(28L);
        int n2 = this.dataFile.readInt();
        n2 = bl ? BitMap.set(n2, n) : BitMap.unset(n2, n);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n2);
        this.dataFile.synch();
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }

    public RAShadowFile getShadowFile() {
        return this.shadowFile;
    }

    private void logSevereEvent(String string, Throwable throwable, long l) {
        if (this.logEvents) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(' ').append(l);
            string = stringBuilder.toString();
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    public void logSevereEvent(String string, Throwable throwable) {
        if (this.logEvents) {
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    void logInfoEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logInfoEvent(string);
        }
    }

    void logDetailEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logDetailEvent(string);
        }
    }
}

