/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.DraggableHandle;
import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class Gripper
extends JComponent
implements SwingConstants,
Alignable,
DraggableHandle,
UIResource {
    private static final String uiClassID = "GripperUI";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    private boolean _rolloverEnabled = false;
    private boolean _rollover;
    public static final String ROLLOVER_PROPERTY = "ROLLOVER";
    public static final String SELECTED_PROPERTY = "SELECTED";
    private int _orientation;
    private boolean _selected;

    public Gripper() {
        this(0);
    }

    public Gripper(int n) {
        this.setOrientation(n);
        this.setFocusable(false);
        this.updateUI();
    }

    @Override
    public GripperUI getUI() {
        return (GripperUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public boolean supportVerticalOrientation() {
        return true;
    }

    @Override
    public boolean supportHorizontalOrientation() {
        return true;
    }

    @Override
    public void setOrientation(int n) {
        int n2 = this._orientation;
        if (n2 != n) {
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
        }
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    @Override
    public Cursor getCursor() {
        if (this.isEnabled()) {
            return Cursor.getPredefinedCursor(13);
        }
        return super.getCursor();
    }

    public boolean isRolloverEnabled() {
        return this._rolloverEnabled;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this._rolloverEnabled;
        if (bl != bl2) {
            this._rolloverEnabled = bl;
            this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, bl2, this._rolloverEnabled);
            this.repaint();
        }
    }

    public boolean isRollover() {
        return this._rollover;
    }

    public void setRollover(boolean bl) {
        boolean bl2 = this._rollover;
        if (bl != bl2) {
            this._rollover = bl;
            this.firePropertyChange(ROLLOVER_PROPERTY, bl2, bl);
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this._selected;
        if (bl != bl2) {
            this._selected = bl;
            this.firePropertyChange(SELECTED_PROPERTY, bl2, this._selected);
            this.repaint();
        }
    }
}

