/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.ui;

import cc.arduino.contributions.ui.InstallerJDialog;
import javax.swing.SwingUtilities;
import processing.app.I18n;

public class InstallerJDialogUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final InstallerJDialog parent;
    private final String connectionErrorMessage;

    public InstallerJDialogUncaughtExceptionHandler(InstallerJDialog parent, String connectionErrorMessage) {
        this.parent = parent;
        this.connectionErrorMessage = connectionErrorMessage;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String errorMessage = I18n.tr((String)e.getMessage().substring(e.getMessage().indexOf(":") + 1));
        if (errorMessage.startsWith("Error downloading")) {
            errorMessage = this.connectionErrorMessage;
        }
        String finalErrorMessage = errorMessage;
        SwingUtilities.invokeLater(() -> {
            System.err.println(finalErrorMessage);
            e.printStackTrace();
        });
        this.parent.setErrorMessage(finalErrorMessage);
    }
}

