/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.Interval;
import org.apache.batik.anim.timing.TimeContainer;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.timing.TimegraphListener;
import org.apache.batik.anim.timing.TimingSpecifier;
import org.apache.batik.util.DoublyIndexedSet;

public abstract class TimedDocumentRoot
extends TimeContainer {
    protected Calendar documentBeginTime;
    protected boolean useSVG11AccessKeys;
    protected boolean useSVG12AccessKeys;
    protected DoublyIndexedSet propagationFlags = new DoublyIndexedSet();
    protected LinkedList listeners = new LinkedList();
    protected boolean isSampling;
    protected boolean isHyperlinking;

    public TimedDocumentRoot(boolean bl, boolean bl2) {
        this.root = this;
        this.useSVG11AccessKeys = bl;
        this.useSVG12AccessKeys = bl2;
    }

    @Override
    protected float getImplicitDur() {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public float getDefaultBegin(TimedElement timedElement) {
        return 0.0f;
    }

    public float getCurrentTime() {
        return this.lastSampleTime;
    }

    public boolean isSampling() {
        return this.isSampling;
    }

    public boolean isHyperlinking() {
        return this.isHyperlinking;
    }

    public float seekTo(float f, boolean bl) {
        int n;
        this.isSampling = true;
        this.lastSampleTime = f;
        this.isHyperlinking = bl;
        this.propagationFlags.clear();
        float f2 = Float.POSITIVE_INFINITY;
        TimedElement[] timedElementArray = this.getChildren();
        for (n = 0; n < timedElementArray.length; ++n) {
            float f3 = timedElementArray[n].sampleAt(f, bl);
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        do {
            n = 0;
            for (int i = 0; i < timedElementArray.length; ++i) {
                if (!timedElementArray[i].shouldUpdateCurrentInterval) continue;
                n = 1;
                float f4 = timedElementArray[i].sampleAt(f, bl);
                if (!(f4 < f2)) continue;
                f2 = f4;
            }
        } while (n != 0);
        this.isSampling = false;
        if (bl) {
            this.root.currentIntervalWillUpdate();
        }
        return f2;
    }

    public void resetDocument(Calendar calendar) {
        this.documentBeginTime = calendar == null ? Calendar.getInstance() : calendar;
        this.reset(true);
    }

    public Calendar getDocumentBeginTime() {
        return this.documentBeginTime;
    }

    public float convertEpochTime(long l) {
        long l2 = this.documentBeginTime.getTime().getTime();
        return (float)(l - l2) / 1000.0f;
    }

    public float convertWallclockTime(Calendar calendar) {
        long l = this.documentBeginTime.getTime().getTime();
        long l2 = calendar.getTime().getTime();
        return (float)(l2 - l) / 1000.0f;
    }

    public void addTimegraphListener(TimegraphListener timegraphListener) {
        this.listeners.add(timegraphListener);
    }

    public void removeTimegraphListener(TimegraphListener timegraphListener) {
        this.listeners.remove(timegraphListener);
    }

    void fireElementAdded(TimedElement timedElement) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((TimegraphListener)iterator.next()).elementAdded(timedElement);
        }
    }

    void fireElementRemoved(TimedElement timedElement) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((TimegraphListener)iterator.next()).elementRemoved(timedElement);
        }
    }

    boolean shouldPropagate(Interval interval, TimingSpecifier timingSpecifier, boolean bl) {
        InstanceTime instanceTime;
        InstanceTime instanceTime2 = instanceTime = bl ? interval.getBeginInstanceTime() : interval.getEndInstanceTime();
        if (this.propagationFlags.contains((Object)instanceTime, (Object)timingSpecifier)) {
            return false;
        }
        this.propagationFlags.add((Object)instanceTime, (Object)timingSpecifier);
        return true;
    }

    protected void currentIntervalWillUpdate() {
    }

    protected abstract String getEventNamespaceURI(String var1);

    protected abstract String getEventType(String var1);

    protected abstract String getRepeatEventName();
}

