/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteWrangler {
    private static Logger logger = LoggerFactory.getLogger((String)ByteWrangler.class.getName());
    public static final int MAX_VALUE_LENGTH = 255;
    public static final int MAX_DATA_LENGTH = 256;
    public static final byte[] NO_VALUE = new byte[0];
    public static final byte[] EMPTY_TXT = new byte[]{0};
    public static final String CHARSET_NAME = "UTF-8";
    private static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");

    public static void writeUTF(OutputStream out, String str) throws IOException {
        byte[] utf8Bytes = str.getBytes(CHARSET_UTF_8);
        out.write(utf8Bytes);
    }

    public static String readUTF(byte[] data) {
        return ByteWrangler.readUTF(data, 0, data.length);
    }

    public static String readUTF(byte[] data, int off, int len) {
        return new String(data, off, len, CHARSET_UTF_8);
    }

    public static void readProperties(Map<String, byte[]> properties, byte[] textBytes) throws Exception {
        if (textBytes != null) {
            int len;
            for (int off = 0; off < textBytes.length; off += len) {
                int i;
                if ((len = textBytes[off++] & 0xFF) == 0 || off + len > textBytes.length) {
                    properties.clear();
                    break;
                }
                for (i = 0; i < len && textBytes[off + i] != 61; ++i) {
                }
                String name = ByteWrangler.readUTF(textBytes, off, i);
                if (name == null) {
                    properties.clear();
                    break;
                }
                if (i == len) {
                    properties.put(name, NO_VALUE);
                    continue;
                }
                byte[] value = new byte[len - ++i];
                System.arraycopy(textBytes, off + i, value, 0, len - i);
                properties.put(name, value);
            }
        }
    }

    public static byte[] textFromProperties(Map<String, ?> props) {
        byte[] text = null;
        if (props != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                for (Map.Entry<String, ?> entry : props.entrySet()) {
                    byte[] data;
                    String key = entry.getKey();
                    Object val = entry.getValue();
                    ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                    ByteWrangler.writeUTF(out2, key);
                    if (val != null) {
                        if (val instanceof String) {
                            out2.write(61);
                            ByteWrangler.writeUTF(out2, (String)val);
                        } else if (val instanceof byte[]) {
                            byte[] bval = (byte[])val;
                            if (bval.length > 0) {
                                out2.write(61);
                                out2.write(bval, 0, bval.length);
                            } else {
                                val = null;
                            }
                        } else {
                            throw new IllegalArgumentException("Invalid property value: " + val);
                        }
                    }
                    if ((data = out2.toByteArray()).length > 255) {
                        logger.warn("Cannot have individual values larger that 255 chars. Offending value: {}", (Object)(key + (val == null ? "" : "=" + val)));
                        return EMPTY_TXT;
                    }
                    out.write((byte)data.length);
                    out.write(data, 0, data.length);
                }
                text = out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception: " + e);
            }
        }
        return text != null && text.length > 0 ? text : EMPTY_TXT;
    }

    public static byte[] encodeText(String text) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
        ByteWrangler.writeUTF(out2, text);
        byte[] data = out2.toByteArray();
        if (data.length > 255) {
            logger.warn("Cannot have individual values larger that 255 chars. Offending value: {}", (Object)text);
            return EMPTY_TXT;
        }
        out.write((byte)data.length);
        out.write(data, 0, data.length);
        byte[] encodedText = out.toByteArray();
        return encodedText.length > 0 ? encodedText : EMPTY_TXT;
    }
}

