"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const flatten_1 = require("../flatten");
describe('flattenArray', () => {
    it('works on array with one element', () => {
        expect(flatten_1.flattenArray([[1, 2, 3]])).toEqual([1, 2, 3]);
    });
    it('works on array with multiple elements', () => {
        expect(flatten_1.flattenArray([[1], [2, 3], [4]])).toEqual([1, 2, 3, 4]);
    });
});
describe('flattenObjectValues', () => {
    it('flatten object values', () => {
        expect(flatten_1.flattenObjectValues({
            'foo.sh': [1],
            'baz.sh': [2],
        })).toEqual([1, 2]);
    });
});
//# sourceMappingURL=flatten.test.js.map