/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import joptsimple.internal.Column;
import joptsimple.internal.ColumnWidthCalculator;

public class ColumnarData {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int TOTAL_WIDTH = 80;
    private final ColumnWidthCalculator widthCalculator = new ColumnWidthCalculator();
    private final List columns = new LinkedList();
    private final String[] headers;

    public ColumnarData(String[] headers) {
        this.headers = (String[])headers.clone();
        this.clear();
    }

    public void addRow(Object[] rowData) {
        int[] numberOfCellsAddedAt = this.addRowCells(rowData);
        this.addPaddingCells(numberOfCellsAddedAt);
    }

    public String format() {
        StringBuffer buffer = new StringBuffer();
        this.writeHeadersOn(buffer);
        this.writeSeparatorsOn(buffer);
        this.writeRowsOn(buffer);
        return buffer.toString();
    }

    public final void clear() {
        this.columns.clear();
        int desiredColumnWidth = this.widthCalculator.calculate(80, this.headers.length);
        for (int i = 0; i < this.headers.length; ++i) {
            this.columns.add(new Column(this.headers[i], desiredColumnWidth));
        }
    }

    private void writeHeadersOn(StringBuffer buffer) {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            ((Column)iter.next()).writeHeaderOn(buffer, iter.hasNext());
        }
        buffer.append(LINE_SEPARATOR);
    }

    private void writeSeparatorsOn(StringBuffer buffer) {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            ((Column)iter.next()).writeSeparatorOn(buffer, iter.hasNext());
        }
        buffer.append(LINE_SEPARATOR);
    }

    private void writeRowsOn(StringBuffer buffer) {
        int maxHeight = ((Column)Collections.max(this.columns, Column.BY_HEIGHT)).height();
        for (int i = 0; i < maxHeight; ++i) {
            this.writeRowOn(buffer, i);
        }
    }

    private void writeRowOn(StringBuffer buffer, int rowIndex) {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            ((Column)iter.next()).writeCellOn(rowIndex, buffer, iter.hasNext());
        }
        buffer.append(LINE_SEPARATOR);
    }

    private int max(int[] numbers) {
        int maximum = Integer.MIN_VALUE;
        for (int i = 0; i < numbers.length; ++i) {
            maximum = Math.max(maximum, numbers[i]);
        }
        return maximum;
    }

    private int[] addRowCells(Object[] rowData) {
        int[] cellsAddedAt = new int[rowData.length];
        Iterator iter = this.columns.iterator();
        for (int i = 0; iter.hasNext() && i < rowData.length; ++i) {
            cellsAddedAt[i] = ((Column)iter.next()).addCells(rowData[i]);
        }
        return cellsAddedAt;
    }

    private void addPaddingCells(int[] numberOfCellsAddedAt) {
        int maxHeight = this.max(numberOfCellsAddedAt);
        Iterator iter = this.columns.iterator();
        for (int i = 0; iter.hasNext() && i < numberOfCellsAddedAt.length; ++i) {
            Column nextColumn = (Column)iter.next();
            for (int j = 0; j < maxHeight - numberOfCellsAddedAt[i]; ++j) {
                nextColumn.addCell("");
            }
        }
    }
}

