"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.seq = exports.map = void 0;

var _Map = _interopRequireDefault(require("./Map"));

var _Pair = _interopRequireDefault(require("./Pair"));

var _Seq = _interopRequireDefault(require("./Seq"));

var _string = require("./_string");

var _parseMap = _interopRequireDefault(require("./parseMap"));

var _parseSeq = _interopRequireDefault(require("./parseSeq"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function createMap(schema, obj, wrapScalars) {
  const map = new _Map.default();

  if (obj instanceof Map) {
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = obj[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const _step$value = _slicedToArray(_step.value, 2),
              key = _step$value[0],
              value = _step$value[1];

        const k = schema.createNode(key, wrapScalars);
        const v = schema.createNode(value, wrapScalars);
        map.items.push(new _Pair.default(k, v));
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }
  } else if (obj && typeof obj === 'object') {
    map.items = Object.keys(obj).map(key => {
      const k = schema.createNode(key, wrapScalars);
      const v = schema.createNode(obj[key], wrapScalars);
      return new _Pair.default(k, v);
    });
  }

  return map;
}

function createSeq(schema, obj, wrapScalars) {
  const seq = new _Seq.default();

  if (obj && obj[Symbol.iterator]) {
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = obj[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        const it = _step2.value;
        const v = schema.createNode(it, wrapScalars);
        seq.items.push(v);
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }
  }

  return seq;
}

const map = {
  createNode: createMap,
  default: true,
  nodeClass: _Map.default,
  tag: 'tag:yaml.org,2002:map',
  resolve: _parseMap.default,
  stringify: (value, ctx, onComment, onChompKeep) => value.toString(ctx, onComment, onChompKeep)
};
exports.map = map;
const seq = {
  createNode: createSeq,
  default: true,
  nodeClass: _Seq.default,
  tag: 'tag:yaml.org,2002:seq',
  resolve: _parseSeq.default,
  stringify: (value, ctx, onComment, onChompKeep) => value.toString(ctx, onComment, onChompKeep)
};
exports.seq = seq;
var _default = [map, seq, _string.str];
exports.default = _default;