/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.internal.InternalFlags;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

public final class BytecodeGen {
    static final Logger logger = Logger.getLogger(BytecodeGen.class.getName());
    static final ClassLoader GUICE_CLASS_LOADER = BytecodeGen.canonicalize(BytecodeGen.class.getClassLoader());
    static final String GUICE_INTERNAL_PACKAGE = BytecodeGen.class.getName().replaceFirst("\\.internal\\..*$", ".internal");
    private static final String CGLIB_PACKAGE = " ";
    private static final LoadingCache<ClassLoader, ClassLoader> CLASS_LOADER_CACHE;

    private static ClassLoader canonicalize(ClassLoader classLoader) {
        return classLoader != null ? classLoader : SystemBridgeHolder.SYSTEM_BRIDGE.getParent();
    }

    public static ClassLoader getClassLoader(Class<?> type2) {
        return BytecodeGen.getClassLoader(type2, type2.getClassLoader());
    }

    private static ClassLoader getClassLoader(Class<?> type2, ClassLoader delegate) {
        if (InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.OFF) {
            return delegate;
        }
        if (type2.getName().startsWith("java.")) {
            return GUICE_CLASS_LOADER;
        }
        if ((delegate = BytecodeGen.canonicalize(delegate)) == GUICE_CLASS_LOADER || delegate instanceof BridgeClassLoader) {
            return delegate;
        }
        if (Visibility.forType(type2) == Visibility.PUBLIC) {
            if (delegate != SystemBridgeHolder.SYSTEM_BRIDGE.getParent()) {
                return CLASS_LOADER_CACHE.getUnchecked(delegate);
            }
            return SystemBridgeHolder.SYSTEM_BRIDGE;
        }
        return delegate;
    }

    static {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder().weakKeys().weakValues();
        if (InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.OFF) {
            builder.maximumSize(0L);
        }
        CLASS_LOADER_CACHE = builder.build(new CacheLoader<ClassLoader, ClassLoader>(){

            @Override
            public ClassLoader load(final ClassLoader typeClassLoader) {
                logger.fine("Creating a bridge ClassLoader for " + typeClassLoader);
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return new BridgeClassLoader(typeClassLoader);
                    }
                });
            }
        });
    }

    private static class BridgeClassLoader
    extends ClassLoader {
        BridgeClassLoader() {
        }

        BridgeClassLoader(ClassLoader usersClassLoader) {
            super(usersClassLoader);
        }

        @Override
        protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
            if (name2.startsWith("sun.reflect") || name2.startsWith("jdk.internal.reflect")) {
                return SystemBridgeHolder.SYSTEM_BRIDGE.classicLoadClass(name2, resolve2);
            }
            if (name2.startsWith(GUICE_INTERNAL_PACKAGE) || name2.startsWith(BytecodeGen.CGLIB_PACKAGE)) {
                if (null == GUICE_CLASS_LOADER) {
                    return SystemBridgeHolder.SYSTEM_BRIDGE.classicLoadClass(name2, resolve2);
                }
                try {
                    Class<?> clazz = GUICE_CLASS_LOADER.loadClass(name2);
                    if (resolve2) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.classicLoadClass(name2, resolve2);
        }

        Class<?> classicLoadClass(String name2, boolean resolve2) throws ClassNotFoundException {
            return super.loadClass(name2, resolve2);
        }
    }

    public static enum Visibility {
        PUBLIC{

            @Override
            public Visibility and(Visibility that) {
                return that;
            }
        }
        ,
        SAME_PACKAGE{

            @Override
            public Visibility and(Visibility that) {
                return this;
            }
        };


        public static Visibility forMember(Member member) {
            Class<?>[] parameterTypes;
            if ((member.getModifiers() & 5) == 0) {
                return SAME_PACKAGE;
            }
            if (member instanceof Constructor) {
                parameterTypes = ((Constructor)member).getParameterTypes();
            } else {
                Method method = (Method)member;
                if (Visibility.forType(method.getReturnType()) == SAME_PACKAGE) {
                    return SAME_PACKAGE;
                }
                parameterTypes = method.getParameterTypes();
            }
            for (Class<?> type2 : parameterTypes) {
                if (Visibility.forType(type2) != SAME_PACKAGE) continue;
                return SAME_PACKAGE;
            }
            return PUBLIC;
        }

        public static Visibility forType(Class<?> type2) {
            return (type2.getModifiers() & 5) != 0 ? PUBLIC : SAME_PACKAGE;
        }

        public abstract Visibility and(Visibility var1);
    }

    private static class SystemBridgeHolder {
        static final BridgeClassLoader SYSTEM_BRIDGE = new BridgeClassLoader();

        private SystemBridgeHolder() {
        }
    }
}

