/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.TemporaryBuffer;

public class IO {
    public static final byte[] readFully(File path2) throws FileNotFoundException, IOException {
        return IO.readFully(path2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readSome(File path2, int limit) throws FileNotFoundException, IOException {
        int n2;
        FileInputStream in = new FileInputStream(path2);
        byte[] buf = new byte[limit];
        int cnt = 0;
        while ((n2 = in.read(buf, cnt, buf.length - cnt)) > 0) {
            cnt += n2;
        }
        if (cnt == buf.length) {
            byte[] n2 = buf;
            return n2;
        }
        byte[] res2 = new byte[cnt];
        System.arraycopy(buf, 0, res2, 0, cnt);
        byte[] byArray = res2;
        return byArray;
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readFully(File path2, int max2) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(path2);
        try {
            long sz = Math.max(path2.length(), 1L);
            if (sz > (long)max2) {
                throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path2));
            }
            byte[] buf = new byte[(int)sz];
            int valid = 0;
            while (true) {
                int n;
                if (buf.length == valid) {
                    if (buf.length == max2) {
                        int next2 = in.read();
                        if (next2 < 0) break;
                        throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path2));
                    }
                    byte[] nb = new byte[Math.min(buf.length * 2, max2)];
                    System.arraycopy(buf, 0, nb, 0, valid);
                    buf = nb;
                }
                if ((n = in.read(buf, valid, buf.length - valid)) < 0) break;
                valid += n;
            }
            if (valid < buf.length) {
                byte[] nb = new byte[valid];
                System.arraycopy(buf, 0, nb, 0, valid);
                buf = nb;
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static ByteBuffer readWholeStream(InputStream in, int sizeHint) throws IOException {
        int pos;
        int read2;
        byte[] out = new byte[sizeHint];
        for (pos = 0; pos < out.length; pos += read2) {
            read2 = in.read(out, pos, out.length - pos);
            if (read2 >= 0) continue;
            return ByteBuffer.wrap(out, 0, pos);
        }
        int last = in.read();
        if (last < 0) {
            return ByteBuffer.wrap(out, 0, pos);
        }
        TemporaryBuffer.Heap tmp = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
        tmp.write(out);
        tmp.write(last);
        tmp.copy(in);
        return ByteBuffer.wrap(tmp.toByteArray());
    }

    public static void readFully(InputStream fd, byte[] dst, int off, int len) throws IOException {
        while (len > 0) {
            int r = fd.read(dst, off, len);
            if (r <= 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            off += r;
            len -= r;
        }
    }

    public static int read(ReadableByteChannel channel, byte[] dst, int off, int len) throws IOException {
        int r;
        if (len == 0) {
            return 0;
        }
        int cnt = 0;
        while (0 < len && (r = channel.read(ByteBuffer.wrap(dst, off, len))) > 0) {
            off += r;
            len -= r;
            cnt += r;
        }
        return cnt != 0 ? cnt : -1;
    }

    public static int readFully(InputStream fd, byte[] dst, int off) throws IOException {
        int len;
        int r;
        for (len = 0; (r = fd.read(dst, off, dst.length - off)) >= 0 && len < dst.length; len += r) {
            off += r;
        }
        return len;
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }

    public static List<String> readLines(String s2) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\n') {
                l.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (c == '\r') {
                if (i + 1 < s2.length()) {
                    c = s2.charAt(++i);
                    l.add(sb.toString());
                    sb.setLength(0);
                    if (c == '\n') continue;
                    sb.append(c);
                    continue;
                }
                l.add(sb.toString());
                break;
            }
            sb.append(c);
        }
        l.add(sb.toString());
        return l;
    }

    public static String readLine(Reader in, int sizeHint) throws IOException {
        int i;
        StringBuilder buf;
        if (in.markSupported()) {
            if (sizeHint <= 0) {
                sizeHint = 1024;
            }
            StringBuilder sb = new StringBuilder(sizeHint);
            char[] buf2 = new char[sizeHint];
            while (true) {
                in.mark(sizeHint);
                int n = in.read(buf2);
                if (n < 0) {
                    in.reset();
                    return sb.toString();
                }
                for (int i2 = 0; i2 < n; ++i2) {
                    if (buf2[i2] != '\n') continue;
                    IO.resetAndSkipFully(in, ++i2);
                    sb.append(buf2, 0, i2);
                    return sb.toString();
                }
                if (n > 0) {
                    sb.append(buf2, 0, n);
                }
                IO.resetAndSkipFully(in, n);
            }
        }
        StringBuilder stringBuilder = buf = sizeHint > 0 ? new StringBuilder(sizeHint) : new StringBuilder();
        while ((i = in.read()) != -1) {
            char c = (char)i;
            buf.append(c);
            if (c != '\n') continue;
            break;
        }
        return buf.toString();
    }

    private static void resetAndSkipFully(Reader fd, long toSkip) throws IOException {
        fd.reset();
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }

    private IO() {
    }
}

