/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Scopes;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Description;
import org.eclipse.sisu.inject.Guice4;
import org.eclipse.sisu.inject.Implementations;
import org.eclipse.sisu.inject.Sources;

final class LazyBeanEntry<Q extends Annotation, T>
implements BeanEntry<Q, T> {
    private final Q qualifier;
    final Binding<T> binding;
    private final Provider<T> lazyValue;
    private final int rank;

    LazyBeanEntry(Q qualifier, Binding<T> binding2, int rank) {
        this.qualifier = qualifier != null && Named.class == qualifier.annotationType() ? new JsrNamed((Named)qualifier) : qualifier;
        this.binding = binding2;
        this.rank = rank;
        this.lazyValue = Scopes.isSingleton(binding2) ? binding2.getProvider() : Guice4.lazy(binding2);
    }

    @Override
    public Q getKey() {
        return this.qualifier;
    }

    @Override
    public T getValue() {
        return this.lazyValue.get();
    }

    @Override
    public T setValue(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Provider<T> getProvider() {
        return this.binding.getProvider();
    }

    @Override
    public String getDescription() {
        Description description = Sources.getAnnotation(this.binding, Description.class);
        return description != null ? description.value() : null;
    }

    @Override
    public Class<T> getImplementationClass() {
        return Implementations.find(this.binding);
    }

    @Override
    public Object getSource() {
        return Guice4.getDeclaringSource(this.binding);
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getKey()).append('=');
        try {
            Class<T> impl = this.getImplementationClass();
            buf.append(impl != null ? impl : this.getProvider());
        }
        catch (RuntimeException e2) {
            buf.append(e2);
        }
        return buf.toString();
    }

    private static final class JsrNamed
    implements Named,
    javax.inject.Named {
        private final String value;

        JsrNamed(Named named) {
            this.value = named.value();
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return javax.inject.Named.class;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof Named) {
                return this.value.equals(((Named)rhs).value());
            }
            if (rhs instanceof javax.inject.Named) {
                return this.value.equals(((javax.inject.Named)rhs).value());
            }
            return false;
        }

        @Override
        public String toString() {
            return "@" + javax.inject.Named.class.getName() + "(value=" + this.value + ")";
        }
    }
}

