/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.List;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.CsvParser;

public final class CsvProcessor
extends AbstractProcessor {
    public static final String TYPE = "csv";
    final String field;
    final String[] headers;
    final boolean trim;
    final char quote;
    final char separator;
    final boolean ignoreMissing;
    final Object emptyValue;

    CsvProcessor(String tag, String field, String[] headers, boolean trim, char separator, char quote, boolean ignoreMissing, Object emptyValue) {
        super(tag);
        this.field = field;
        this.headers = headers;
        this.trim = trim;
        this.quote = quote;
        this.separator = separator;
        this.ignoreMissing = ignoreMissing;
        this.emptyValue = emptyValue;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        if (this.headers.length == 0) {
            return ingestDocument;
        }
        String line = (String)ingestDocument.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (line == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (line == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        new CsvParser(ingestDocument, this.quote, this.separator, this.trim, this.headers, this.emptyValue).process(line);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public CsvProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty((String)CsvProcessor.TYPE, (String)processorTag, config, (String)"field");
            String quote = ConfigurationUtils.readStringProperty((String)CsvProcessor.TYPE, (String)processorTag, config, (String)"quote", (String)"\"");
            if (quote.length() != 1) {
                throw ConfigurationUtils.newConfigurationException((String)CsvProcessor.TYPE, (String)processorTag, (String)"quote", (String)"quote has to be single character like \" or '");
            }
            String separator = ConfigurationUtils.readStringProperty((String)CsvProcessor.TYPE, (String)processorTag, config, (String)"separator", (String)",");
            if (separator.length() != 1) {
                throw ConfigurationUtils.newConfigurationException((String)CsvProcessor.TYPE, (String)processorTag, (String)"separator", (String)"separator has to be single character like , or ;");
            }
            boolean trim = ConfigurationUtils.readBooleanProperty((String)CsvProcessor.TYPE, (String)processorTag, config, (String)"trim", (boolean)false);
            Object emptyValue = null;
            if (config.containsKey("empty_value")) {
                emptyValue = ConfigurationUtils.readObject((String)CsvProcessor.TYPE, (String)processorTag, config, (String)"empty_value");
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)CsvProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            List targetFields = ConfigurationUtils.readList((String)CsvProcessor.TYPE, (String)processorTag, config, (String)"target_fields");
            if (targetFields.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException((String)CsvProcessor.TYPE, (String)processorTag, (String)"target_fields", (String)"target fields list can't be empty");
            }
            return new CsvProcessor(processorTag, field, targetFields.toArray(new String[0]), trim, separator.charAt(0), quote.charAt(0), ignoreMissing, emptyValue);
        }
    }
}

