/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.antlr;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.antlr.PainlessLexer;
import org.elasticsearch.painless.lookup.PainlessLookup;

final class EnhancedPainlessLexer
extends PainlessLexer {
    private final String sourceName;
    private final PainlessLookup painlessLookup;
    private Token current = null;

    EnhancedPainlessLexer(CharStream charStream, String sourceName, PainlessLookup painlessLookup) {
        super(charStream);
        this.sourceName = sourceName;
        this.painlessLookup = painlessLookup;
    }

    public Token nextToken() {
        this.current = super.nextToken();
        return this.current;
    }

    public void recover(LexerNoViableAltException lnvae) {
        CharStream charStream = lnvae.getInputStream();
        int startIndex = lnvae.getStartIndex();
        String text = charStream.getText(Interval.of((int)startIndex, (int)charStream.index()));
        Location location = new Location(this.sourceName, this._tokenStartCharIndex);
        String message = "unexpected character [" + this.getErrorDisplay(text) + "].";
        char firstChar = text.charAt(0);
        if ((firstChar == '\'' || firstChar == '\"') && text.length() - 2 > 0 && text.charAt(text.length() - 2) == '\\') {
            message = message + " The only valid escape sequences in strings starting with [" + firstChar + "] are [\\\\] and [\\" + firstChar + "].";
        }
        throw location.createError(new IllegalArgumentException(message, (Throwable)lnvae));
    }

    @Override
    protected boolean isType(String name) {
        return this.painlessLookup.isValidCanonicalClassName(name);
    }

    @Override
    protected boolean slashIsRegex() {
        Token lastToken = this.current;
        if (lastToken == null) {
            return true;
        }
        switch (lastToken.getType()) {
            case 6: 
            case 8: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 84: {
                return false;
            }
        }
        return true;
    }
}

