/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import org.apache.lucene.spatial.spatial4j.Geo3dRectangleShape;
import org.apache.lucene.spatial.spatial4j.Geo3dShape;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoPointShape;
import org.apache.lucene.spatial3d.geom.GeoPointShapeFactory;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class Geo3dPointShape
extends Geo3dShape<GeoPointShape>
implements Point {
    public Geo3dPointShape(GeoPointShape shape, SpatialContext spatialcontext) {
        super(shape, spatialcontext);
        this.center = this;
    }

    public void reset(double x, double y) {
        this.shape = GeoPointShapeFactory.makeGeoPointShape((PlanetModel)((GeoPointShape)this.shape).getPlanetModel(), (double)(y * (Math.PI / 180)), (double)(x * (Math.PI / 180)));
        this.center = this;
        this.boundingBox = null;
    }

    public double getX() {
        return ((GeoPointShape)this.shape).getCenter().getLongitude() * 57.29577951308232;
    }

    public double getY() {
        return ((GeoPointShape)this.shape).getCenter().getLatitude() * 57.29577951308232;
    }

    @Override
    public Rectangle getBoundingBox() {
        Rectangle bbox = this.boundingBox;
        if (bbox == null) {
            this.boundingBox = bbox = new Geo3dRectangleShape((GeoBBox)this.shape, this.spatialcontext);
        }
        return bbox;
    }

    @Override
    public Shape getBuffered(double distance, SpatialContext spatialContext) {
        return spatialContext.getShapeFactory().circle(this.getX(), this.getY(), distance);
    }

    @Override
    public boolean hasArea() {
        return false;
    }
}

