/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import org.bouncycastle.gpg.keybox.Blob;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class FirstBlob
extends Blob {
    private final int headerFlags;
    private final long fileCreatedAt;
    private final long lastMaintenanceRun;

    private FirstBlob(int base, long length, BlobType type, int version, int headerFlags, long fileCreatedAt, long lastMaintenanceRun) {
        super(base, length, type, version);
        this.headerFlags = headerFlags;
        this.fileCreatedAt = fileCreatedAt;
        this.lastMaintenanceRun = lastMaintenanceRun;
    }

    static FirstBlob parseContent(int base, long length, BlobType type, int version, KeyBoxByteBuffer buffer) throws IOException {
        int headerFlags = buffer.u16();
        byte[] magic = new byte[4];
        buffer.bN(magic);
        if (!Arrays.areEqual((byte[])magic, (byte[])magicBytes)) {
            throw new IOException("Incorrect magic expecting " + Hex.toHexString((byte[])magicBytes) + " but got " + Hex.toHexString((byte[])magic));
        }
        buffer.u32();
        long fileCreatedAt = buffer.u32();
        long lastMaintenanceRun = buffer.u32();
        buffer.u32();
        buffer.u32();
        return new FirstBlob(base, length, type, version, headerFlags, fileCreatedAt, lastMaintenanceRun);
    }

    public int getHeaderFlags() {
        return this.headerFlags;
    }

    public long getFileCreatedAt() {
        return this.fileCreatedAt;
    }

    public long getLastMaintenanceRun() {
        return this.lastMaintenanceRun;
    }
}

